// Module PI : Peida Interactive     PIGraphicUC 
// Trace graphiques User-Coordinates    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICUC_H_SEEN
#define PIGRAPHICUC_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"

enum {
  kAxeDirSame     = 0,
  kAxeDirLtoR     = 1,
  kAxeDirRtoL     = 2,
  kAxeDirDownUp   = 4,
  kAxeDirUpDown   = 8,
  kAxeDirAuto     = 255
};

class PIGraphicUC : public PIGraphicGen
{
public:
                     PIGraphicUC(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual           ~PIGraphicUC();

  virtual int        kind();

  virtual void       SetBaseGraphic(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);

//  Espace des coordonnees
  virtual void       GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax);

//  Definition des coordonnees utilisateur
  virtual void       SetUCS(double xmin, double xmax, double ymin, double ymax,
                            int axrl=kAxeDirSame, int ayud=kAxeDirSame);     
// Echelle logarithmique
  virtual void	     SetLogScale(bool logx, bool logy);
  inline  bool	     isLogScaleX() { return aXlog; }
  inline  bool	     isLogScaleY() { return aYlog; }
  inline  bool       isAxeXDirRtoL()   { return aXdir; }
  inline  bool       isAxeYDirUpDown() { return aYdir; }

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0);
  virtual void       DrawCompString(PIGrCoord x, PIGrCoord y, const char* s, 
                                    const char* s_up, const char* s_dn, unsigned long pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true); 
  virtual void       DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy,
                             double degdeb, double degfin);
  virtual void       DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                              double degdeb, double degfin);
 
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawArrowMarker(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);

  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelLine(PILineAtt const& att);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

// Modification de fonte
  virtual void       SelFont(PIFont & fnt);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
//  Fonctions specifiques a PIGraphicUC :
  virtual void       SelFontSz(PIGrCoord sz, PIFontAtt att=PI_RomanFont);
  virtual void       SelMarkerSz(PIGrCoord msz, PIMarker mrk=PI_DotMarker);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

  virtual PIGrCoord  GetFontHeight(PIGrCoord& asc, PIGrCoord& desc);
  virtual PIGrCoord  CalcStringWidth(char const* s);


// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

//  Transformation des ccordonnees
  virtual void       UC2GrC(double x, double y, double& xpix, double& ypix);
  virtual void       GrC2UC(double xpix, double ypix, double& x, double& y);
  virtual void       DUC2GrC(double dx, double dy, double& dxpix, double& dypix);
  virtual void       DGrC2UC(double dxpix, double dypix, double& dx, double& dy);
  virtual void	     LinUC2GrC(double x, double y, double& xpix, double& ypix);
  virtual double     DeltaUCX(double x, double dx);
  virtual double     DeltaUCY(double y, double dy);

  void   NoClip() {clip = false; }
  void   Clip() {clip = true; }
  inline PIGraphicGen*  BaseGraphic() { return(mGrC); }

protected:

  PIGraphicGen* mGrC;

  double xMin, xMax, yMin, yMax; // Valeurs en unites user
  double xOrg, yOrg;             // Position en pixels de (0.0, 0.0)
  double xScale, yScale;         // Pixels par unites graphiques
  double xMinLog, yMinLog;       // Limite basse (>0,x,yMin) pour echelle log
  double xOrgLog, yOrgLog;       // Position en pixels de log10(xyMinLog)
  double xScaleLog, yScaleLog;   // Pixels par unites graphiques Echelle Log
  double xW0, yW0, xWd, yWd;     // Origine/largeur ds la fenetre de trace
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 
  bool   aXlog, aYlog;		 // true-> Echelle logarithmique pour axe X,y 
  bool   clip;
};


#endif
