// Module PI : Peida Interactive     PIGraphic 
// Primitives de trace graphiques    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

// Classe generique de trace graphique de base (Ne peut etre instancie)

#include "pigraphgen.h"
#include <math.h>

//++
// Class	PILineAtt
// Lib		PI
// include	pigraphgen.h
//--

/* --Methode-- */
PILineAtt::PILineAtt(PILineTypes ltyp)
{
  _lwidth = 2*8;
  _ldash=PI_LineSolid; 
  _ljoincap = PI_JoinMiter*PI_CapButt*256;
  switch (ltyp) {
    case PI_NotDefLineAtt :
      _lwidth = 0; _ldash=PI_LineSolid; 
      break;
    case PI_NormalLine : 
      _lwidth = 2*8; _ldash=PI_LineSolid; 
      break;
    case PI_ThinLine : 
      _lwidth = 8; _ldash=PI_LineSolid; 
      break;
    case PI_ThickLine : 
      _lwidth = 8*4; _ldash=PI_LineSolid; 
      break;
    case PI_DashedLine : 
      _lwidth = 2*8; _ldash=PI_LineDashed; 
      break;
    case PI_ThinDashedLine : 
      _lwidth = 8; _ldash=PI_LineDashed; 
      break;
    case PI_ThickDashedLine : 
      _lwidth = 8*4; _ldash=PI_LineDashed; 
      break;
    case PI_DottedLine : 
      _lwidth = 2*8; _ldash=PI_LineDotted; 
      break;
    case PI_ThinDottedLine : 
      _lwidth = 8; _ldash=PI_LineDotted; 
      break;
    case PI_ThickDottedLine : 
      _lwidth = 8*4; _ldash=PI_LineDotted; 
      break;
    case PI_DashDottedLine : 
      _lwidth = 2*8; _ldash=PI_LineDashDotted; 
      break;
    case PI_ThinDashDottedLine : 
      _lwidth = 8; _ldash=PI_LineDashDotted; 
      break;
    case PI_ThickDashDottedLine : 
      _lwidth = 8*4; _ldash=PI_LineDashDotted; 
      break;
    default :
      _lwidth = 0; _ldash=PI_LineSolid; 
      break;
    
  }
}

//++
// Class	PIGraphic
// Lib		PI
// include	pigraphgen.h
//
//   	Classe de base fournissant les services de trac graphique.
//   	La classe PIGraphicGen dfinit l'interface  travers des mthodes
//   	virtuelles pures. Les objets instancis doivent tre de la classe
//   	"PIGraphicWin" ou "PIGraphicUC" ou ...
//   	La classe "PIGraphicWin" a une implementation dpendante du systme 
//   	utilis (Mac, XWindow, ...). 
//   	Un type particulier *PIGrCoord* est dfini pour la spcification 
//	des coordonnes graphiques. 
//--
//++
// Links	Voir aussi
// PIGrCoord
// PIFont
// PIColorMap
//--

//++
// Titre	Constructeurs
//--
//++
// PIGraphic()
//	Constructeur utilis par les classes drives.
// PIGraphic(PIWdg* wdg)
//	Constructeur pour les *PIGraphicWin*. Objet "PIGraphic" capable 
//	de tracer dans un "PIWdg".
// PIGraphic(PIScreenBuffer* grb)
//	Constructeur pour objet "PIGraphic" capable de tracer dans un 
//	buffer graphique.
//--
//++
//--
// Titre	Mthodes
//++
// int  kind()
//	Renvoie le type de l'objet "PIGraphic" .
//	* PI_UnknownGraphics : Objet PIGraphic de type inconnue.
//	* PI_ScrBufferGraphics : Objet PIGraphic associ  un "GraphicBuffer"
//	* PI_ScrWindowGraphics : Objet PIGraphic associ  une fentre sur l'cran (PIWdg)
//	* PI_PSFileGraphics : Objet PIGraphic  un fichier PostScript (pour impression papier)
//	* PI_UCGraphics : Objet PIGraphic travaillant dans un systme de coordonnes utilisateur.
//	* PI_3DGraphics : Objet PIGraphic fournissant des mthodes de trac en coordonnes 3-D
// void  GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
//	Renvoie les limites de l'espace graphique - Coordonnes fentre pour un PIGraphicWin, 
//	Limites dfinies par l'utilisateur pour un PIGraphicUC
// void  Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy) 
//	Efface le rectangle dfini par le coin "x0,y0", de longeur et de largeur "dx,dy"
//	en utilisant la couleur d'arrire plan (Background)
//--


/* --Methode-- */
PIGraphicGen::PIGraphicGen()
{
myWdg = NULL;
myGrb = NULL;
SelArrowMarker();
}

/* --Methode-- */
PIGraphicGen::PIGraphicGen(PIWdg* wdg)
{
myWdg = wdg;
myGrb = NULL;
SelArrowMarker();
}

/* --Methode-- */
PIGraphicGen::PIGraphicGen(PIScreenBuffer* grb)
{
myWdg = NULL;
myGrb = grb;
SelArrowMarker();
}

/* --Methode-- */
PIGraphicGen::~PIGraphicGen()
{
}
/* --Methode-- */
int PIGraphicGen::kind() 
{
return PI_UnknownGraphics ;
}


/* --Methode-- */
void PIGraphicGen::GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
{
xmin = ymin = 0;  
xmax = ymax = 0;
if (myWdg) {
  xmax = myWdg->XSize();
  ymax = myWdg->YSize();
  }
}

//++ 
// Titre	Tracs de texte
//--
//++
// void  DrawString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0)
//	Trace la chane de caractres "s"  la position "x,y", 
//	en utilisant la couleur d'avant-plan (Foreground)
//	La chaine est trace avec une justification a gauche, ou droite,
//	ou centree (horzontal) - bas, haut, milieu (vertical), en fonction de
//	de la valeur du flag "pos"
//|	PI_HorizontalLeft PI_HorizontalCenter PI_HorizontalRight
//|	PI_VerticalBottom PI_VerticalCenter PI_VerticalTop
// void  DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0) 
//	Trace la chane de caractres "s"  la position "x,y" . La couleur d'
//	arrire-plan est utilise pour remplir la zone rectangulaire occupe par
//	le trac de texte.
//	La chaine est trace avec une justification a gauche, ou droite,
//	ou centree (horzontal) - bas, haut, milieu (vertical), en fonction de
//	de la valeur du flag "pos"
//|	PI_HorizontalLeft PI_HorizontalCenter PI_HorizontalRight
//|	PI_VerticalBottom PI_VerticalCenter PI_VerticalTop
//--

/* --Methode-- */
void 
PIGraphicGen::DrawCompString(PIGrCoord x, PIGrCoord y, const char* s,
			     const char* s_up, const char* s_dn, unsigned long pos)
{
  if ((s_up == NULL) && (s_dn == NULL)) {
    if (s != NULL)  DrawString(x,y,s,pos);
    return;
  }

  int fh,fas,fds;
  fh = myFont.GetFontHeight(fas, fds);
  int sw_s = 0;
  if (s != NULL) sw_s = myFont.GetStringWidth(s);

  PIFont fnt_save(myFont);
  PIFont fnt_ss(myFont);
  fnt_ss.SetFontSzPt(2*myFont.GetFontSize()/3);

  int sw_sup = 0;
  if (s_up != NULL) sw_sup = fnt_ss.GetStringWidth(s_up);
  int sw_sdn = 0;
  if (s_dn != NULL) sw_sdn = fnt_ss.GetStringWidth(s_dn);

  PIGrCoord xs,ys; 
  int posh = pos & PI_HorizontalPosition;
  int posv = pos & PI_VerticalPosition;

  int dyu, dyd;
  dyu = -fh/2;  dyd = fh/2-fh/5; 
  if (posv == PI_VerticalBaseLine) {
    dyu = -fh/2;  dyd = fh/2-fh/5; 
    }
  else if (posv == PI_VerticalBottom) { 
    dyu = -fh/2-fds;  dyd = fh/2-fh/5-fds; 
    }
  else if (posv == PI_VerticalCenter) {
    dyu = -fds;  dyd = fh-fh/5-fds; 
  }
  else if (posv == PI_VerticalTop) {
    dyu = fh/2-fds;  dyd = 3*fh/2-fh/5-fds; 
  }

  int deltaposx = ((fh/8) > 0) ? fh/8 : 1;


  if ((pos == 0) || ((posh == PI_HorizontalLeft) && (posv == PI_VerticalBaseLine))) {
    xs = (int)x+sw_s;
    if (s != NULL)  DrawString(xs, y, s, PI_HorizontalRight);
    xs = (int)x+sw_s+deltaposx;
    ys = (int)y+dyu;
    SelFont(fnt_ss);
    if (s_up != NULL) DrawString(xs, ys, s_up, PI_HorizontalLeft);
    ys = (int)y+dyd;
    if (s_dn != NULL) DrawString(xs, ys, s_dn, PI_HorizontalLeft);
  }
  else {
    if (posh == PI_HorizontalRight) {
      int sw_ss_max = ( sw_sup > sw_sdn ) ? sw_sup : sw_sdn;
      xs = (int)x-sw_ss_max-deltaposx;
      if (s != NULL)  DrawString(xs, y, s, PI_HorizontalRight | posv);
      SelFont(fnt_ss);
      xs = (int)xs+deltaposx;
      ys = (int)y+dyu;
      if (s_up != NULL) DrawString(xs, ys, s_up, PI_HorizontalLeft);
      ys = (int)y+dyd;
      if (s_dn != NULL) DrawString(xs, ys, s_dn, PI_HorizontalLeft);      
    }
    else if (posh == PI_HorizontalCenter) {
      int sw_tot = sw_sup+sw_sdn+sw_s+deltaposx;
      xs = (int)x-sw_tot/2+sw_s; 
      if (s != NULL)  DrawString(xs, y, s, PI_HorizontalRight | posv);
      SelFont(fnt_ss);
      xs = (int)xs+deltaposx;
      ys = (int)y+dyu;
      if (s_up != NULL) DrawString(xs, ys, s_up, PI_HorizontalLeft);
      ys = (int)y+dyd;
      if (s_dn != NULL) DrawString(xs, ys, s_dn, PI_HorizontalLeft);            
    }
    else {
      xs = (int)x+sw_s;
      if (s != NULL)  DrawString(x, y, s, PI_HorizontalRight | posv);
      SelFont(fnt_ss);
      xs = (int)x+sw_s+deltaposx;
      ys = (int)y+dyu;
      if (s_up != NULL) DrawString(xs, ys, s_up, PI_HorizontalLeft);
      ys = (int)y+dyd;
      if (s_dn != NULL) DrawString(xs, ys, s_dn, PI_HorizontalLeft);
    }
  }
  SelFont(fnt_save);
  return;
}

//++ 
// Titre	Tracs de lignes et de figures gometriques
//--
//++
// void  DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
//	Trace une ligne entre les points de coordonnes "(x1,y1)" et "(x2,y2)", 
//	en utilisant la couleur d'avant-plan (Foreground)
// void  DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac du contour d'un rectangle dfini par la position du coin "(x0,y0)"
//	et de taille "dx,dy" avec la couleur d'avant-plan.
// void  DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'un rectangle plein, dfini par la position du coin "(x0,y0)"
//	et de taille "dx,dy" avec la couleur d'avant-plan.
// void  DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)  
//	Trac du contour d'un cercle centr en "(x0,y0)", de rayon "r"
// void  DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)  
//	Trac d'un cercle plein centr en "(x0,y0)", de rayon "r"
// void  DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'une ellipse incluse dans le rectangle "(x0,y0)" , "dx,dy"
// void  DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Trac d'une ellipse pleine incluse dans le rectangle "(x0,y0)" , "dx,dy"
// void  DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)
//	Trac du contour d'un polygone dfini par le tableau des "n" points "x,y".
//	Si "cinc==true", les coordonnes seront considres comme relatives
//	 la position du point "(x[0], y[0])". Dans le cas contraire, chaque couple
//	"(x[i], y[i])" reprsentera les coordonnes absolues d'un coin du polygone.
// void  DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)
//	Trac d'un polygone plein de la couleur d'avant-plan.
// void  DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, double degdeb, double degfin)
//	Trac d'un arc de cercle ou d'ellipse, inclu dans le "(x0,y0)" , "dx,dy" 
//	entre les angles (en degr) "degdeb" - "degfin" 
// void  DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, double degdeb, double degfin)
//	Trac d'un arc plein, inclu dans le "(x0,y0)" , "dx,dy" 
//	entre les angles (en degr) "degdeb" - "degfin" 
//--

//++ 
// Titre	Tracs de signes
//--
//++
// void  DrawMarker(PIGrCoord x0, PIGrCoord y0)  
//	Trac d'un signe au point "(x0,y0)". Le choix du signe trac s'effectue
//	 travers la mthode "SelMarker()"
// void  DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)
//	Trac de "n" signes aux points "(x[i],y[i])"
//--

/* --Methode-- */
void 
PIGraphicGen::DrawArrowMarker(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, bool fgline)
{
  double dx = (double)x2-(double)x1;
  double dy = (double)y2-(double)y1;
  double theta = atan2(dy, dx);

  PIGrCoord x[5], y[5];
  PIGrCoord x2l, y2l;
  bool fgfill = false;
  int npt = 3;
  double t0,tp,tm,asz;

  switch (myArrowMrk) {

  case PI_BasicArrowMarker :
    t0 = M_PI/4.;
    asz = (double)myArrowMrkSz/cos(t0);
    tp = theta+0.75*M_PI;
    tm = theta-0.75*M_PI;
    x[0] = (double)x2 + cos(tp)*asz;
    y[0] = (double)y2 + sin(tp)*asz;
    x[1] = x2;
    y[1] = y2;
    x[2] = (double)x2 + cos(tm)*asz;
    y[2] = (double)y2 + sin(tm)*asz;
    x2l = x2;  y2l =y2;
    fgfill = false;
    npt = 3;
    break;

  case PI_TriangleArrowMarker :
  case PI_FTriangleArrowMarker :
    t0 = M_PI/6.;
    asz = (double)myArrowMrkSz/cos(t0);
    tp = theta+5.*M_PI/6.;
    tm = theta-5.*M_PI/6.;
    x[0] = (double)x2 + cos(tp)*asz;
    y[0] = (double)y2 + sin(tp)*asz;
    x[1] = x2;
    y[1] = y2;
    x[2] = (double)x2 + cos(tm)*asz;
    y[2] = (double)y2 + sin(tm)*asz;
    x[3] = x[0];
    y[3] = y[0];
    x2l = (double)x2 - cos(theta)*myArrowMrkSz;
    y2l = (double)y2 - sin(theta)*myArrowMrkSz;
    npt = 4;
    if (myArrowMrk == PI_FTriangleArrowMarker)  fgfill = true;
    else  fgfill = false;
    break;

  case PI_ArrowShapedArrowMarker :
  case PI_FArrowShapedArrowMarker :
    t0 = M_PI/8.;
    asz = 2.*(double)myArrowMrkSz*cos(t0);
    tp = theta+7.*M_PI/8.;
    tm = theta-7.*M_PI/8.;
    x2l = (double)x2 - cos(theta)*myArrowMrkSz;
    y2l = (double)y2 - sin(theta)*myArrowMrkSz;
    x[0] = x2;  
    y[0] = y2;
    x[1] = (double)x2 + cos(tp)*asz;
    y[1] = (double)y2 + sin(tp)*asz;
    x[2] = x2l;
    y[2] = y2l;
    x[3] = (double)x2 + cos(tm)*asz;
    y[3] = (double)y2 + sin(tm)*asz;
    x[4] = x[0];
    y[4] = y[0];
    npt = 5;
    if (myArrowMrk == PI_FArrowShapedArrowMarker)  fgfill = true;
    else  fgfill = false;
    break;
    
  default:
    t0 = M_PI/4.;
    asz = (double)myArrowMrkSz/cos(t0);
    tp = theta+5.*M_PI/4.;
    tm = theta-5.*M_PI/4.;

    x[0] = (double)x2 + cos(tp)*asz;
    y[0] = (double)y2 + sin(tp)*asz;
    x[1] = x2;
    y[1] = y2;
    x[2] = (double)x2 + cos(tm)*asz;
    y[2] = (double)y2 + sin(tm)*asz;
    x[3] = x[0];
    y[3] = y[0];
    x2l = x2;  y2l =y2;
    fgfill = false;
    npt = 3;
    break;
  }

  if (fgline)  DrawLine(x1, y1, x2l, y2l);

  if (fgfill)  DrawFPolygon(x, y, npt, false);
  else  DrawPolygon(x, y, npt, false);
}

//++
// Titre	Trac d'images (pixmap)
//--
//++
// void  DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, int sx, int sy, PIColorMap* cmap)
//	Trac d'un pixmap dans un rectangle positionn en "(x,y)". Le tableau des pixels
//	"pix", de taille "sx,sy" reprsente les index dans la table de couleur "cmap".
//--

//++
// Titre	Modifications des attributs graphiques	
//--
//++
// void  SelForeground(PIColors col=PI_Black)
//	Choix de la couleur de trac d'avant-plan
//|	PI_Black , PI_White,  PI_Grey , PI_Red , PI_Blue , PI_Green ,  
//|	PI_Yellow , PI_Magenta , PI_Cyan , PI_Turquoise , PI_NavyBlue , 
//|	PI_Orange , PI_SiennaRed , PI_Purple , PI_LimeGreen , PI_Gold ,
//|	PI_ColorAllBits0 , PI_ColorAllBits1
// void  SelBackground(PIColors col=PI_White)
//	Choix de la couleur d'arrire-plan
// void  SelForeground(PIColorMap& cmap, int cid) 
//	Choix de la couleur de trac d'avant-plan: Couleur numro "cid" de la table de couleur "cmap"
// void  SelBackground(PIColorMap& cmap, int cid)
//	Choix de la couleur d'arrire-plan: Couleur numro "cid" de la table de couleur "cmap"
// void  SelGOMode(PIGOMode mod=PI_GOCopy) 
//	Choix du mode de trac graphique: "PI_GOCopy" ou "PI_GOXOR" ou 	"PI_GOInvert"
// void  SelLine(PILineAtt att=PI_NormalLine)
//	Choix du type de ligne pour le trac des lignes et contours
//|	PI_NormalLine, PI_ThinLine , PI_ThickLine
//|	PI_DashedLine, PI_ThinDashedLine, PI_ThickDashedLine
//|	PI_DottedLine, PI_ThinDottedLine, PI_ThickDottedLine
// void  SelMarker(int msz=3, PIMarker mrk=PI_DotMarker) 
//	Choix de la taille et du type de signe pour "DrawMarker() / DrawMarkers()"
//|	PI_DotMarker , PI_PlusMarker , PI_CrossMarker
//|	PI_CircleMarker , PI_FCircleMarker , PI_BoxMarker , PI_FBoxMarker
//|	PI_TriangleMarker , PI_FTriangleMarker , PI_StarMarker , PI_FStarMarker
//	(Les "StarMaker" ne sont pas encore implments  11/98) 
//--

//++
// Titre	Changement de fontes
//--
//++
// void  SelFont(PIFont & fnt)
//	Choix de fonte courant.
// void  SelFont(PIFontSize sz=PI_NormalSizeFont, PIFontAtt att=PI_RomanFont)
//	Changement de taille et attribut de fonte
//|	PI_SmallSizeFont , PI_NormalSizeFont , PI_BigSizeFont, PI_HugeSizeFont
//|	PI_RomanFont , PI_BoldFont , PI_ItalicFont 
// void  SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont)
//	Choix de taille de fonte avec spcification de taille en points 
//	(pixels sur l'cran)
// 
//--

void
PIGraphicGen::SelArrowMarker(int arrsz, PIArrowMarker arrmrk)
{
  if (arrsz > 0) myArrowMrkSz = arrsz;
  myArrowMrk = arrmrk;
}

//++
// Titre	Slection de la zone de trac (clip)	
//--
//++
// void  SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
//	Limite la zone de trac permise au rectangle "(x0,y0)", "dx,dy"
// void  ClearClipRectangle() 
//	Supprime si ncssaire la limitation de la zone de trac.	
//--

//++
// Titre	Accs aux attributs graphiques
//--
//++
// PIColors  GetForeground()
//	Renvoie la couleur de trac d'avant-plan courante. 
//	("PI_ColorFromMap" si dfini  partir d'une table de couleur
// PIColors  GetBackground()
//	Renvoie la couleur d'arrire-plan courante.
// PIGOMode  GetGOMode()
//	Renvoie le mode de trac graphique courante.
// PIFontAtt GetFontAtt()
//	Renvoie les attributs de la fonte courante.
// int GetFontSize() 
//	Renvoie la taille de la fonte courante.
// PILineAtt GetLineAtt() 
//	Renvoie le type de ligne courant
// PIMarker  GetMarker() 
//	Renvoie le type de signe (Marker) courant
// int GetMarkerSize()
//	Renvoie la taille des signes (Marker) pour le marker courant
// PIFont  GetFont()
//	Retourne une copie de l'objet "PIFont" courant.
// PIGrCoord  GetFontHeight(PIGrCoord& asc, PIGrCoord& desc);
//	Renvoie la hauteur des caractres, ainsi que la taille au dessus
//	et en-dessous de la ligne de base ("asc , desc") pour la fonte courante
//	dans le systme de coordonnes courant (Fentre ou UC).
// PIGrCoord CalcStringWidth(char const* s)
//	Renvoie la largeur occup par un texte s'il tait affich dans le 
//	systme de coordonnes courant (Fentre ou UC).
//--

/* --Methode-- */
PIArrowMarker PIGraphicGen::GetArrowMarker()
{
  return(myArrowMrk);
}

/* --Methode-- */
int PIGraphicGen::GetArrowMarkerSize()
{
  return(myArrowMrkSz);
}

/* --Methode-- */
PIGrCoord PIGraphicGen::GetFontHeight(PIGrCoord& asc, PIGrCoord& desc)
{
int t,a,d;
t = myFont.GetFontHeight(a, d);
asc = a;   desc = d;
return(t);
}

/* --Methode-- */
PIGrCoord PIGraphicGen::CalcStringWidth(char const* s)
{
return (myFont.GetStringWidth(s));
}

/* --Methode-- */
bool PIGraphicGen::CalcStringPositionShift(char const* s, unsigned long pos, 
					   int& dx, int& dy)
{
  dx = 0;
  dy = 0;
  if (pos == 0) return(false);
  else {
    int posh = pos & PI_HorizontalPosition;
    int posv = pos & PI_VerticalPosition;
    if ( ((posh == 0) &&  (posv == PI_VerticalBaseLine)) || 
	 ((posh == PI_HorizontalLeft) && (posv == 0)) ||
	 ((posh == PI_HorizontalLeft) && (posv == PI_VerticalBaseLine)) )
      return(false);
    if (posh != PI_HorizontalLeft) {
      int wx = myFont.GetStringWidth(s);
      if (posh == PI_HorizontalCenter)  dx = wx/2;
      else if (posh == PI_HorizontalRight)  dx = wx;
      else wx = 0;
    }
    if (posv != PI_VerticalBaseLine) {
      int asc,desc;
      int wy = myFont.GetFontHeight(asc, desc);
      if (posv == PI_VerticalBottom) dy = desc;
      else if (posv == PI_VerticalCenter)  dy = -wy/2+desc;
      else if (posv == PI_VerticalTop)  dy = -wy+desc;
      else dy = 0;
    }
    return(true);
  }
}


//++
// Titre	Sauvegarde et rappel des attributs graphiques
//--
//++
// void  SaveGraphicAtt()
//	Sauvegarde des attributs graphiques courants
// void  RestoreGraphicAtt()
//	Utilisation de l'ensemble des attributs graphiques sauvegards par un appel
//	 "SaveGraphicAtt()"
//--


/* --Methode-- */
void PIGraphicGen::SaveGraphicAtt()
{
  sFCol = GetForeground();
  sBCol = GetBackground();
  sGOm = GetGOMode();
  sFont = GetFont();   
  sLAtt = GetLineAtt();
  sMrk = GetMarker();   
  sMrkSz = GetMarkerSize();
  sArrowMrk = GetArrowMarker();
  sArrowMrkSz = GetArrowMarkerSize();
  return;
}

/* --Methode-- */
void PIGraphicGen::RestoreGraphicAtt()
{
  SelForeground(sFCol);
  SelBackground(sBCol);
  SelGOMode(sGOm);
  SelFont(sFont);
  SelLine(sLAtt);
  SelMarker(sMrkSz, sMrk);
  SelArrowMarker(sArrowMrkSz, sArrowMrk);
  return;
}




//++
// Class	PIGrCoord
// Lib		PI
// include	pigraphgen.h
//
//   	Classe utilis pour la spcifiaction de coordonnes graphique.
//	Des constructeurs et des mthodes de conversion  partir 
//	et vers des "int", "float" et "double" sont dfinis.
//	La valeur entiere d'un objet PIGrCoord construite  partir 
//	d'une valeur flottante (ou suite  une affectation) correpond
//	 l'entier le plus proche.
// 
//|	PIGrCoord gco = 3.14;
//|	int ic = gco;     // ic -> 3
//|	float fc = gco;   // fc -> 3.14
//|	gco = 1.1;        // (int)gco -> 1
//|	gco = 1.6;        // (int)gco -> 2
//|	gco = -0.4;       // (int)gco -> 0
//|	gco = -0.7;       // (int)gco -> -1
//--
//++
// Links	Voir aussi
// PIGraphic
//--

//++
// Titre	Constructeurs
//--
//++
// 
// PIGrCoord() 
//	Constructeur par dfaut ("intVal=floatVal=0")
// PIGrCoord(int a)
//	Constructeur  partir de l'entier "a"
// PIGrCoord(float a) 
//	Constructeur  partir de la valeur flottante "a"
// PIGrCoord(double a) 
//	Constructeur  partir de la valeur flottante double prcision "a"
//--
//++
// Titre	Oprateurs de conversion
//--
//++
// operator int() 
//	Conversion en entier "int"
// operator short() 
//	Conversion en entier "short"
// operator unsigned int() 
//	Conversion en entier non sign "unsigned int"
// operator unsigned short() 
//	Conversion en entier non sign "unsigned short"
// operator float() 
//	Conversion en rl "float"
// operator double() 
//	Conversion en rl "double"
//--
//++
// Titre	Oprateurs d'affectation
//--
//++
// PIGrCoord& operator= (int a) 
//	Affectation  partir de valeur entire "int"
// PIGrCoord& operator= (float a) 
//	Affectation  partir de valeur rlle "float"
// PIGrCoord& operator= (double a) 
//	Affectation  partir de valeur rlle double prcision "double"
//--
