//  Classe de base pour les objets correspondant a une fenetre 
//  dans les programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>
#include <stdio.h>

#include "piwdggen.h"
#include "picontainergen.h"
#include "pievthandler.h"
#include "psfile.h"

//++
// Class	PIWdg
// Lib		PI
// include	piwdggen.h
//
//   	Classe de base pour tout objets correspondant  une fentre
//	 l'cran, ayant donc une reprsentation graphique et 
//	pouvant jouer un rle dans la hirarchie des objets interactif. 
//	*PIWdg* hrite de *PIMsgHandler*, avec une hirarchie correspondant
//	par dfaut  celles des PIWdg. La classe "PIWdg" est une des 
//	classes de PI qui ont une implementation dpendante du systeme utilis
//	(Mac, XWindow, ...). La classe "PIWdgGen" est la classe qui
//	dfinit l'interface, et ne doit pas tre instancie directement
//	(Mthodes virtuelles pures). Les objets instancis sont de la 
//	classes "PIWdg" et le fichier entte correspondant est "PIWDG_H"
//	dfini dans "pisysdep.h"
//--
//++
// Links	Parents
// PIMsgHandler
//--
//++
// Links	Voir aussi
// PIEventHandler
//--

//++
// Titre	Constructeur
//--
//++
// PIWdg(PIContainerGen *par, char *nom, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet contenu dans l'objet *PIContainer* "par", de
//	taille "sx,sy", se trouvant  la position "px,py" avec le nom "nom"
// long kind()
//	Renvoie le type de la classe de l'objet ("=PIWdgGen::ClassId") pour cette classe
//	de base. Doit tre redfinie par les classes drives.
//--  


//++
// Titre	Taille, position
//--
//++
// void  PSPrint(PSFile *psf, int ofx=0, int ofy=0)
//	Mthode virtuelle qui doit tre redfinie pour chacune des classes filles.
//	produit une reprsentation graphique de l'objet en Postscript.
// SetSize(int sx, int sy)
//	Modifie la taille de l'objet.
// SetPos(int px, int py)
//	Modifie la position de l'objet.
// int  XSize()  YSize()
//	Renvoient la taille (X,Y) de l'objet.
// int  XPos()  YPos()
//	Renvoient la position (X,Y) de l'objet.
// void  GetScreenPos(int & spx, int & spy)
//	Renvoie la position de l'objet sur l'cran.
//--
//++
// Titre	Gestion des accrochages (Binding)
//--
//++
// void  SetBinding(PIBindingKind left, PIBindingKind top, PIBindingKind right, PIBindingKind bottom)
//	Permet de contrler le comportement de l'objet en cas de changement de taille 
//	du conteneur parent. La position de chaque bord peut tre sans contrainte ("PIBK_free")
//	attache  une distance fixe par rapport au bord oppos du conteneur ("PIBK_fixed"), 
//	ou  une position proportionnelle  la taille du conteneur parent. ("PIBK_elastic") 
// bool  GetBinding((PIBindingKind& left, PIBindingKind& top, PIBindingKind& right, PIBindingKind& bottom)
//	Permet de connaitre l'tat des accrochages. Retourne "true" si les accrochages ont t
//	verrouill (appel  "LockBinding()"), "false" sinon.
// void  LockBinding()
//	Verrouille l'tat des accrochages. Appel  "SetBinding()" sera alors sans effet.
//	Permet  certains *LayouMgr* d'imposer une contrle strict.
// void  UnLockBinding()
//	Deverrouille les accrochages.
//--

//++
// Titre	Etat de l'objet
//	L'objet peut se trouver dans l'tat actif ou inactif. Cet tat est contrl par les 
//	mthodes "Manage(), UnManage()". L'objet ne se trouve effectivement dans l'tat 
//	actif que si son conteneur parent est lui mme actif.
//	L'objet peut aussi tre affichs, mais insensible aux actions utilisateur
//	(clavier, souris, ...). Cette sensibilit est controle par les 
//	mthodes  "SetSensitive(), SetUnSensitive()".
//--
//++
// void  Manage()  UnManage()
//	Change l'tat de l'objet (actif, inactif)
// bool  IfManaged()  IfVisible()
//	indique si l'objet est actif , visible	
// void  SetSensitive() SetUnSensitive()
//	Rend l'objet sensible/ insensible aux actions utilisateurs (clavier, souris, ...)
//	L'tat visuel de l'objet peut tre modifi en consquence.
// bool  IfSensitive() 
//	indique si l'objet est rpond aux sollicitations utilisateur.
//--

//++
// Titre	Rafrachissement de la fentre
//--
//++
// void  Refresh()
//	L'appel  cette mthode permet de retracer le contenu de la 
//	fentre et des "Drawer" associs.
//--

//++
// Titre	Mthodes
//--

//++
// void SetMsg(PIMessage msg = 0)
//	Modifie la valeur du message associ  l'objet.
// PIMessage  Msg()
//	Renvoie le message associ  l'objet.
// string  Nom()
//	Renvoie le nom associ  l'objet.
// PIWdg*  Parent()
//	Renvoie le conteneur parent de l'objet.
// void  SetUserData( void * p, int fg = 0)
//	Associe un pointeur de donnes  la disposition de l'utilisateur 
//	("void* p")  l'objet, ainsi qu'une valeur ("int fg")
// void* UserData()
//	Renvoie le pointeur de donnes user de l'objet. (NULL par dfaut)
// int  UserFlag()
//	Renvoie la valeur "int" user de l'objet.
//--

//++
// Titre	Gestion du copier/coller
//	L'ensemble des mthodes de gestion de copier/coller sont dcrites ici. Les mthodes
//	"SelectionLost()", "ProvideSelection()", et "PasteSelection()" doivent tre 
//	redfinies par les classes hritires de *PIWdg* implmentant la fonctionalit
//	copier/coller. Le mcanisme copier/coller entre objets d'une mme application,
//	ainsi qu'entre diffrentes applications. Dans les oprations de copier/coller,
//	il existe un PIWdg ou une application source des donnes et un PIWdg ou 
//	une application destinatire.
//--

//++
// bool  ClaimSelection(int typ=PICP_string)
//	Cette mthode doit tre appele par l'objet "PIWdg" source quand celui-ci veut 
//	s'approprier la zone d'change de donnes (Selection) pour le copier/coller. "typ" indique 
//	le type de donnes que peut fournir l'objet. Le type "PICP_string" (suite de caractres)
//	est le seul type support actuellement. La valeur de retour est "true" si 
//	la zone d'change est attribu a l'objet. Cette mthode ne doit en principe pas 
//	tre redfinie par les classes hritires de *PIWdg*.
// void  SelectionLost()
//	Cette mthode est appele quand l'objet "PIWdg" source qui possede la zone d'change 
//	(Selection) perd celle-ci, suite par exemple  la demande d'un autre objet. Cette mthode 
//	doit tre redfinies par les classes qui implmentent la fonctionalit et ne doit 
//	doit pas tre appele directement.
// int  RequestSelection(int typ=PICP_string)
//	Cette mthode doit tre appele par l'objet "PIWdg" destinatire quand celui-ci souhaite 
//	obtenir les donnes de la zone d'change (Selection). "typ" indique les types de donnes 
//	acceptables par l'objet. La valeur de retour indique le type qui sera fourni
//	( l'appel de "PasteSelection()"). Cette mthode ne doit en principe pas 
//	tre redfinie par les classes hritires de *PIWdg*.
// void* ProvideSelection(int& typ, int& len)  
//	Cette mthode est appele quand l'objet "PIWdg" source, qui possede la zone d'change 
//	(Selection) doit  fournir les donnes correspondantes  la slection. Renvoie le pointeur 
//	de la zone mmoire correspondante, sa longueur ("len") et le type ("typ") des donnes.
//	cette zone mmoire appartient  l'objet, et ne doit tre modifi tant que 
//	la mthode "SelectionTransferEnd()" n'a t appel.
// void  SelectionTransferEnd()
//	Cette mthode est appel une fois que l'objet ou l'application destinataire 
//	des donnes de slection a fini de traiter l'opration de copie. l'objet PIWdg 
//	source peut alors dtruire ou modifier les donnes correspondantes  l'change.
// void  PasteSelection(int typ, void *pdata, int l)
//	Cette mthode est appele aprs l'appel  "RequestSelection()" pour l'objet 
//	destinataire. "typ" indique le type des donnes dans "pdata", et "l" la longeur. 
//	La zone mmoire "pdata" n'appartient pas  l'objet destinataire et ne doit pas 
//	tre modifi par celui-ci. Une copie doit tre effectu si cesCette mthode  donnes devaient
//	tre utilises aprs la sortie de "PasteSelection()".
//--

/* --Methode-- */
PIWdgGen::PIWdgGen(PIContainerGen *par, char*, int, int, int, int)
: PIMsgHandler(par)
{
parent = par;
bindingLock = false;
SetMsg(0);
SetUserData(NULL, 0);
//  ChildAdd() doit etre appele par la classe qui implemente le widget
// if (par)  par->ChildAdd(this);   //  On previent le container parent  
return;
}


/* --Methode-- */
PIWdgGen::~PIWdgGen()
{
//  ChildDel() doit etre appele par la classe qui implemente le widget
// if (parent)  parent->ChildDel(this);   //  On previent le container parent 
list<EvHand>::iterator it;
for(it= mDHlist.begin(); it != mDHlist.end(); it++) 
  if ((*it).ad) delete (*it).evh;
for(it= mEHlist.begin(); it != mEHlist.end(); it++) 
  if ((*it).ad) delete (*it).evh;
}

/* --Methode-- */
void PIWdgGen::SetMsg(PIMessage msg)
{
myMsg = msg;
}

/* --Methode-- */
void PIWdgGen::GetScreenPos(int & spx, int & spy)
/*  Renvoie la position de la fenetre par rapport a l'ecran */
{
PIWdgGen * wc;
spx = 0;  spy = 0;
wc = this;

while (wc) 
  { spx += wc->XPos();  
  spy += wc->YPos();  wc = wc->Parent();
  }
return;
}

/* --Methode-- */
void PIWdgGen::LockBinding()
{
bindingLock = true;
}

/* --Methode-- */
void PIWdgGen::UnLockBinding()
{
bindingLock = false;
}

/* --Methode-- */
void PIWdgGen::PSPrint(PSFile *psf, int ofx, int ofy)
{
char str[256];

if (!psf) return;
psf->NewBloc((float)ofx+XPos(), (float)ofy+YPos(), (float)XSize(), (float)YSize(),
             (float)XSize(), (float)YSize());
psf->DrawBox(0., 0., (float)XSize(), (float)YSize());
sprintf(str,"PIWdgGen::PSPrint() Kind=%ld Name= %s", kind(), Nom().c_str());
psf->DrawString(12., 12., str, PI_Black, PI_RomanFont, 10);
psf->EndBloc();

return;
}

//++
// Titre	Gestion des Draw/Event Handler
//	Les objets de la classe "PIWdg" peuvent grer des objets "PIEventHandler" 
//	qui peuvent prendre en charge une partie du traitement des vnements
//	clavier-souris-cran.
//--

//++
// void AddDrawHandler(PIEventHandler* drwh, bool ad=false)
//	Ajout d'un objet gestionnaire d'vnements, responsable du trac du contenu de la fentre.
//	La mthode "Draw(PIGraphic* g, ...)" sera appel pour rafrachir le contenu de la fentre.
// void RemoveDrawHandler(PIEventHandler* drwh)
//	Suppression d'un objet gestionnaire de trac. Toutes les rferences sonnt supprimes en cas 
//	d' enregistrement multiple.
// void AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false)
//	Ajout d'un objet gestionnaire d'vnements. La variable "evtmask" dtermine pour
//	quels types d'vnements, la mthode "Process()" du gestionnaire est appele.
//|	PIEvent_Resize   (Non implement en version X11 , 12/98)
//|	PIEvent_Enter , PIEvent_Leave
//|	PIEvent_ButxPress, PIEvent_ButxRelease (x=1,2,3)
//|	PIEvent_PtrMove , PIEvent_PtrxMove (x=1,2,3)
//|	PIEvent_Keyboard
//
// void RemoveEventHandler(PIEventHandler* evh)
//	Suppression d'un gestionnaire d'vnements. Toutes les rferences sonnt supprimes en cas
//	d' enregistrement multiple, mme avec diffrents masques d'vnements.
//--

/* --Methode-- */
void PIWdgGen::AddDrawHandler(PIEventHandler* drwh, bool ad)
{
EvHand eh;
eh.evh = drwh; eh.mask = PIEvent_Draw;  eh.ad = ad;
mDHlist.push_back(eh);
}

/* --Methode-- */
void PIWdgGen::RemoveDrawHandler(PIEventHandler* drwh)
{
list<EvHand>::iterator it;
bool found = true;
while (found) {
  found = false;
  for(it= mDHlist.begin(); it != mDHlist.end(); it++) 
    if ((*it).evh == drwh) { mDHlist.erase(it); found = true; break; }
  }
}

/* --Methode-- */
void PIWdgGen::AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad)
{
EvHand eh;
eh.evh = evh; eh.mask = evtmask;  eh.ad = ad;
mEHlist.push_back(eh);
}

/* --Methode-- */
void PIWdgGen::RemoveEventHandler(PIEventHandler* evh)
{
list<EvHand>::iterator it;
bool found = true;
while (found) {
  found = false;
  for(it= mEHlist.begin(); it != mEHlist.end(); it++) 
    if ((*it).evh == evh) { mEHlist.erase(it); found = true; break; }
  }
}


/* --Methode-- 
string PIWdgGen::kindstr()
{
char b[5];
string s;

b[0] = (char) (kind()&0x000000FF);
b[1] = (char) ((kind()&0x0000FF00) / 0x100);
b[2] = (char) ((kind()&0x00FF0000) / 0x10000);
b[3] = (char) ((kind()&0xFF000000) / 0x1000000);
b[4] = '\0';
s = b;
return(s);
}
*/

//++
// Class	PIScreenBuffer
// Lib		PI
// include	piwdggen.h
//
//	Classe de tampon de dessin hors cran. Permet la copie du contenu des pixels
//	depuis et vers des objets "PIWdg", ainsi que depuis et vers d'autres tampon
//	d'cran. Un objet "PIGraphic" peut-tre instanci pour fournir les services
//	de dessin dans un "PIScreenBuffer"
//--
//++
// Links	Voir aussi
// PIWdg
// PIGraphic
//--

//++
// Titre	Constructeurs, mthodes
//--
//++
// PIScreenBuffer(int sx, int sy)
//	Constructeur, cration d'un tampon de taille "sx * sy" pixels.
// int  XSize()
//	Renvoie la taille en X.
// int  YSize()
//	Renvoie la taille en Y.
//
//	Pour les oprations de copie, le rectangle source est dfini par
//	la position du coin haut-gauche "(ox,oy)" et la taille "dx * dy" en pixels.
//	La copie s'effectue sur l'objet destination  partir de l'offset "(x,y)".
//
// void CopyFromWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y)
//	Copie depuis l'objet "PIWdg* wdg".
// void CopyToWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y)
//	Copie vers l'objet "PIWdg* wdg".
// void CopyFrom(PIScreenBuffer* grb, int ox, int oy, int dx, int dy, int x, int y)
//	Copie depuis l'objet "PIScreenBuffer* grb"
//--
