// This may look like C code, but it is really -*- C++ -*-
// Gestionnaire de compilation-linker C++ - R. Ansari 10/2000
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef CXXCOMPILERLINKER_SEEN
#define CXXCOMPILERLINKER_SEEN

#include "machdefs.h"
#include <string>


namespace SOPHYA {

//! C++ compiler - linker
 
class CxxCompilerLinker {
public:
  CxxCompilerLinker(bool fglibsophya=true, bool fglibextsophya=true, 
					  bool fglibpi=false);  
  virtual		~CxxCompilerLinker();

  virtual int           Compile(string const & name, string & oname);
  virtual int           BuildSO(string const & oname, string & soname);

  inline void           AddCompileOptions(string const & opt)
  { compOptions += " " + opt; }
  inline void           SetCompileOptions(string const & opt = "")
  { compOptions = opt; }
  inline string         GetCompileOptions()
  { return compOptions; }

  inline void           AddLinkOptions(string const & opt)
  { linkOptions += " " + opt; }
  inline void           SetLinkOptions(string const & opt = "")
  { linkOptions = opt; }
  inline string         GetLinkOptions()
  { return linkOptions; }

  inline void        	SetTmpDir(string const & tmpdir)
  { tmpDir = tmpdir; }
  inline string        	GetTmpDir()
  { return tmpDir; }

  inline void           SetVerbose(bool fg=false)
  { verbose = fg; }

protected :
  string  tmpDir;
  string  compCmd;
  string  linkCmd;
  string  compOptions;
  string  linkOptions;
  string  cppFlags;  
  bool    verbose;
};

} // namespace SOPHYA

#endif
