// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIFontX
// LAL (Orsay) / IN2P3-CNRS          R. Ansari  99


#ifndef PIFONTX_H_SEEN
#define PIFONTX_H_SEEN

#include "pisysdep.h"
#include "pifontgen.h"


class PIFontX : public PIFontGen 
{
public :
		PIFontX(PIFontName fn = PI_DefaultFont);
		PIFontX(int npt, PIFontName fn = PI_DefaultFont, 
                        PIFontAtt fa = PI_RomanFont);
		PIFontX(PIFontX const & fnt);
  virtual	~PIFontX();

  virtual PIFontX & operator = (PIFontX const & fnt);
  virtual bool operator == (PIFontX const & fnt);

  virtual void		SetFont(PIFontName fn);
  virtual void		SetFontAtt(PIFontAtt fa);
  virtual void		SetFontSz(PIFontSize fs);
  virtual void		SetFontSzPt(int npt);

  virtual PIFontName    GetFontName() const ;
  virtual PIFontAtt     GetFontAtt() const ;
  virtual PIFontSize    GetFontSz() const;
  virtual int		GetFontSzPt() const ;

  virtual int		GetFontHeight(int& asc, int& desc) const ;
  virtual int		GetStringWidth(char const* s) const ;

// En public pour PIGraphicX
  inline Font		GetXFontId() { return(mFSt->fid); }

protected:
  void           SelectFont(PIFontName fn, PIFontAtt fa, PIFontSize fs);
  void           SelectFontPt(PIFontName fn, PIFontAtt fa, int npt);
  void           LoadFontSt(int isz, int jat, int kfn);
  static void    GlInit();

  PIFontName mFName;
  PIFontAtt mFAtt;
  int mFSize;
  XFontStruct *mFSt;
};

typedef PIFontX PIFont;

#endif      // PIFONTX_H_SEEN
