// This may look like C code, but it is really -*- C++ -*-
// Outils de manipulation des PIDrawer  R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>

#include "pidrwtools.h"
#include <iostream.h>
#include "piscdrawwdg.h"
#include "pi3ddrw.h"

//++
// Class	PIDrwTools
// Lib		PI
// include	pidrwtools.h
//
//	Classe de fentre de dialogue permettant de modifier interactivement
//	Les attributs graphique des "Drawer" attachs aux "PIBaseWdg".
//--
// Links	Parents
// PIWindow
//--
//++
// Links	Voir aussi
// PIDrawer
// PIBaseWdg
//--
//++
// Links	Ainsi que
// PIScDrawWdg
// PIImage
// PIDraw3DWdg
//--

//++
// Titre	Mthodes statiques
//--
//++
// void  ShowPIDrwTools() 	
//	Mthode statique permettant l'affichage de la fentre de contrle des
//	attributs graphiques des "Drawer". L'instance de la classe
//	 "PIDrwTools" est cre si ncessaire.
// void  HidePIDrwTools() 
//	Dsacative (cache) la fentre "PIDrwTools" (mthode statique).
// void  SetCurrentBaseWdg(PIBaseWdgGen* cbw)
//	Mthode statique permettant de slectionner le "PIBaseWdg" courant.
// PIBaseWdgGen*  GetCurrentBaseWdg()
//	Retourne le "PIBaseWdg" courant (mthode statique).
//--


PIDrwTools* PIDrwTools::cwdrwt = NULL;
PIBaseWdgGen* PIDrwTools::mCurBW = NULL;

/* --Methode-- */
void PIDrwTools::ShowPIDrwTools(PIBaseWdgGen* cbw) 
{
if (cwdrwt == NULL)  cwdrwt = new PIDrwTools(PIApplicationGetApp());
mCurBW = cbw;
cwdrwt->Show();
}

/* --Methode-- */
void PIDrwTools::ShowPIDrwTools() 
{
if (cwdrwt == NULL)  cwdrwt = new PIDrwTools(PIApplicationGetApp());
cwdrwt->Show();
}

/* --Methode-- */
void PIDrwTools::HidePIDrwTools() 
{
if (cwdrwt == NULL)  return; 
cwdrwt->Hide();
}

/* --Methode-- */
void PIDrwTools::SetCurrentBaseWdg(PIBaseWdgGen* cbw)
{
if (mCurBW == cbw) return;
mCurBW = cbw;
if (cwdrwt != NULL)
  cwdrwt->UpdateControlsFromDrawer(-9);
}

/* --Methode-- */
PIBaseWdgGen* PIDrwTools::GetCurrentBaseWdg()
{
return(mCurBW);
}

/* --Methode-- */
PIDrwTools::PIDrwTools(PIApplication* par)
: PIWindow((PIMsgHandler*)par, "PIDrawerTools", PIWK_normal, 240, 240, 150, 150)
{
int bsx, bsy, spx, spy;

// On definit la taille a partir de la taille par defaut des composantes 
// PIApplicationPrefCompSize(bsx, bsy);
par->PrefCompSize(bsx, bsy);
spx = bsx/10;
spy = bsy/4;

int wszx = 5*spx+3.5*bsx; 
int wszy = (2+5*0.85)*bsy+(7+5*0.85)*spy;
SetSize(wszx, wszy);

//int cpx = spx*2;
//int offy = cpy+bsy+spy*2;

//  Option-Menu  Marker, Line, couleur, etc...
int cpx = 2*spx;
int cpy = 2*spy;

int bsyo = bsy;  
int spyo = spy; 
bsy = 0.85*bsy;   spy = 0.85*spy;

mOpt[0] = new PIOptMenu(this, "bwt-opt-0", bsx*1.75, bsy, cpx, cpy);
mOpt[0]->AppendItem("Def.Col", 100);
mOpt[0]->AppendItem("Black", 101);
mOpt[0]->AppendItem("White", 102);
mOpt[0]->AppendItem("Grey", 103);
mOpt[0]->AppendItem("Red", 104);
mOpt[0]->AppendItem("Blue", 105);
mOpt[0]->AppendItem("Green", 106);
mOpt[0]->AppendItem("Yellow", 107);
mOpt[0]->AppendItem("Magenta", 108);
mOpt[0]->AppendItem("Cyan", 109);
mOpt[0]->AppendItem("Turquoise", 110);
mOpt[0]->AppendItem("NavyBlue", 111);
mOpt[0]->AppendItem("Orange", 112);
mOpt[0]->AppendItem("SiennaRed", 113);
mOpt[0]->AppendItem("Purple", 114);
mOpt[0]->AppendItem("LimeGreen", 115);
mOpt[0]->AppendItem("Gold", 116);
mOpt[0]->AppendItem("Violet", 117);
mOpt[0]->AppendItem("VioletRed", 118);
mOpt[0]->AppendItem("BlueViolet", 119);
mOpt[0]->AppendItem("DarkViolet", 120);
mOpt[0]->SetValue(100);
mOpt[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[1] = new PIOptMenu(this, "bwt-opt-1", bsx*1.75, bsy, cpx, cpy);
mOpt[1]->AppendItem("No.CMap", 200);
int kcc;
//  Groupement des tables de couleurs
mCasc[0] = new PIMenu(mOpt[1]->Menu(), "PIStd-128Col");
mCasc[1] = new PIMenu(mOpt[1]->Menu(), "MIDAS-CMap");

int nsct1,nsct2,nsct3;
//  D'abord les tables standard de PI  32 couleurs
nsct1 = 5;   // Les 5 premieres tables
for(kcc=0; kcc<nsct1; kcc++) 
  mOpt[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);
//  Ensuite les tables standard de PI  128 couleurs
nsct2 = 9;   // Les 4 tables suivantes
for(kcc=nsct1; kcc<nsct2; kcc++) 
  mCasc[0]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);
mOpt[1]->AppendPDMenu(mCasc[0]);
//  Apres les tables importees de MIDAS
nsct3 = PIColorMap::NumberStandardColorMaps()-1; // Les reste jusqu'a l'avant derniere
for(kcc=nsct2; kcc<nsct3; kcc++) 
  mCasc[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);
mOpt[1]->AppendPDMenu(mCasc[1]);
// Les tables qui restent ( Col16 , ... )
for(kcc=nsct3; kcc<PIColorMap::NumberStandardColorMaps(); kcc++) 
mOpt[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);

mOpt[1]->SetValue(200);
mOpt[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx = 2*spx;
cpy += spy+bsy;
mOpt[2] = new PIOptMenu(this, "bwt-opt-2", bsx*1.75, bsy, cpx, cpy);
mOpt[2]->AppendItem("Def.Mrk", 300);
mOpt[2]->AppendItem("Mrk Dot(.)", 301);
mOpt[2]->AppendItem("Mrk Plus(+)", 302);
mOpt[2]->AppendItem("Mrk Cross(x)", 303);
mOpt[2]->AppendItem("Mrk Circle", 304);
mOpt[2]->AppendItem("Mrk FCircle", 305);
mOpt[2]->AppendItem("Mrk Box", 306);
mOpt[2]->AppendItem("Mrk FBox", 307);
mOpt[2]->AppendItem("Mrk Triangle", 308);
mOpt[2]->AppendItem("Mrk FTriangle", 309);
mOpt[2]->AppendItem("Mrk Star", 310);
mOpt[2]->AppendItem("Mrk FStar", 311);
mOpt[2]->SetValue(300);
mOpt[2]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[3] = new PIOptMenu(this, "bwt-opt-3", bsx*1.75, bsy, cpx, cpy);
mOpt[3]->AppendItem("Mrk 1 pt", 401);
mOpt[3]->AppendItem("Mrk 3 pt", 403);
mOpt[3]->AppendItem("Mrk 5 pt", 405);
mOpt[3]->AppendItem("Mrk 7 pt", 407);
mOpt[3]->AppendItem("Mrk 9 pt", 409);
mOpt[3]->AppendItem("Mrk 11 pt", 411);
mOpt[3]->AppendItem("Mrk 13 pt", 413);
mOpt[3]->AppendItem("Mrk 15 pt", 415);
mOpt[3]->SetValue(405);
mOpt[3]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx = 2*spx;
cpy += spy+bsy;
mOpt[4] = new PIOptMenu(this, "bwt-opt-4", bsx*1.75, bsy, cpx, cpy);
mOpt[4]->AppendItem("Def.Font", 500);
mOpt[4]->AppendItem("Courier", 501);
mOpt[4]->AppendItem("Helvetica", 502);
mOpt[4]->AppendItem("Times", 503);
mOpt[4]->AppendItem("Symbol-Font", 504);
mOpt[4]->SetValue(500);
mOpt[4]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[5] = new PIOptMenu(this, "bwt-opt-5", bsx*1.75, bsy, cpx, cpy);
mOpt[5]->AppendItem("Def.Line", 600);
mOpt[5]->AppendItem("Thin-Line", 601);
mOpt[5]->AppendItem("Normal-Line", 602);
mOpt[5]->AppendItem("Thick-Line", 603);
mOpt[5]->AppendItem("ThinDashed", 604);
mOpt[5]->AppendItem("Dashed-Line", 605);
mOpt[5]->AppendItem("ThickDashed", 606);
mOpt[5]->AppendItem("ThinDotted", 607);
mOpt[5]->AppendItem("Dotted-Line", 608);
mOpt[5]->AppendItem("ThickDotted", 609);
mOpt[5]->AppendItem("ThinDashDott", 610);
mOpt[5]->AppendItem("DashDot-Line", 611);
mOpt[5]->AppendItem("ThickDashDott", 612);
mOpt[5]->SetValue(600);
mOpt[5]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx = 2*spx;
cpy += spy+bsy;
mOpt[6] = new PIOptMenu(this, "bwt-opt-6", bsx*1.75, bsy, cpx, cpy);
mOpt[6]->AppendItem("Def.FontAtt", 700);
mOpt[6]->AppendItem("Roman-Font", 701);
mOpt[6]->AppendItem("Bold-Font", 702);
mOpt[6]->AppendItem("Italic-Font", 703);
mOpt[6]->AppendItem("BoldItalic", 704);
mOpt[6]->SetValue(700);
mOpt[6]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += spx+1.75*bsx; 
mOpt[7] = new PIOptMenu(this, "bwt-opt-7", bsx*1.75, bsy, cpx, cpy);
mOpt[7]->AppendItem("Def.FontSz", 800);
mOpt[7]->AppendItem("Tiny FontSz", 801);
mOpt[7]->AppendItem("Small FontSz", 802);
mOpt[7]->AppendItem("Normal FontSz", 803);
mOpt[7]->AppendItem("Large FontSz", 804);
mOpt[7]->AppendItem("Huge FontSz", 805);
mOpt[7]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

int kb;
cpx = 2*spx;
cpy += spy+bsyo;
bsy = bsyo; spy = spyo;
mButdr[0] = new PIButton(this, "-", 1501, bsy, bsy, cpx, cpy);
cpx += bsy+0.25*spy;
mNlb = new PILabel(this,"NumDr", 1.2*bsy, bsy, cpx, cpy);
mNlb->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mNlb->SetLabel("");
mNDr = 0;
cpx += 1.2*bsy+0.25*spy;
mButdr[1] = new PIButton(this, "+", 1502, bsy, bsy, cpx, cpy);
mButdr[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mButdr[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
for(kb=0; kb<2; kb++) {
  mButdr[kb]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
  mButdr[kb]->SetUnSensitive();
}
cpx += bsy+2*spx; 
mDrName = new PILabel(this,"DrName", wszx-2*spx-cpx, bsy, cpx, cpy);
mDrName->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mDrName->SetLabel("No-Drawer");
mDrName->SetBorderWidth(1);

cpy += bsy+spy;
cpx = 2*spx;
int butszx = 0.7*bsx;
mButcf[0] = new PIButton(this, "GetAtt", 2500, butszx, bsy, cpx, cpy);
cpx += butszx+spx;
mButcf[1] = new PIButton(this, "SetAtt", 2600, butszx, bsy, cpx, cpy);
cpx += butszx+spx;
mButcf[2] = new PIButton(this, "Select", 2700, butszx, bsy, cpx, cpy);
mButcf[2]->ActivatePress(true);
cpx += butszx+spx;
butszx = wszx-cpx-2*spx;
mButcf[3] = new PIButton(this, "ShowControl", 2800, butszx, bsy, cpx, cpy);

butszx = 1.4*bsx;
cpx = (wszx-2*butszx-4*spx)/2;
cpy += 2*spy+bsy;
mButcf[4] = new PIButton(this, "Refresh", 3000, bsx*1.2, bsyo, cpx, cpy);
cpx += butszx+2*spx;
mButcf[5] = new PIButton(this, "Dismiss", 3777, butszx, bsyo, cpx, cpy);

for(kb=0; kb<6; kb++) 
  mButcf[kb]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
for(kb=0; kb<5; kb++) 
  mButcf[kb]->SetUnSensitive();

mButSens = 0;
cwdrwt = this;

}

/* --Methode-- */
PIDrwTools::~PIDrwTools()
{
if (cwdrwt == this)  cwdrwt = NULL;
int i;
for(i=0; i<6; i++) delete mButcf[i]; 
for(i=0; i<2; i++) delete mButdr[i]; 
for(i=0; i<8; i++)  delete mOpt[i];
for(i=0; i<2; i++)  delete mCasc[i];
delete mNlb;
delete mDrName;
}

//  Declaration des differents attributs graphiques 
#define MYNMXCOLORS 21
static PIColors cols[MYNMXCOLORS] = { PI_NotDefColor, 
                     PI_Black, PI_White, PI_Grey, 
                     PI_Red, PI_Blue, PI_Green, 
                     PI_Yellow, PI_Magenta, 
                     PI_Cyan , PI_Turquoise, PI_NavyBlue, 
                     PI_Orange, PI_SiennaRed, PI_Purple, 
                     PI_LimeGreen, PI_Gold, PI_Violet, PI_VioletRed,
                     PI_BlueViolet, PI_DarkViolet };

static PIMarker mrk[12] = { PI_NotDefMarker, PI_DotMarker, 
                            PI_PlusMarker, PI_CrossMarker,
                            PI_CircleMarker, PI_FCircleMarker,
                            PI_BoxMarker, PI_FBoxMarker,
                            PI_TriangleMarker, PI_FTriangleMarker,
                            PI_StarMarker, PI_FStarMarker };
static PILineTypes line[13] = { PI_NotDefLineAtt, PI_ThinLine, PI_NormalLine, PI_ThickLine, 
                              PI_ThinDashedLine, PI_DashedLine, PI_ThickDashedLine, 
			      PI_ThinDashDottedLine, PI_DashDottedLine, PI_ThickDashDottedLine,
                              PI_ThinDottedLine, PI_DottedLine, PI_ThickDottedLine };

static PIFontName fntname[5] = { PI_DefaultFont, PI_CourierFont, PI_HelveticaFont, 
				 PI_TimesFont, PI_SymbolFont};
static PIFontAtt fntatt[5] = { PI_NotDefFontAtt, PI_RomanFont, PI_BoldFont, 
			       PI_ItalicFont, PI_BoldItalicFont };
static PIFontSize fntsz[6] = { PI_NotDefFontSize, PI_TinySizeFont, PI_SmallSizeFont, 
			       PI_NormalSizeFont, PI_LargeSizeFont, PI_HugeSizeFont };

/* --Methode-- */
void PIDrwTools::Show()
{
PIWindow::Show();
UpdateControlsFromDrawer(-9);
UpdateAttFromDrawer();
return;
}

/* --Methode-- */
void PIDrwTools::UpdateControlsFromDrawer(int numdr)
{
  string lstr;
  int kb;
  int butsensnew = 0;

  PIDrawer * dr = NULL;
  
  if (mCurBW != NULL) {
    if (numdr < -1) { 
      if (mCurBW->NbDrawers() > 0)  mNDr = mCurBW->GetActiveDrawerNum();
      else mNDr = -1;
    }
    else { 
      if (mCurBW->NbDrawers() > 0) {
	mNDr = numdr;
	if (mNDr < 0)  mNDr = 0;
	else if (mNDr >= mCurBW->NbDrawers()) mNDr = mCurBW->NbDrawers()-1;
      }
      else mNDr = -1;
    }
    if (mNDr >= 0)   dr = mCurBW->GetDrawer(mNDr);
    if (dr != NULL)  butsensnew = 2;
    else butsensnew = 1;
  }

  if (butsensnew == 2) {
    char strg[64];
    sprintf(strg,"%d",mNDr);
    mNlb->SetLabel(strg);
    string wdrname = mCurBW->Nom()+":"+dr->Name();
    mDrName->SetLabel(wdrname);
    if ((dr != NULL) && dr->HasSpecificControlWindow()) 
      mButcf[3]->SetSensitive(); 
    else mButcf[3]->SetUnSensitive(); 	
  }
  else if (mButSens != butsensnew) {
    if(mButSens == 2)  mNlb->SetLabel("");
    if (butsensnew == 1)   mDrName->SetLabel(mCurBW->Nom());
    else  mDrName->SetLabel("No-BaseWdg");
  }

  if (butsensnew != mButSens) {
    if (butsensnew < 2) {
      for(kb=0; kb<2;kb++)  mButdr[kb]->SetUnSensitive();
      for(kb=0; kb<4;kb++)  mButcf[kb]->SetUnSensitive();
      if (butsensnew == 0) mButcf[4]->SetUnSensitive();
      else mButcf[4]->SetSensitive();
    }
    else { 
      for(kb=0; kb<2;kb++)  mButdr[kb]->SetSensitive();
      for(kb=0; kb<3;kb++)  mButcf[kb]->SetSensitive();
      mButcf[4]->SetSensitive();
    }
  }
  mButSens = butsensnew;
}    

/* --Methode-- */
void PIDrwTools::UpdateAttFromDrawer()
{

PIDrawer* dr = NULL;

mOpt[0]->SetValue(100);
mOpt[1]->SetValue(200);
mOpt[2]->SetValue(300);
mOpt[3]->SetValue(405);
mOpt[4]->SetValue(500);
mOpt[5]->SetValue(600);
mOpt[6]->SetValue(700);
mOpt[7]->SetValue(800);

if ( (mCurBW != NULL) && (mCurBW->NbDrawers() > 0) ) 
  dr = mCurBW->GetDrawer(mNDr);

if (!dr)  return;
int ii,jj,kk;
PIGraphicAtt const & gratt = dr->GetGraphicAtt();
PIColors fc = gratt.GetFgColor();
for(kk=0; kk<MYNMXCOLORS; kk++) 
  if (fc == cols[kk])  { mOpt[0]->SetValue(100+kk);  break; }    
CMapId cmi = gratt.GetColMapId();
if (cmi == CMAP_OTHER)  mOpt[1]->SetValue(200);
else for(kk=0; kk<PIColorMap::NumberStandardColorMaps(); kk++)
  if (cmi == PIColorMap::GetStandardColorMapId(kk)) { mOpt[1]->SetValue(201+kk);  break; }  
PIMarker mk = gratt.GetMarker();   
for(kk=0; kk<12; kk++) 
  if (mk == mrk[kk])   { mOpt[2]->SetValue(300+kk);  break; }
kk = gratt.GetMarkerSz();
if (kk < 1)  kk = 1;
if (kk > 15) kk = 15;
if (kk%2 == 0) kk++;
mOpt[3]->SetValue(400+kk);
PIFontName fnm = gratt.GetFontName();
PIFontAtt fat = gratt.GetFontAtt();
PIFontSize fsz = gratt.GetFontSz();

for(ii=0; ii<5; ii++)
  if (fnm ==  fntname[ii]) break;
for(kk=0; kk<5; kk++)
  if (fat ==  fntatt[kk]) break;
for(jj=0; jj<5; jj++) 
  if (fsz == fntsz[jj])  break;

if (ii >= 5) ii = 1;
if (kk >= 5) kk = 1;
if (jj >= 6) jj = 3;
mOpt[4]->SetValue(500+ii);
mOpt[6]->SetValue(700+kk);
mOpt[7]->SetValue(800+jj);

PILineAtt lat = gratt.GetLineAtt();
for(kk=0; kk<13; kk++)
  if (lat == line[kk])   { mOpt[5]->SetValue(600+kk);  break; }

return;
}

/* --Methode-- */
void PIDrwTools::SetGraphicAtt(bool fgref)
{
  if (mCurBW == NULL)   return;
  PIDrawer* drw = mCurBW->GetDrawer(mNDr);
  if (drw == NULL)  return;
  mCurBW->SetActiveDrawer(mNDr);
  PIGraphicAtt gratt;
  int k,ii,jj,kk;
  k = mOpt[0]->GetValue()-100;
  if ( (k < 0) || (k >= MYNMXCOLORS) )  k = 0;
  gratt.SetColAtt(cols[k]);
  k = mOpt[1]->GetValue()-200;
  if (k == 0) gratt.SetColMapId(CMAP_OTHER);
  else gratt.SetColMapId(PIColorMap::GetStandardColorMapId(k-1));
  k =  mOpt[2]->GetValue()-300;
  if ( (k < 0) || (k > 11) )  k = 0;
  kk =  mOpt[3]->GetValue()-400;
  if ( (kk < 1) || (kk > 27) )  kk = 1;
  //  if ((k > 0) && (kk < 3)) {  // Protection contre Marker taille 1 autre que Dotmarker
  //    mOpt[3]->SetValue(403);
  //   kk = 3;
  //  }
  gratt.SetMarkerAtt(kk, mrk[k]);
  ii =  (mOpt[4]->GetValue()-500);
  jj =  (mOpt[6]->GetValue()-700);
  kk =  (mOpt[7]->GetValue()-800);
  gratt.SetFontAtt(fntname[ii], fntsz[kk], fntatt[jj]);

  k =  mOpt[5]->GetValue()-600;
  if ( (k < 0) || (k > 12) )  k = 0;
  gratt.SetLineAtt(PILineAtt(line[k]));
  drw->SetGraphicAtt(gratt);
  if (fgref)  mCurBW->Refresh();
  else drw->Refresh();
}

/* --Methode-- */
void PIDrwTools::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{

  PIMessage mod = ModMsg(msg);
  msg = UserMsg(msg);

  switch (msg) {
    case 1501 :
    case 1502 :
      if (mCurBW && (mCurBW->NbDrawers() > 0)) {
	if (msg == 1501)  UpdateControlsFromDrawer(mNDr-1);
	else UpdateControlsFromDrawer(mNDr+1);
      }
      break;

    case 2500 :
      UpdateAttFromDrawer();
      break;

    case 2600 :
      SetGraphicAtt(false);
      break;

    case 2700 :
      if ((mCurBW != NULL) && (mCurBW->GetDrawer(mNDr) != NULL) ) {
	if (mod == PIMsg_Press)  { 
	  mCurBW->GetDrawer(mNDr)->HighLight(true);
	  mCurBW->SetActiveDrawer(mNDr);
	}
	else  mCurBW->GetDrawer(mNDr)->HighLight(false);
      }
      break;

    case 2800 :
      if ((mCurBW != NULL) && (mCurBW->GetDrawer(mNDr) != NULL) ) 
	mCurBW->GetDrawer(mNDr)->ShowControlWindow(mCurBW);
      break;

    case 3000 :
      SetGraphicAtt(true);
      break;

    case 3777 :
      Hide();
      break;

      /*   On ne change pas les options choisies   Reza+cmv 2/10/98  
	   mOpt[0]->SetValue(100);
	   mOpt[1]->SetValue(200);
	   mOpt[2]->SetValue(300);
	   mOpt[3]->SetValue(405);
	   mOpt[4]->SetValue(500);
	   mOpt[5]->SetValue(600);
    */
      break;

    default :
      break;
  }

return;
}



