// Module PI : Peida Interactive     PIGraphicAtt 
// PIGraphicAtt - Implementation     R. Ansari  2002
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pigratt.h"

PIGraphicAtt::PIGraphicAtt()
{
  SetColAtt();
  SetLineAtt();
  SetMarkerAtt(1);
  SetArrowMarkerAtt(5);
  SetColMapId();
}

PIGraphicAtt::PIGraphicAtt(PIGraphicAtt const & att)
{
  CopyFrom(att);
}

PIGraphicAtt::PIGraphicAtt(vector<string> & att, bool rmdecatt)
{
  // AFAIRE - Reza 18/02/2002 
  SetColAtt();
  SetLineAtt();
  SetMarkerAtt(1);
  SetArrowMarkerAtt(5);
  SetColMapId();
}

PIGraphicAtt::~PIGraphicAtt()
{
}

void PIGraphicAtt::CopyFrom(PIGraphicAtt const & att)
{
  mFCol = att.mFCol;
  mBCol = att.mBCol;
  mFnt = att.mFnt;
  mMSz = att.mMSz;
  mMrk = att.mMrk;
  mArrowMrkSz = att.mArrowMrkSz;
  mArrowMrk = att.mArrowMrk;
  mCmapid = att.mCmapid;
  mRevCmap = att.mRevCmap;
}

void PIGraphicAtt::UpdateFrom(PIGraphicAtt const & att)
{
  if (att.mFCol != PI_NotDefColor)  mFCol = att.mFCol;
  if (att.mBCol != PI_NotDefColor)  mBCol = att.mBCol;
  if ( (att.mFnt.GetFontName() != PI_DefaultFont) || 
       (att.mFnt.GetFontAtt() != PI_NotDefFontAtt) ||
       (att.mFnt.GetFontSize() != PI_NotDefFontSize) )  mFnt = att.mFnt;
  if (att.mMrk != PI_NotDefMarker) {
    mMSz = att.mMSz;
    mMrk = att.mMrk;
  }
  if (att.mArrowMrk != PI_NotDefArrowMarker) {
    mArrowMrkSz = att.mArrowMrkSz;
    mArrowMrk = att.mArrowMrk;
  }
  if (att.mCmapid != CMAP_OTHER) {
    mCmapid = att.mCmapid;
    mRevCmap = att.mRevCmap;
  }

}

void PIGraphicAtt::SetFontAtt(PIFontSize fsz, PIFontAtt fat)
{
  mFnt.SetFontAtt(fat);
  mFnt.SetFontSz(fsz);
}

void PIGraphicAtt::SetFontAtt(PIFontName fn, PIFontSize fsz, PIFontAtt fat)
{
  mFnt.SetFont(fn);
  mFnt.SetFontAtt(fat);
  mFnt.SetFontSz(fsz);
}
