// This may look like C code, but it is really -*- C++ -*-
// PIElDrawer - 
//                             R. Ansari  97-02
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef PIELDRW_H
#define PIELDRW_H

#include "pidrawer.h"

//  Classe avec gestion d une liste d elements a tracer 

class PIElDrawer : public PIDrawer 
{
public:
  enum { PIDEL_Line = 1, PIDEL_Text = 2,
         PIDEL_Rect = 3, PIDEL_FRect = 4, 
         PIDEL_Circ = 5, PIDEL_FCirc = 6 } ; 

                     PIElDrawer();
  virtual           ~PIElDrawer();

  virtual void	     SetTitles(const char* tt=NULL, const char* tb=NULL);
  virtual void       SetTitles(string const & tt, string const & tb);

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax); 

  inline int         ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, 
                               PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_Line, x1, y1, x2, y2, NULL, c) ); }  
  inline int         ElAddText(PIGrCoord x, PIGrCoord y, const char* s, PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_Text, x, y, 0, 0, s, c) ); }  
  inline int         ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, 
                               PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_Rect, x, y, dx, dy, NULL, c) ); }  
  inline int         ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy,
                               PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_FRect, x, y, dx, dy, NULL, c) ); }  
  inline int         ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_Circ, x, y, r, r, NULL, c) ); }  
  inline int         ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIColors c=PI_NotDefColor)
    { return( ElAdd(PIDEL_FCirc, x, y, r, r, NULL, c) ); }  

  void               ElDel(int id);
  void               ElDelAll();

protected:
  int                ElAdd(int typ, PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, 
                           const char* s, PIColors c=PI_NotDefColor);
#ifdef __DECCXX
public:
#endif
  struct DrwEl{
    int eid, etyp;
    PIGrCoord ex,ey;
    PIGrCoord edx,edy;
    string es;
    PIColors col;
  };
#ifdef __DECCXX
protected:
#endif
  typedef list<DrwEl> DrwElList;

  DrwElList mElist;
  int mEn;

  string titleT, titleB;       // Titre Haut - Bas

};


#endif
