// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGraphicAtt 
// Classe de gestion des attributs graphiques  
//                                        R. Ansari  2002
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICATT_H_SEEN
#define PIGRAPHICATT_H_SEEN

#include "pisysdep.h"
#include <string>
#include <vector>
#include "pigraphgen.h"

class PIGraphicAtt {
public:
                 PIGraphicAtt();
                 PIGraphicAtt(PIGraphicAtt const & att);
                 PIGraphicAtt(vector<string> & att, bool rmdecatt=true);
  virtual        ~PIGraphicAtt();

  virtual void   CopyFrom(PIGraphicAtt const & att);
  virtual bool   Compare(PIGraphicAtt const & att);
  virtual void   SetDefaultAtt();

  inline PIGraphicAtt& operator = (PIGraphicAtt const & att)
                 { CopyFrom(att);  return(*this); }
  inline bool operator == (PIGraphicAtt const & att)
                 { return (Compare(att)); } 
  inline bool operator != (PIGraphicAtt const & att)
                 { return (!Compare(att)); } 

  virtual void   UpdateFrom(PIGraphicAtt const & att);
  virtual int    DecodeAttStrings(vector<string> & att, bool rmdecatt=true);

// Changement des attributs graphiques
  inline void    SetColAtt(PIColors fg=PI_NotDefColor, 
			   PIColors bg=PI_NotDefColor)  { mFCol = fg; mBCol = bg; }
  inline void    SetLineAtt(PILineAtt const & lat)  { mLAtt = lat; }
  inline void    SetLineAtt(PILineTypes ltyp=PI_NotDefLineAtt)  { mLAtt = ltyp; }
  inline void    SetFont(PIFont const & fnt)  { mFnt = fnt; } 
         void    SetFontAtt(PIFontSize fsz=PI_NotDefFontSize,
			    PIFontAtt fat=PI_NotDefFontAtt);
         void	 SetFontAtt(PIFontName fn, PIFontSize fsz=PI_NotDefFontSize,
			    PIFontAtt fat=PI_NotDefFontAtt);
  inline void    SetMarkerAtt(int sz, PIMarker mrk=PI_NotDefMarker)
                 { mMSz = (sz>0)?sz:mMSz;  mMrk = mrk; }
  inline void    SetMarkerAtt(PIMarker mrk=PI_NotDefMarker)  { mMrk = mrk; }
  inline void    SetArrowMarkerAtt(int sz, PIArrowMarker mrk=PI_NotDefArrowMarker)
                 { mArrowMrkSz = (sz>2)?sz:mArrowMrkSz;  mArrowMrk = mrk; }
  inline void    SetArrowMarkerAtt(PIArrowMarker mrk=PI_NotDefArrowMarker)
                 { mArrowMrk = mrk; }
  inline void    SetColMapId(CMapId cid=CMAP_OTHER, bool rev=false)
                 { mCmapid = cid; mRevCmap = rev; }

// Acces aux attributs graphiques
  inline PIColors    GetColor() const { return(mFCol); }
  inline PIColors    GetFgColor() const { return(mFCol); }
  inline PIColors    GetBgColor() const { return(mBCol); }
  inline PILineAtt   GetLineAtt()  const { return(mLAtt); }
  inline PILineAtt&  GetLineAtt()  { return(mLAtt); }
  inline PIFont      GetFont()  const  { return(mFnt);  }
  inline PIFont&     GetFont()   { return(mFnt);  }
  inline PIFontSize  GetFontSz() const   { return(mFnt.GetFontSz());  }
  inline int         GetFontSzPt() const   { return(mFnt.GetFontSzPt());  }
  inline int         GetFontSize() const   { return(mFnt.GetFontSize());  }
  inline PIFontAtt   GetFontAtt() const  { return(mFnt.GetFontAtt()); }
  inline PIFontName  GetFontName() const  { return(mFnt.GetFontName());} 
  inline int         GetMarkerSz() const  { return(mMSz);  }
  inline int         GetMarkerSize() const  { return(mMSz);  }
  inline PIMarker    GetMarker() const   { return(mMrk);  } 
  inline int         GetArrowMarkerSz() const  { return(mArrowMrkSz);  }
  inline int         GetArrowMarkerSize() const  { return(mArrowMrkSz);  }
  inline PIArrowMarker GetArrowMarker() const  { return(mArrowMrk);  } 
  inline CMapId      GetColMapId() const { return(mCmapid); }
  inline CMapId      GetColMapId(bool & rev) const { rev = mRevCmap; return(mCmapid); }

protected:
  void      InitGrAttStrings();   

  PIColors           mFCol, mBCol;
  PILineAtt          mLAtt;
  PIFont             mFnt;
  int                mMSz;
  PIMarker           mMrk;  
  int                mArrowMrkSz;
  PIArrowMarker      mArrowMrk;
  CMapId             mCmapid;
  bool               mRevCmap;
};

#endif
