#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <iostream.h>
#include <string>
#include <list>
#include <map>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#include <map.h>
#endif

#include "strutil.h"
#include "datatypes.h"

#include "nobjmgr.h"
#include "servnobjm.h"
#include "pistdimgapp.h"

#include "pclassids.h"
#include "histos.h"
#include "histos2.h"
#include "ntuple.h"
#include "hisprof.h"
#include "generaldata.h"

#include "cimage.h"
#include "cvector.h"
#include "matrix.h"

//  Si le module StarReco++ a ete compile (Pour les StarList, Transfo, etc ...
#ifndef SANS_StarReco 
#include "stlist.h"
#include "star.h"
#endif


/* --Methode-- */
Services2NObjMgr::Services2NObjMgr(PIStdImgApp* app, string& tmpdir)
{
TmpDir = tmpdir;
PDynLinkMgr::SetTmpDir(tmpdir);
mImgapp = app;
dynlink = NULL;
InitGrAttNames();
}
  
/* --Methode-- */
Services2NObjMgr::~Services2NObjMgr()
{
CloseDLL();
}

/* --Methode-- */
void Services2NObjMgr::Nobj_ComputeExpressions(PPersist* obj, string& expx, string& expy, string& expz, 
                          string& expwt, string& expcut, NTuple* nt, Histo* h1, Histo2D* h2, HProf* hp)
{
int cid = obj->ClassId();

string vardec;
switch (cid) {
  case ClassId_Vector : 
    vardec = "double i,val; \n";
    vardec += "i = _zz61qq_[0];  val = _zz61qq_[1]; \n";
    break;

  case ClassId_Matrix : 
    vardec = "double i,j,val; \n";
    vardec += "i = _zz61qq_[0];  j = _zz61qq_[1];  val = _zz61qq_[2]; \n";
    break;

  case ClassId_Histo1D : 
  case ClassId_HProf : 
    vardec = "double i,x,val,err; \n";
    vardec += "i = _zz61qq_[0];  x = _zz61qq_[1];  val = _zz61qq_[2];  err = _zz61qq_[3]; \n";
    break;

  case ClassId_Histo2D : 
    vardec = "double i,j,x,y,val,err; \n";
    vardec += "i = _zz61qq_[0];  j = _zz61qq_[1]; \n";  
    vardec += "x = _zz61qq_[2];  y = _zz61qq_[3]; \n";  
    vardec += "val = _zz61qq_[4]; err = _zz61qq_[5]; \n";
    break;

  case ClassId_Image : 
  case ClassId_Image + kuint_1 : 
  case ClassId_Image + kint_1 : 
  case ClassId_Image + kr_8 : 
  case ClassId_Image + kuint_4 : 
  case ClassId_Image + kuint_2 : 
  case ClassId_Image + kint_2 : 
  case ClassId_Image + kint_4 : 
  case ClassId_Image + kr_4 : 
    vardec = "double x,y,pix,i,j,val; \n";
    vardec += "x = i = _zz61qq_[0];  y = j = _zz61qq_[1];  pix = val = _zz61qq_[2]; \n";
    break;

#ifndef SANS_StarReco 
  case ClassId_StarList : 
    vardec = "double x,y,flux,fond; \n";
    vardec += "x = _zz61qq_[0];  y = _zz61qq_[1];  flux = _zz61qq_[2];  fond =  _zz61qq_[3]; \n";
    break;
#endif

  case ClassId_NTuple :
    vardec = ((NTuple*)obj)->VarList_C("_zz61qq_");
    break;

  case ClassId_GeneralFitData :
    vardec = ((GeneralFitData*)obj)->VarList_C("_zz61qq_");
    break;

  default :
    cerr << "NamedObjMgr_ComputeExpressions() Error , N/A to " << PClassIdToClassName(cid) << endl; 
    return;
  }

PlotExprFunc f = LinkExprFunc(vardec, expx, expy, expz, expwt, expcut);
if (!f) { 
  cerr << "NamedObjMgr_ComputeExpressions() Error Creation PlotExprFunc " <<  endl; 
  return;
  }

float x[10], xnt[10];

int i,j,k;
for(i=0; i<10; i++) x[i] = xnt[i] = 0.;

TRY {                                 
switch (cid) {
  case ClassId_Vector :
    { 
    Vector* vv = (Vector*)obj;
    for(k=0; k<vv->NElts(); k++) {
      x[0] = k;   x[1] = (*vv)(k);
      if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;

  case ClassId_Matrix : 
    {
    Matrix* mm = (Matrix*)obj;
    for(j=0; j<mm->NCol(); j++)
      for(i=0; i<mm->NRows(); i++) {
      x[0] = i; x[1] = j;  x[2] = (*mm)(i,j);
      if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;

  case ClassId_Histo1D : 
  case ClassId_HProf : 
    {
    Histo* hh = (Histo*)obj;
    for(k=0; k<hh->NBins(); k++) {
      x[0] = k;  x[1] = hh->BinCenter(k);   
      x[2] = (*hh)(k);  x[3] = hh->Error(k);
      if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;

  case ClassId_Histo2D : 
    {
    Histo2D* hh = (Histo2D*)obj;
    for(j=0; j<hh->NBinY(); j++)
      for(i=0; i<hh->NBinX(); i++) {
      x[0] = i;   x[1] = j; 
      hh->BinCenter(i,j,x[2],x[3]); 
      x[4] = (*hh)(i,j);  x[5] = hh->Error(i, j);
      if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;


  case ClassId_Image : 
  case ClassId_Image + kuint_1 : 
  case ClassId_Image + kint_1 : 
  case ClassId_Image + kr_8 : 
  case ClassId_Image + kuint_4 : 
  case ClassId_Image + kuint_2 : 
  case ClassId_Image + kint_2 : 
  case ClassId_Image + kint_4 : 
  case ClassId_Image + kr_4 :
    {
    RzImage* img = (RzImage*)obj; 
    for(j=0; j<img->YSize(); j++)
      for(i=0; i<img->XSize(); i++) {
        x[0] = i;  x[1] = j;  x[2] = img->FValue(i, j);
        if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
          if (nt) nt->Fill(xnt);
          if (h1) h1->Add(xnt[0], xnt[3]);
          if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
          if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
          }
      }
    }
    break;

#ifndef SANS_StarReco 
  case ClassId_StarList : 
    {
    StarList* stl = (StarList*)obj;
    BStar *sti;
    for(k=0; k<stl->NbStars(); k++) {
      sti = stl->Star(k);
      if ( (!sti) || !(sti->Nice(BStar::flagOK)) )  continue;
      x[0] = sti->PosX();   x[1] = sti->PosY();
      x[2] = sti->Flux();   x[3] =  sti->Fond();  
      if (f(x, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;
#endif

  case ClassId_NTuple :
    {
    NTuple* ntp = (NTuple*)obj;
    r_4* xn;
    for(k=0; k<ntp->NEntry(); k++)    {
      xn = ntp->GetVec(k);
      if (f(xn, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
        }
      }
    }
    break;

  case ClassId_GeneralFitData :
    {
    GeneralFitData* data = (GeneralFitData*)obj;
    r_4* xn;
    int iok = 2*data->NVar()+2;
    for(k=0; k<data->NData(); k++) {
      xn = data->GetVecR4(k);
      if(xn[iok]<0.001) continue;
      if (f(xn, xnt, xnt+1, xnt+2, xnt+3) != 0) {
        if (nt) nt->Fill(xnt);
        if (h1) h1->Add(xnt[0], xnt[3]);
        if (h2) h2->Add(xnt[0], xnt[1], xnt[3]);
        if (hp) hp->Add(xnt[0], xnt[1], xnt[3]);
      }
    }
    }
    break;

  default :
    cout << "NamedObjMgr_ComputeExpressions() Erreur: N/A to  " << PClassIdToClassName(cid) << endl; 
    return;
  }
} CATCH(merr) {
  fflush(stdout); 
  cout << endl; 
  cerr << endl;
  string es = PeidaExc(merr);
  cerr << "NamedObjMgr_ComputeExpressions()  Exception :" << merr << es;
  } ENDTRY;
 

// Fermeture du fichier .so 
CloseDLL();
return;
}


/* --Methode-- */
PlotExprFunc Services2NObjMgr::LinkExprFunc(string& vardec, string& expx, string& expy, string& expz, 
                                            string& expwt, string& cut)
{
FILE *fip;
string fname = TmpDir + "expf_pia_dl.c";
string fnamer = TmpDir + "expf_pia_dl";
string cmd;
int rc;

cmd = "rm " + fname;
rc = system(cmd.c_str());
//DBG printf("LinkExprFunc_Do> %s  (Rc=%d)\n", cmd.c_str(), rc); 

if ((fip = fopen(fname.c_str(), "w")) == NULL)   { 
  string sn = fname; 
  cout << "NamedObjMgr/LinkExprFunc_Erreur: Pb. Ouverture " << sn << endl; 
  return(NULL); 
  }

// constitution du fichier a compiler
fputs("#include <math.h> \n", fip);
fputs("int expf_pia_dl_func(float* _zz61qq_, float* _rx_61qq_, float* _ry_61qq_, float* _rz_61qq_, float* _wt_61qq_) \n{\n", fip);
fprintf(fip,"%s \n", vardec.c_str());
fprintf(fip, "if (!(%s)) { *_rx_61qq_ = *_ry_61qq_ = *_rz_61qq_ = *_wt_61qq_ = 0.;  return(0); } \n", cut.c_str());
fprintf(fip, "*_rx_61qq_ = %s ; \n", expx.c_str());
fprintf(fip, "*_ry_61qq_ = %s ; \n", expy.c_str());
fprintf(fip, "*_rz_61qq_ = %s ; \n", expz.c_str());
fprintf(fip, "*_wt_61qq_ = %s ; \n", expwt.c_str());
fputs("return(1); \n} \n", fip);
fclose(fip);

return((PlotExprFunc)LinkFunctionFromFile(fnamer, "expf_pia_dl_func"));
}


/* --Methode-- */
DlFunction Services2NObjMgr::LinkFunctionFromFile(string& fnamer, char* funcname)
{
string fname = fnamer + ".c" ;
string fnameobj = fnamer + ".o" ;
string fnameso = fnamer + ".so";

//  Le link dynamique
CloseDLL();
dynlink = PDynLinkMgr::BuildFromCFile(fname);
if (dynlink == NULL) { 
  cerr << "NamedObjMgr/LinkFunctionFromFile_Erreur: Erreur ouverture SO " << endl; 
  return(NULL); 
  }

DlFunction retfunc = dynlink->GetFunction(funcname);
if (retfunc == NULL) { 
  string sn = funcname; 
  cerr << "NamedObjMgr/LinkExprFunc_Erreur: Erreur linking " << sn << endl; 
  CloseDLL();
  return(NULL); 
  }
else return(retfunc);
}

/* --Methode-- */
void Services2NObjMgr::CloseDLL()
{
if (dynlink) delete dynlink;   dynlink = NULL;
}

/* --Methode-- */
string Services2NObjMgr::FileName2Name(string const & fn)
{

char fsep[2] = {FILESEP, '\0'};
char tsep[2] = {'.', '\0'};
size_t p = fn.find_last_of(fsep);
size_t q = fn.find_last_of(tsep);
if (p < 0)  p = 0;
p++;
if (q < p) q = fn.length();
return(fn.substr(p,q-p));
}


typedef vector<string> GraTok;

/* --Methode-- */
int Services2NObjMgr::DecodeDispOption(string& gratt, bool& fgsrgr)
{
int ropt = Disp_Next;
if (!mImgapp)  return(ropt); 

for(int i=0; i<gratt.length(); i++) gratt[i] = tolower(gratt[i]);

if (fgsrgr) mImgapp->SaveGraphicAtt();

if (gratt.substr(0,3) == "def")  {  // Remise aux valeurs par defaut = non defini
  mImgapp->SetColAtt();
  mImgapp->SetLineAtt();
  mImgapp->SetFontAtt();
  mImgapp->SetMarkerAtt();
  mImgapp->SetColMapId();
  mImgapp->SetZoomAtt();
  return(ropt);
  }

// On separe en mots separes par des virgules 
gratt = ","+gratt;
size_t p = 0;
size_t q = 0;
size_t l = gratt.length();
string token;

GraTok grt;

while (q < l)  {
  p = gratt.find_first_not_of(" ,",q+1); // au debut d'un token
  if (p>=l) break;
  q = gratt.find_first_of(" ,",p); // la fin du token;
  token = gratt.substr(p,q-p);
  grt.push_back(token);
  }


static GrAttNames::iterator it;

int k; 
bool fgcont = true;
fgsrgr = false;

for(k=0; k<grt.size(); k++) {
//  cout << "--DBG--SetGraphicAttributes() " << grt[k] << endl;

 // Decodage option affichage (win, next, etc 
  fgcont = true;
  if ( (grt[k] == "win") || (grt[k] == "w") )  ropt =  Disp_Win;
  else if ( (grt[k] == "same") || (grt[k] == "s") )  ropt = Disp_Same;
  else  if ( (grt[k] == "stack") || (grt[k] == "st") )  ropt = Disp_Stack;
  else fgcont = false;
  if (fgcont)   continue;
  
  // Si c'est une couleur
  it = GrAcolors.find(grt[k]);
  if (it != GrAcolors.end())  { mImgapp->SetColAtt((PIColors)((*it).second.a1)); fgsrgr = true; continue; }
  // Si c'est un attribut de lignes
  it = GrAlines.find(grt[k]);
  if (it != GrAlines.end())  { mImgapp->SetLineAtt((PILineAtt)((*it).second.a1));  fgsrgr = true; continue; }
  // Si c'est un attribut de fontes
  it = GrAfonts.find(grt[k]);
  if (it != GrAfonts.end())  { mImgapp->SetFontAtt((PIFontSize)((*it).second.a2), (PIFontAtt)((*it).second.a1) ); 
                               fgsrgr = true;  continue; }
  // Si c'est un attribut de markers
  it = GrAmarkers.find(grt[k]);
  if (it != GrAmarkers.end())  { mImgapp->SetMarkerAtt((*it).second.a2, (PIMarker)((*it).second.a1) ); 
                                 fgsrgr = true;  continue; }
  // Si c'est un colormap
  it = GrAcmap.find(grt[k]);
  if (it != GrAcmap.end())  { mImgapp->SetColMapId( (CMapId)((*it).second.a1) ); fgsrgr = true; continue; }  
  // Si c'est un facteur de zoom
  it = GrAzoom.find(grt[k]);
  if (it != GrAzoom.end())  { mImgapp->SetZoomAtt( (*it).second.a1 );  fgsrgr = true; continue; }  
  
  }  

return(ropt);
}

/* --Methode-- */
char* Services2NObjMgr::PClassIdToClassName(int cid)
{
switch (cid) {
  case ClassId_Poly1 : 
    return("Poly1");
  case ClassId_Poly2 : 
    return("Poly2");
  case ClassId_Matrix : 
    return("Matrix");
  case ClassId_Vector : 
    return("Vector");

  case ClassId_DVList : 
    return("DVList");

  case ClassId_Histo1D : 
    return("Histo1D");
  case ClassId_Histo2D : 
    return("Histo2D");
  case ClassId_HProf : 
    return("HProf");
  case ClassId_NTuple : 
    return("NTuple");
  case ClassId_GeneralFitData : 
    return("GeneralFitData");

  case ClassId_Image : 
    return("RzImage");
  case ClassId_Image + kuint_1 : 
    return("ImageU1");
  case ClassId_Image + kint_1 : 
    return("ImageI1");
  case ClassId_Image + kuint_2 : 
    return("ImageU2");
  case ClassId_Image + kint_2 : 
    return("ImageI2");
  case ClassId_Image + kuint_4 : 
    return("ImageU4");
  case ClassId_Image + kint_4 : 
    return("ImageI4");
  case ClassId_Image + kr_4 : 
    return("ImageR4");
  case ClassId_Image + kr_8 : 
    return("ImageR8");

  case ClassId_ZFidu : 
    return("ZFidu");

#ifndef SANS_StarReco 
  case ClassId_StarList : 
    return("StarList");
  case ClassId_Transfo : 
    return("Transfo");
  case ClassId_PSF : 
    return("PSF");

  case ClassId_Star + BStar_Type : 
    return("BStar");
  case ClassId_Star + RzStar_Type : 
    return("RzStar");
  case ClassId_Star + PSFStar_Type : 
    return("PSFStar");
  case ClassId_Star + MCStar_Type : 
    return("MCStar");
  case ClassId_Star + CircRFixStar_Type : 
    return("CircRFixStar");
  case ClassId_Star + PSFDHStar_Type : 
    return("PSFDHStar");
  case ClassId_Star + PSFSEStar_Type : 
    return("PSFSEStar");
  case ClassId_Star + MCDHStar_Type : 
    return("MCDHStar");
#endif

// - Ajout objet PPF
  default:
    return("Unknown");
  }
}  

/* --Methode-- */
char* Services2NObjMgr::PClassIdToShortClassName(int cid)
{
switch (cid) {
  case ClassId_Poly1 : 
  case ClassId_Poly2 : 
    return("Poly");
  case ClassId_Matrix : 
    return("Mtx");
  case ClassId_Vector : 
    return("Vec");
  case ClassId_DVList : 
    return("Dvl");

  case ClassId_Histo1D : 
    return("H1D");
  case ClassId_Histo2D : 
    return("H2D");
  case ClassId_HProf : 
    return("HPF");
  case ClassId_NTuple : 
    return("NT");
  case ClassId_GeneralFitData : 
    return("GFD");

  case ClassId_Image : 
  case ClassId_Image + kuint_1 : 
  case ClassId_Image + kint_1 : 
  case ClassId_Image + kuint_2 : 
  case ClassId_Image + kint_2 : 
  case ClassId_Image + kuint_4 : 
  case ClassId_Image + kint_4 : 
  case ClassId_Image + kr_4 : 
  case ClassId_Image + kr_8 : 
    return("Img");

  case ClassId_ZFidu : 
    return("Fidu");

#ifndef SANS_StarReco 
  case ClassId_StarList : 
    return("Stl");
  case ClassId_Transfo : 
    return("Tr");
  case ClassId_PSF : 
    return("PSF");

  case ClassId_Star + BStar_Type : 
  case ClassId_Star + RzStar_Type : 
  case ClassId_Star + PSFStar_Type : 
  case ClassId_Star + MCStar_Type : 
  case ClassId_Star + CircRFixStar_Type : 
  case ClassId_Star + PSFDHStar_Type : 
  case ClassId_Star + PSFSEStar_Type : 
  case ClassId_Star + MCDHStar_Type : 
    return("Star");
#endif

// - Ajout objet PPF
  default:
    return("U");
  }
}  

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Initialisation des chaines de caracteres designant les attributs graphiques 

/* --Methode-- */
void Services2NObjMgr::InitGrAttNames()
{
gratt_item gi;
// Les couleurs
gi.a2 = 0;
gi.a1 = PI_NotDefColor;
GrAcolors["defcol"] = gi;
gi.a1 = PI_Black;
GrAcolors["black"] = gi;
gi.a1 = PI_White;
GrAcolors["white"] = gi;
gi.a1 = PI_Grey;
GrAcolors["grey"] = gi;
gi.a1 = PI_Red;
GrAcolors["red"] = gi;
gi.a1 = PI_Blue;
GrAcolors["blue"] = gi;
gi.a1 = PI_Green;
GrAcolors["green"] = gi;
gi.a1 = PI_Yellow;
GrAcolors["yellow"] = gi;
gi.a1 = PI_Magenta;
GrAcolors["magenta"] = gi;

gi.a1 = PI_Cyan;
GrAcolors["cyan"] = gi;
gi.a1 = PI_Turquoise;
GrAcolors["turquoise"] = gi;
gi.a1 = PI_NavyBlue;
GrAcolors["navyblue"] = gi;
gi.a1 = PI_Orange;
GrAcolors["orange"] = gi;
gi.a1 = PI_SiennaRed;
GrAcolors["siennared"] = gi;
gi.a1 = PI_Purple;
GrAcolors["purple"] = gi;
gi.a1 = PI_LimeGreen;
GrAcolors["limegreen"] = gi;
gi.a1 = PI_Gold;
GrAcolors["gold"] = gi;

// Les attributs de lignes
gi.a2 = 0;
gi.a1 = PI_NotDefLineAtt;
GrAlines["defline"] = gi;
gi.a1 = PI_NormalLine;
GrAlines["normalline"] = gi;
gi.a1 = PI_ThinLine;
GrAlines["thinline"] = gi;
gi.a1 = PI_ThickLine;
GrAlines["thickline"] = gi;
gi.a1 = PI_DashedLine;
GrAlines["dashedline"] = gi;
gi.a1 = PI_ThinDashedLine;
GrAlines["thindashedline"] = gi;
gi.a1 = PI_ThickDashedLine;
GrAlines["thickdashedline"] = gi;
gi.a1 = PI_DottedLine;
GrAlines["dottedline"] = gi;
gi.a1 = PI_ThinDottedLine;
GrAlines["thindottedline"] = gi;
gi.a1 = PI_ThickDottedLine;
GrAlines["thickdottedline"] = gi;

// Les fontes (a faire)
gi.a2 = PI_NotDefFontSize;
gi.a1 = PI_NotDefFontAtt;
GrAlines["deffont"] = gi;

gi.a2 = PI_NormalSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["normalfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["boldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["italicfont"] = gi;
gi.a2 = PI_SmallSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["smallfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["smallboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["smallitalicfont"] = gi;
gi.a2 = PI_BigSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["bigfont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["bigboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["bigitalicfont"] = gi;
gi.a2 = PI_HugeSizeFont;
gi.a1 = PI_RomanFont;
GrAlines["hugefont"] = gi;
gi.a1 = PI_BoldFont;
GrAlines["hugeboldfont"] = gi;
gi.a1 = PI_ItalicFont;
GrAlines["hugeitalicfont"] = gi;


// Les markers 
const char* mrkn[11] = { "dotmarker", "plusmarker", "crossmarker", 
                         "circlemarker", "fcirclemarker", "boxmarker", "fboxmarker", 
                         "trianglemarker", "ftrianglemarker", "starmarker", "fstarmarker"};
PIMarker mrk[11] = { PI_DotMarker, PI_PlusMarker, PI_CrossMarker, 
                     PI_CircleMarker, PI_FCircleMarker, PI_BoxMarker, PI_FBoxMarker, 
                     PI_TriangleMarker, PI_FTriangleMarker, PI_StarMarker, PI_FStarMarker};

gi.a2 = 0;
gi.a1 = PI_NotDefMarker;
GrAmarkers["defmarker"] = gi;
 
for(int j=0; j<11; j++) {
  string smrk;
  char buff[16];
  for(int m=1; m<10; m+=2) {
    sprintf(buff,"%d",m);
    smrk = (string)mrkn[j] + (string)buff;
    gi.a1 = mrk[j];  gi.a2 = m;
    GrAmarkers[smrk] = gi;
    }
  }

// Les tables de couleurs 
gi.a2 = 0;
gi.a1 = CMAP_OTHER;
GrAcmap["defcmap"] = gi;
gi.a1 = CMAP_GREY32;
GrAcmap["grey32"] = gi;
gi.a1 = CMAP_GREYINV32;
GrAcmap["greyinv32"] = gi;
gi.a1 = CMAP_COLRJ32;
GrAcmap["colrj32"] = gi;
gi.a1 = CMAP_COLBR32;
GrAcmap["colbr32"] = gi;
gi.a1 = CMAP_GREY128;
GrAcmap["grey128"] = gi;
gi.a1 = CMAP_GREYINV128;
GrAcmap["greyinv128"] = gi;
gi.a1 = CMAP_COLRJ128;
GrAcmap["colrj128"] = gi;
gi.a1 = CMAP_COLBR128;
GrAcmap["colbr128"] = gi;

// Les tables de couleurs 
gi.a2 = 0;
gi.a1 = 0;
GrAzoom["defzoom"] = gi;
gi.a1 = 1;
GrAzoom["zoomx1"] = gi;
gi.a1 = 2;
GrAzoom["zoomx2"] = gi;
gi.a1 = 3;
GrAzoom["zoomx3"] = gi;
gi.a1 = 4;
GrAzoom["zoomx4"] = gi;
gi.a1 = 5;
GrAzoom["zoomx5"] = gi;
gi.a1 = -2;
GrAzoom["zoom/2"] = gi;
gi.a1 = -3;
GrAzoom["zoom/3"] = gi;
gi.a1 = -4;
GrAzoom["zoom/4"] = gi;
gi.a1 = -5;
GrAzoom["zoom/5"] = gi;
                 
}
