#include "flowmodex.h"
#include "pi2dvec.h"

#include <typeinfo> 

#include <vector>
#include <string>
#include "nobjmgr.h"
#include "ntuple.h"

#include "pidrawer.h"
#include "nomgadapter.h"
#include "servnobjm.h"


/* --Methode-- */
FlowModExecutor::FlowModExecutor(PIACmd* mpiac, PIStdImgApp* app)
{


  //cout << " FlowModExecutor::FlowModExecutor() mpiac = " << (unsigned long)mpiac << endl;
  cout << " registration of flow chart commands "<<endl;
  string hgrp,kw,usage;
  hgrp = "Obj. Display";
  
  kw = "nt2dvec";
  usage = "Creates and displays a flow chart from ntuple variables";
  usage += "\n Usage: nt2dvec x y vx vy [graphic_att] ";
  mpiac->RegisterCommand(kw, usage, this, hgrp);


  hgrp = "Expr. Plotting";
  kw = "plot2dvec";
  usage = "Creates and displays a flow chart from ntuple expressions ";
  usage +=  "\n Usage: plot2dvec ntuple expx expy expvx expvy [cut graphic_att loop_par]"; 
  
  mpiac->RegisterCommand(kw, usage, this, hgrp);
  
  //cout << " Out of ContModExecutor::ContModExecutor() " << endl;

}
 


/* --Methode-- */
FlowModExecutor::~FlowModExecutor()
{
}

/* --Methode-- */
int FlowModExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{
  
int nz=-1;
double z0,dz;
PI2dVecDrawer *p2dv;
string dopt="";
NamedObjMgr omg;

if ( kw == "nt2dvec") {
   
 
   if (tokens.size() < 5) {
     cout << "Usage: nt2dvec ntuple x y vx vy [graphic_att]" << endl;
     return(0);
   }
   NObjMgrAdapter* obja = omg.GetObjAdapter(tokens[0]);
   if (obja == NULL) {
     cout << "contour Error , No object with name " << tokens[0] << endl; 
     return(0);
   }
     
   if (tokens.size() > 5) dopt = tokens[5];
   bool adel;

   NTupleInterface *ntin = obja->GetNTupleInterface(adel);

   p2dv = new PI2dVecDrawer(ntin,adel);
   string expx,expy;
   expx = tokens[1];
   expy = tokens[2];
   int ret = p2dv->SelectXY(expx.c_str(),expy.c_str());
   if(ret<0){ cout << "Usage: nt2dvec ntuple x y vx vy [graphic_att]" << endl;  return(0);}
   expx = tokens[3];
   expy = tokens[4];
   ret = p2dv->SelectVW(expx.c_str(),expy.c_str());
   if(ret<0){ cout << "Usage: nt2dvec ntuple x y vx vy [graphic_att ]" << endl;  return(0);}

   // On affiche le Drawer
   int wrsid = 0;
   bool fgsr = true;
   int opt = omg.GetServiceObj()->DecodeDispOption(dopt, fgsr);
   
   string name = "ChampVec";
   
   wrsid = omg.GetImgApp()->DispScDrawer(p2dv , name, opt); 

}else if(kw == "plot2dvec"){

  
  if (tokens.size() < 5) {
    cout << "Usage: plot2dvec ntuple expx expy expvx expvy [cut graphic_att loop_par]" << endl; 
    return(0); 
  }

 
  NObjMgrAdapter* obja=NULL;
  obja = omg.GetObjAdapter(tokens[0]);
  if (obja == NULL) {
    cout << "plot2dvec Error , No object with name " << tokens[0] << endl; 
    return(0);
  }

  Services2NObjMgr* srvo = omg.GetServiceObj();

  bool adel=true;
  //NTupleInterface *ntin = obja->GetNTupleInterface(adel);
  
  // Creation NTuple 
  char* ntn[4] = {"expx","expy","expex","expey"};
  NTuple * ntint = NULL;
  ntint = new NTuple(4,ntn);
  // remplissage du ntuple 
  string bidon = "0.";
  string nocut = "1.";
  if(tokens.size()>7) bidon = tokens[7];
  if(tokens.size()>5) nocut = tokens[5];
  srvo->ComputeExpressions(obja,tokens[1],tokens[2],tokens[3],tokens[4],nocut,bidon,ntint,NULL,NULL);
  p2dv = new PI2dVecDrawer(ntint,adel);
  p2dv->SelectXY(ntn[0],ntn[1]);
  p2dv->SelectVW(ntn[2],ntn[3]);

  bool fgsr = true;
  if (tokens.size() > 6) dopt = tokens[6];

  int opt = omg.GetServiceObj()->DecodeDispOption(dopt, fgsr);
  string name = "ChampVec";
   
  int wrsid = omg.GetImgApp()->DispScDrawer(p2dv , name, opt); 

}
 

return(0);

}



