// Module PI : Peida Interactive     PIElDrawer
//	      E. Aubourg , R.Ansari     96-02
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <strings.h>
#include <iostream.h>

#include "pieldrw.h"

#include <math.h>


/*  --------------------------------------------------------------  */
/*  ------------------- Classe PIElDrawer ------------------------  */
/*  --------------------------------------------------------------  */

//++
// Class	PIElDrawer
// Lib		PI
// include	pieldrw.h
//
//	Classe de traceur ("Drawer") capable de grer et de 
//	tracer une liste d'lments simples. Cette classe
//	est utilis pour le trac des axes et des lments de
//	texte ds les "PIScDrawWdg", "PIDraw3DWdg" et "PIImage".
//--
//++
// Links	Parents
// PIDrawer
//--

//++
// Titre	Constructeurs et mthodes
//--

//++
// PIElDrawer()
//	Constructeur
//--

/* --Methode-- */
PIElDrawer::PIElDrawer()
{
mEn = 0;
titleT = titleB = "";
}

/* --Methode-- */
PIElDrawer::~PIElDrawer()
{
}


//++
//  void  SetTitles(const char* tt=NULL, const char* tb=NULL)
//	Ajout de titres haut ("tt") et bas ("tb")
//  void  SetTitles(string const & tt, string const & tb)
//	Ajout de titres haut ("tt") et bas ("tb")
//--

/* --Methode-- */
void PIElDrawer::SetTitles(const char* tt, const char* tb)
{
if (tt != NULL)  titleT = tt;
if (tb != NULL)  titleB = tb;
}

/* --Methode-- */
void PIElDrawer::SetTitles(string const & tt, string const & tb)
{
titleT = tt;  titleB = tb;
}

/* --Methode-- */
int PIElDrawer::DecodeOptionString(vector<string> & opt, bool rmdecopt)
{
  if (opt.size() == 0)  return(0);  
  int ndec1 = PIDrawer::DecodeOptionString(opt, rmdecopt);
  vector<string> udopt;
  unsigned int k = 0;
  int ndec = opt.size();
  for( k=0; k<opt.size(); k++ ) {
    string opts = opt[k];
    if ( (opts == "stdaxes") || (opts == "defaxes") || (opts == "boxaxes") ) {
      SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
      continue;
    }
    if (opts == "simpleaxes") {
      SetAxesFlags(kAxesDflt);
      continue;      
    }
    if (opts == "boxaxesgrid") {
      SetAxesFlags(kBoxAxes | kExtTicks | kLabels | kGridOn);
      continue;      
    }
    if (opts == "fineaxes") {
      SetAxesFlags(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks);
      continue;      
    }
    if ((opts == "grid") || (opts == "fineaxesgrid")) {
      SetAxesFlags(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks | kGridOn);
      continue;      
    }
    if (opts == "autofontsize") {
      SetAxesAutoFontSize(true);
      continue;      
    }
    if (opts == "fixedfontsize") {
      SetAxesAutoFontSize(false);
      continue;      
    }

    ndec--;
    if (rmdecopt)  udopt.push_back(opts);
  }  

  if (rmdecopt)  opt = udopt;
  return(ndec+ndec1);
}

//++
// int  ElAddText(PIGrCoord x, PIGrCoord y, const char* s, PIColors c=PI_NotDefColor)
//	Ajout d'un lment texte avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// int  ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, -
//                 PIColors c=PI_NotDefColor)
//	Ajout d'un lment de ligne avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// int  ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, -
//                PIColors c=PI_NotDefColor)
//	Ajout d'un lment de type rectangle avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// int  ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, -
//                PIColors c=PI_NotDefColor)
//	Ajout d'un lment de type rectangle plein avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// int  ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIColors c=PI_NotDefColor)
//	Ajout d'un lment de type cercle avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// int  ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIColors c=PI_NotDefColor)
//	Ajout d'un lment de type cercle plein avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
// 
// void  ElDel(int id)
//	Suppression de l'lment avec l'identificateur "id".
// void  ElDelAll()
//	Suppression de tous les lments du dessin.
//--

/* --Methode-- */
void  PIElDrawer::Draw(PIGraphicUC* g, double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
SelGraAtt(g);   // DrawAxes change certains attributs graphiques
DrawAxes(g);   // Trace des axes 
g->SelFont(PI_NormalSizeFont);
SelGraAtt(g);   // DrawAxes change certains attributs graphiques

// Trace des titres 
if ( (titleT.length() > 0) || (titleB.length() > 0) ) {
  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  double fx, fy, fh;
//  fh = g->GetFontHeightUC(gas, gds);
  fh = 0.075*(YMax()-YMin());
  if ( titleT.length() > 0) {
      fx = g->CalcStringWidth(titleT.c_str());
      if(aXdir) fx = g->DeltaUCX(XMax(), -(XMax()-XMin()-fx)/2.);
      else fx = g->DeltaUCX(XMin(), (XMax()-XMin()-fx)/2.);
      if (g->isAxeYDirUpDown()) fy = g->DeltaUCY(YMin(), -fh);
      else fy = g->DeltaUCY(YMax(), fh);
      g->DrawString(fx, fy, titleT.c_str());
//      printf(" PIElDrawer::Draw()/DBG (%g , %g) %s  - %g \n", fx, fy, titleT.c_str(), fh);
    }
  if ( titleB.length() > 0) {
      fx = g->CalcStringWidth(titleB.c_str());
      if(aXdir) fx = g->DeltaUCX(XMax(), -(XMax()-XMin()-fx)/2.);
      else fx = g->DeltaUCX(XMin(), (XMax()-XMin()-fx)/2.);
      if (g->isAxeYDirUpDown()) fy =  g->DeltaUCY(YMax(), fh*1.5);
      else fy = g->DeltaUCY(YMin(), -fh*1.5);
      g->DrawString(fx, fy, titleB.c_str());
//      printf(" PIElDrawer::Draw()/DBG (%g , %g) %s  - %g \n", fx, fy, titleT.c_str(), fh);
    }
  }
DrwElList::iterator it;
PIColors cc = g->GetForeground();
for (it = mElist.begin(); it != mElist.end(); it++)
  {
  if ((*it).col != PI_NotDefColor)  g->SelForeground((*it).col);
  switch ( (*it).etyp )
    {
    case PIDEL_Line :
      g->DrawLine((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_Text :
      g->DrawString((*it).ex, (*it).ey, (char*) ((*it).es.c_str()) ); 
      break;
    case PIDEL_Rect :
      g->DrawBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_FRect :
      g->DrawFBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_Circ :
      g->DrawCircle((*it).ex, (*it).ey, (*it).edx ); 
      break;
    case PIDEL_FCirc :
      g->DrawFCircle((*it).ex, (*it).ey, (*it).edx ); 
      break;
    default :
      break;
    }
  g->SelForeground(cc);
  }
}


/* --Methode-- */
int PIElDrawer::ElAdd(int typ, PIGrCoord x, PIGrCoord  y, PIGrCoord dx, PIGrCoord dy, const char* s, PIColors c)
{
DrwEl dre;
mEn++;
dre.eid = mEn;  dre.etyp = typ;
dre.ex = x;   dre.ey = y;
dre.edx = dx;  dre.edy = dy;
dre.col = c;
if (s)  dre.es = s;
mElist.push_back(dre);
return(mEn);
}

/* --Methode-- */
void  PIElDrawer::ElDel(int id)
{
DrwElList::iterator it;
for (it = mElist.begin(); it != mElist.end(); it++)
  if ( (*it).eid == id) { mElist.erase(it);   break; }
return;
}

/* --Methode-- */
void  PIElDrawer::ElDelAll()
{
mElist.erase(mElist.begin(), mElist.end());
return;
}

