#include <math.h>
#include "tstnoisecancel.h"
#include "noisegen.h"
#include "wienerdecor.h"
#include "asciitoiwtr.h"
#include "toimanager.h"
#include "toisegment.h"

TstNoiseCancel::TstNoiseCancel() {

}

void TstNoiseCancel::init() {
  declareInput("noise");
  declareOutput("signal");
  declareOutput("probe");
  declareOutput("theoric");
}

void TstNoiseCancel::run() {
  int snb = getMinIn();
  int sne = getMaxIn();

  //cout << "TstNoiseCancel " << snb << " - " << sne << endl;

  double v1=0;
  double v2=0;
  for (int i=snb; i<=sne; i++) {
    double noise = getData(0, i);
    v1 = 0.8*v1 + noise;
    v2 = -0.6*v2 + noise;

    double sig = sin(i * 0.05 * 3.1415926);

    putData(0, i, sig+v1);
    putData(1, i, v2);
    putData(2, i, sig);
  }

  //cout << "tstnoisecancel done" << endl;
}

int main() {
  TOIManager* mgr = TOIManager::getManager();
  mgr->setRequestedSample(100,300);
  
  NoiseGenGauss gauss(1);
  TstNoiseCancel correlnoise;
  WienerDecorrelator wiener(200, 20);
  ASCIITOIWriter wtr("noisecancel.out");

  TOISegmented* toi = new TOISegmented("gaussnoise");
  gauss.addOutput("noise", toi);
  correlnoise.addInput("noise", toi);

  toi = new TOISegmented("signal");
  correlnoise.addOutput("signal" , toi);
  wiener.addInput("signal", toi);
  wtr.addInput("signal", toi);

  toi = new TOISegmented("probe");
  correlnoise.addOutput("probe", toi);
  wiener.addInput("probe", toi);
  wtr.addInput("probe", toi);

  toi = new TOISegmented("filtered");
  wiener.addOutput("signal", toi);
  wtr.addInput("filtered", toi);

  toi = new TOISegmented("theoric");
  correlnoise.addOutput("theoric", toi);
  wtr.addInput("theoric", toi);

  gauss.start(); correlnoise.start(); wiener.start(); wtr.start();
  
  mgr->joinAll();
}
