// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive      PIBaseWdgGen
// Classe de base pour la creation de nouvelles composantes
// graphiques interactives       
//                        R.Ansari -  E.Aubourg 96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIBWDGGEN_H_SEEN
#define PIBWDGGEN_H_SEEN


#include "pisysdep.h"
#include PIWDG_H
#include PICMAP_H
#include PIGRAPHIC_H
#include "pigraphuc.h"
#include "pievthandler.h"
#include "psfile.h"

// Mettre dans cet ordre, sinon g++ a des problemes   
#include <vector>   
#if defined(__KCC__)
#include <vector.h>
#endif


enum PIPointer { PI_ArrowPointer = 1, PI_CrossPointer = 2, 
                 PI_HandPointer = 3, PI_TDLRArrowPointer = 4 };


class PIBaseWdgGen : public PIWdg
{
public:
  enum {ClassId = 5000};

// Les methodes ...

                     PIBaseWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIBaseWdgGen();

  virtual long       kind() {return ClassId; }

//  Activation des evenements
  virtual void       ActivatePtrCross()        = 0;
  virtual void       ActivateButton(int bid)   = 0;
  virtual void       ActivateMove(int bid)     = 0;
  virtual void       ActivateKeyboard()        = 0;

//  Divers : couleur de fond, Effacement fenetre,  forme de la souris
  virtual void       SetBackgroundColor(PIColors col=PI_White)               = 0;
  virtual void       EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0)     = 0;
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer)          = 0;
  virtual PIColors   GetBackgroundColor()                                    = 0;
  virtual PIPointer  GetPointerShape()                                       = 0;
  virtual void       AssignKeyboard()                                        = 0;

//  Fonctions qui doivent contenir le dessin du contenu du widget lui-meme
  virtual void       Draw(PIGraphic* g, int x0, int y0, int dx, int dy);
  
// Traitement des evenements   
  virtual void       Resize();
  virtual void       Enter();
  virtual void       Leave();  
  virtual void       But1Press(int x, int y);  
  virtual void       But1Release(int x, int y); 
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       PtrMove(int x, int y);
  virtual void       Ptr1Move(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  virtual void       Ptr3Move(int x, int y);
  virtual void       Keyboard(int key, PIKeyModifier kmod);

// Acces aux caracteristiques du dernier evenement 
  virtual void       GetLastEventInfo(PIKeyModifier& kmod, unsigned long& tm) = 0;

// PostScript output
  virtual void       PSPrint(PSFile* psf, int ofx = 0, int ofy = 0);

// ------ Gestion des Drawers  ------
  friend class PIDrawer;
  virtual void       SetDefaultDrawRectangle(PIGrCoord x1, PIGrCoord y1, 
                                             PIGrCoord x2, PIGrCoord y2, bool psz=true); 
  virtual void       SetDefaultDrawerLimits(float xmin, float xmax, float ymin, float ymax,
                                            int axrl=kAxeDirSame, int ayud=kAxeDirSame); 
  virtual int        AddDrawer(PIDrawer* drw, PIGrCoord x1, PIGrCoord y1, 
                               PIGrCoord x2, PIGrCoord y2, 
                               bool psz=true, bool clip=true, bool ad=false);
  virtual int        AddDrawer(PIDrawer* drw, bool autolim=false, bool clip=true, bool ad=false);
  virtual void       MoveResizeDrawer(int id, PIGrCoord x1, PIGrCoord y1, 
                                      PIGrCoord x2, PIGrCoord y2, bool psz=true);
  virtual void       RemoveDrawer(int id);       // Ote un drawer de la liste
  virtual void       DeleteDrawers();            // Ote tous les drawers, delete des drawers ajoute avec ad=true
// Acces aux drawers 
  virtual int        NbDrawers();
  virtual PIDrawer*  GetDrawerId(int id);   
  virtual PIDrawer*  GetDrawer(int n);   

//  Trace des Drawers ...          
  virtual void       CallDrawers(PIGraphic* g, int x0=0, int y0=0, int dx=0, int dy=0); 
  virtual void       CallDrawer(int id);

// Devrait etre protected - mis ici a cause de cxx  11/07/97  Reza
  struct BWDrwId { int id; PIGrCoord x1, y1, x2, y2; bool autoszp, autolim, elastic, clip, ad;  PIDrawer* drw; };

  virtual PIGraphic*  WindowGraphic();

// -------------- Variables membre protegees -------------------
protected:
  PIGraphicWin* mWGrC;  // PIGraphic (Contexte graphique) associe a la fenetre
  bool mAdfg;           // Pour la gestion de DeleteDrawers() quand appele par delete de PIBaseWdg
  int mDrwId;           // Compteur pour DrawerId
  vector<BWDrwId> mDrwList;
//  Definition de la zone de trace et limites UC des drawers par defaut  
  PIGrCoord mDrX1, mDrY1,  mDrX2,  mDrY2;  
  bool mDrElastic;   // true --> Coord en fraction de la taille 
  float mDrXmin, mDrXmax, mDrYmin, mDrYmax;   // Limites par defaut - UC
  int  mDXdir, mDYdir;                        // Sens des axes par defaut

};


#endif /* PIBWDGGEN_H_SEEN */

