#include <stdlib.h>
#include <stdio.h>


#include <iostream.h>
#include <complex>

// ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
// Test program illustrating g++ problems with conversion
// operators involving the complex<T> class 
// Also, the complex class lacks the ostream& << operator
//         R. Ansari (LAL/IN2P3-CNRS) - April 2002
// # The flag CONV_DOSZ activates the ostream& << operator
// # definition in the source code 
// # To test compilation with implicit conversion operator
// csh> g++ -DCONV_ICO -DCONV_DOSZ -o pbconv pbconv.cc 
// # To test compilation with explicit conversion operator
// csh> g++ -DCONV_ECO -DCONV_DOSZ -o pbconv pbconv.cc 
// # To test compilation with static_cast conversion operator
// csh> g++ -DCONV_STCAST -DCONV_DOSZ -o pbconv pbconv.cc 
// # To run the produced test programs 
// csh> ./pbconv 
// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::
 
using namespace std;

#if defined(CONV_DOSZ) 
// the complex class in libstdc/g++ lacks the << operator definition !
template <class T>
inline ostream& operator << (ostream& os, const complex<T>& z)
{ os << z.real() << "," << z.imag() << " " ;  return(os); }
#endif 
// --------------------------------------------------------------------
// A class with a conversion operator to complex<double>

class convCR {
public:
  inline convCR() { dv = 0.;  dv_im = 0.; }  
  inline convCR(convCR const& x) { dv = x.dv;  dv_im = x.dv_im; }  
  inline convCR(double v) { dv = v;  dv_im = 0.; }  
  inline convCR(complex<double> const & z) { dv = z.real();  dv_im = z.imag(); }

  inline convCR&  operator= (double v) { dv = v;  dv_im = 0.; return (*this); }
  inline  convCR& operator= (complex<double> const & z) 
   { dv = z.real(); dv_im = z.imag(); return (*this); }

  inline operator double() const  { return(dv); }

  inline operator complex<double>() const { return(complex<double>(dv, dv_im)); }
  inline complex<double> ToComplex() const { return(complex<double>(dv, dv_im)); }  
  double dv;
  double dv_im;   /* for holding imaginary part of a complex */
};
// --------------------------------------------------------------------

// ------------  The main program -----------------
int main(int narg, char *arg[])
{
  int rc = 0;
  try {
    cout << " ---->  complex numbers and convCR : " << endl;
    complex<double> z,z1(2.5,2.5),z2(3.3,-1);
    cout << " complex<double>: z1=" << z1 << " z2=" << z2 
	 << " z1+z2=" << z1+z2 << endl;
    convCR czr, cz1(z1), cz2(z2), cz3;
    /* if defined(__GNUG__) && (__GNUC__ < 3) */
    complex<double> zb,zc;
    cout << " Using convCR::ToComplex() method : " << endl; 
    zb = cz1.ToComplex(); zc = cz2.ToComplex();  
    cout << " convCR:.ToComplex() zb=czr1= " << zb << " zc=" << zc 
    << " zb+zc=" << zb+zc << endl ; 
#if defined(__GNUG__) 
    cout << " GNUG_Version: __GNUC__ = " << __GNUC__ << endl;
    // else
#endif

    // Implicit conversion operator - 
    // compiles OK with g++ 2.95, not with g++ 3.01
#if defined(CONV_ICO)
    complex<double> za;
    za = cz1;
    cout << " complex<double> za; za = cz1 : " << za << endl;
#endif

#if defined(CONV_ECO)
    // Explicit conversion operator, does not compile with gcc 
    //  (g++ 2.95 , 3.01 ) 
    cout << " Using conversion operator on convCR : " << endl; 
    cout << " convCR: (complex<double>)(cz1(z1))" 
      	 << (complex<double>)(cz1)
	 << " \n (complex<double>)cz2(z2)" 
      	 << (complex<double>)(cz2)  
	 << endl;
#endif
    
#if defined(CONV_STCAST)
    // static_cast conversion operator, does not compile with 
    //  (g++ 2.95 , 3.01 ) 
    complex<double> zdd;
    cout << " Using static_cast operator on convCR : " << endl; 
    zdd = static_cast< complex<double> >(cz1);
    cout << " zdd = static_cast< complex<double> >(cz1) = " << zdd << endl;
#endif
  }
  catch (...) {
    cerr << " Catched Unknown exception ! " << endl;
    rc = 99;
  }

  exit(rc);
}








