// This may look like C code, but it is really -*- C++ -*-
// Classe traceur d histogramme                 96-99
// CEA-DAPNIA      LAL-IN2P3/CNRS
#ifndef PIHISTO_H
#define PIHISTO_H

#include "histos.h"
#include "pidrawer.h"

class PIHisto : public PIDrawer {
public:
                     PIHisto(Histo* histo, bool ad=false);
  virtual           ~PIHisto();
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  inline  void       SetStats(bool fg=true) { stats = fg; }
  inline  Histo*     Histogram() { return(mHisto); }

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

protected:
  virtual void       DrawStats(PIGraphicUC* g);
  Histo* mHisto;
  bool mAdDO;
  bool stats;        // true -> indication des stats d'histo
};

#endif
