#include "piacmd.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "basexecut.h"

#include "pdlmgr.h"
#include "ctimer.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"
#include "servnobjm.h"

#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"
#include "generaldata.h"

#ifdef SANS_EVOLPLANCK
#include "cvector.h"
#else
#include "tvector.h"
#endif


/* --Methode-- */
PIABaseExecutor::PIABaseExecutor(PIACmd* piac, NamedObjMgr* omg, PIStdImgApp* app)
{
mpiac = piac;
mObjMgr = omg; 
mImgApp = app;
dynlink = NULL;
dynlink2 = NULL;
RegisterCommands();
}

PIABaseExecutor::~PIABaseExecutor()
{
  if (dynlink) delete dynlink;
  if (dynlink2) delete dynlink2;
}


 
/* --Methode-- */
int PIABaseExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{
Services2NObjMgr* srvo = mObjMgr->GetServiceObj();
// >>>>> Chargement de modules
if (kw == "loadmodule") {
  if (tokens.size() < 2) { cout << "Usage: loadmodule fnameso modulename" << endl;  return(0); }
  mpiac->LoadModule(tokens[0], tokens[1]);
  }
// >>>>>>>>>>> Fenetre graphique , changement d'attributs graphiques 
else if (kw == "zone") {
  while (tokens.size() < 2) tokens.push_back("1");
  int nx, ny;
  nx = ny = 1;
  nx = atoi(tokens[0].c_str());    ny = atoi(tokens[1].c_str());
  if (mImgApp) mImgApp->SetZone(nx, ny);
  }  
else if (kw == "newwin") {
  int nx=1, ny=1;
  //if(tokens.size() < 2) { cout << "Usage: newwin nx ny" << endl;  return(0); }
  if(tokens.size() > 0) nx = atoi(tokens[0].c_str());
  if(tokens.size() > 1) ny = atoi(tokens[1].c_str());
  if (mImgApp) mImgApp->CreateGraphWin(nx, ny);
  }  
else if (kw == "stacknext") mImgApp->StackWinNext(); 
else if (kw == "graphicatt") {
  if (tokens.size() < 1) { cout << "Usage: graphicatt attributes_list (att=def->defaut)" << endl;  return(0); }
  string opts = tokens[0];
  if (tokens.size() > 1) 
    for(int kt=1; kt<tokens.size(); kt++)  { opts += ' '; opts += tokens[kt]; }
  if (mImgApp) mImgApp->SetDefaultGraphicAttributes(opts);
  }
else if (kw == "setaxesatt") {
  if (tokens.size() < 1) { cout << "Usage: setaxesatt attributes_list " << endl;  return(0); }
  string opts = tokens[0];
  if (tokens.size() > 1) 
    for(int kt=1; kt<tokens.size(); kt++)  { opts += ' '; opts += tokens[kt]; }
  if (mImgApp) mImgApp->SetDefaultAxesAttributes(opts);
  }
else if (kw == "setinsetlimits") {
  if (tokens.size() < 4) { cout << "Usage: setinsetlimits xmin xmax ymin ymax" << endl;  return(0); }
  double xmin = atof(tokens[0].c_str());
  double xmax = atof(tokens[1].c_str());
  double ymin = atof(tokens[2].c_str());
  double ymax = atof(tokens[3].c_str());
  mImgApp->SetInsetLimits(xmin, xmax, ymin, ymax);
  }
else if (kw == "addtext") {
  if (tokens.size() < 3) { cout << "Usage: addtext x y txt [colfontatt]" << endl;  return(0); }
  double xp = atof(tokens[0].c_str());
  double yp = atof(tokens[1].c_str());
  string txt = tokens[2];
  string sop;
  if (tokens.size() > 3) sop = tokens[3];
  mImgApp->AddText(txt, xp, yp, sop);
  }
else if ((kw == "addline") || (kw == "addrect") || (kw == "addfrect")) {
  if (tokens.size() < 4) { cout << "Usage: addline/addrect/addfrect x1 y1 x2 y2 [colatt]" << endl;  return(0); }
  double xp1 = atof(tokens[0].c_str());
  double yp1 = atof(tokens[1].c_str());
  double xp2 = atof(tokens[2].c_str());
  double yp2 = atof(tokens[3].c_str());
  string sop;
  if (tokens.size() > 4) sop = tokens[4];
  if (kw == "addline") mImgApp->AddLine(xp1, yp1, xp2, yp2, sop);
  else {
    bool fgfill = (kw == "addrect") ? false : true;
    mImgApp->AddRectangle(xp1, yp1, xp2, yp2, sop, fgfill);
  }
  }
else if ((kw == "addcirc") || (kw == "addfcirc")) {
  if (tokens.size() < 3) { cout << "Usage: addcirc/addfcirc xc yc r [colatt]" << endl;  return(0); }
  double xc = atof(tokens[0].c_str());
  double yc = atof(tokens[1].c_str());
  double rad = atof(tokens[2].c_str());
  bool fgsr = false;
  string sop;
  if (tokens.size() > 3) sop = tokens[3];
  bool fgfill = (kw == "addcirc") ? false : true;
  mImgApp->AddCircle(xc, yc, rad, sop, fgfill);
  }


else if (kw == "settitle") {
  if (tokens.size() < 1) { cout << "Usage: settitle TopTitle [BotTitle] [fontatt]" << endl;  return(0); }
  bool fgsr = true;
  mImgApp->SetTitle(tokens[0], tokens[1]);
  }
  
// >>>>>>>>>>> Link dynamique de fonctions C++
else if (kw == "link" ) {
  if (tokens.size() < 2) { cout << "Usage: link fnameso f1 [f2 f3]" << endl;  return(0); }
  string sph = "";
  for(int gg=0; gg<5; gg++)   tokens.push_back(sph);
  int rc = LinkUserFuncs(tokens[0], tokens[1], tokens[2], tokens[3]);
  if (rc == 0)  cout << "PIABaseExecutor: Link from " << tokens[0] << " OK " << endl;
}
else if (kw == "linkff2" ) {
  if (tokens.size() < 2) { cout << "Usage: linkff2 fnameso f1 [f2 f3]" << endl;  return(0); }
  string sph = "";
  for(int gg=0; gg<5; gg++)   tokens.push_back(sph);
  int rc = LinkUserFuncs2(tokens[0], tokens[1], tokens[2], tokens[3]);
  if (rc == 0)  cout << "PIABaseExecutor: Link2 from " << tokens[0] << " OK " << endl;
}
else if (kw == "call" ) {
  if (tokens.size() < 1) { cout << "Usage: call userf [arg1 arg2 ...]" << endl;  return(0); }
  UsFmap::iterator it;
  UsFmap::iterator it1 = usfmap.find(tokens[0]);
  UsFmap::iterator it2 = usfmap2.find(tokens[0]);
  if ((it1 == usfmap.end()) && (it2 == usfmap2.end()) ) {
    cerr << "PIABaseExecutor: No User Function " << tokens[0] << endl;
    return(0);
  }
  if (it1 == usfmap.end())  it = it2;
  else it = it1;
  cout << "PIABaseExecutor: Call " << tokens[0] << "( ... )" << endl;
// on est oblige de faire un cast  etant donne qu'on 
// utilise donc des DlFunction  (Reza 20/08/98)  voir commentaire ds .h (pb g++)
  DlUserProcFunction fuf = (DlUserProcFunction)(*it).second;
//   On redirige la sortie sur le terminal 
  bool red = mImgApp->HasRedirectedStdOutErr();
  mImgApp->RedirectStdOutErr(false);
#ifdef SANS_EVOLPLANCK
  TRY {
    tokens.erase(tokens.begin());
    fuf(tokens);
  }  CATCH(merr) {
    fflush(stdout); 
    string es = PeidaExc(merr);
    cerr << "\n PIABaseExecutor: Call UserFunc  Exception :" << merr << es;
    cout << endl; 
    }
#else
  try {
    tokens.erase(tokens.begin());
    fuf(tokens);
  }
  catch ( PThrowable & exc ) {
    cerr << "\n PIABaseExecutor: Call / Catched Exception :" 
	 << (string)typeid(exc).name() << " Msg= " 
	 << exc.Msg() << endl;
    cout << endl; 
  }
  catch ( ... ) {
    cerr << "\n PIABaseExecutor: Call / Catched Exception ... " 
	 << endl;
    cout << endl; 
  }
#endif
  mImgApp->RedirectStdOutErr(red);
}

// >>>>>>>>>>> lecture/ecriture des objets, gestion des objets 
else if (kw == "openfits" ) {
  if (tokens.size() < 1) { cout << "Usage: openfits file " << endl;  return(0); }
  else { string nomobj = "";  mObjMgr->ReadFits(tokens[0], nomobj); }
}
else if (kw == "savefits" ) {
  if (tokens.size() < 2) { cout << "Usage: savefits nameobj filename " << endl;  return(0); }
  else mObjMgr->SaveFits(tokens[0], tokens[1]);
}
else if (kw == "openppf" ) {
  if (tokens.size() < 1) { cout << "Usage: openppf file " << endl; return(0); }
  mObjMgr->ReadAll(tokens[0]);  
}
else if (kw == "saveobjs" ) {
  if (tokens.size() < 2) { cout << "Usage: saveobjs patt filename " << endl; return(0); }
  mObjMgr->SaveObjects(tokens[0], tokens[1]);  
}
else if (kw == "saveall" ) {
  if (tokens.size() < 1) { cout << "Usage: saveall file " << endl; return(0); }
  mObjMgr->SaveAll(tokens[0]);  
}
else if (kw == "print" ) {
  if (tokens.size() < 1) { cout << "Usage: print nameobj " << endl; return(0); }
  mObjMgr->PrintObj(tokens[0]);  
}
else if ( (kw == "rename" ) || (kw == "mv") )  {
  if (tokens.size() < 2) { cout << "Usage: rename nameobj namenew" << endl; return(0); }
  mObjMgr->RenameObj(tokens[0], tokens[1]);  
}
else if ( (kw == "del" ) || (kw == "rm") ) {
  if (tokens.size() < 1) { cout << "Usage: del nameobj [nameobj2 ...]" << endl; return(0); }
  if (tokens.size()>0)
    for(uint_4 i=0;i<tokens.size();i++)  mObjMgr->DelObj(tokens[i]);  
}
else if (kw == "delobjs" ) {
  if (tokens.size() < 1) { cout << "Usage: delobjs nomobjpattern (*,?) " << endl; return(0); }
  mObjMgr->DelObjects(tokens[0]);  
}
else if ( (kw == "listobjs") || (kw == "ls") )    { 
  if  (tokens.size() < 1)  tokens.push_back("*");
  mObjMgr->ListObjs(tokens[0]);
}
// Gestion des repertoires
else if (kw == "mkdir" ) {
  if (tokens.size() < 1) { cout << "Usage: mkdir dirname [true]" << endl; return(0); }
  bool crd = mObjMgr->CreateDir(tokens[0]);  
  if ( crd && (tokens.size() > 1) && (tokens[1] == "true") )
    mObjMgr->SetKeepOldDirAtt(tokens[0], true);
  }
else if (kw == "rmdir" ) {
  if (tokens.size() < 1) { cout << "Usage: rmdir dirname " << endl; return(0); }
  mObjMgr->DeleteDir(tokens[0]);  
  }
else if (kw == "cd")   { 
  if  (tokens.size() < 1)  tokens.push_back("home");
  mObjMgr->SetCurrentDir(tokens[0]);
  }
else if (kw == "pwd") { 
  string dirn;
  mObjMgr->GetCurrentDir(dirn);
  cout << "CurrentDirectory: " << dirn << endl;
  }  
else if (kw == "listdirs")   { 
  if  (tokens.size() < 1)  tokens.push_back("*");
  mObjMgr->ListDirs(tokens[0]);
  }

// >>>>>>>>>>> Creation d'histos 1D-2D
else if (kw == "newh1d") {
  if (tokens.size() < 4) { cout << "Usage: newh1d name xmin xmax nbin" << endl; return(0); }
  int_4 nbx = 100;
  r_8 xmin = 0., xmax = 1.;
  nbx = atoi(tokens[3].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  Histo* h = new Histo(xmin, xmax, nbx);
  mObjMgr->AddObj(h, tokens[0]);
  }
else if (kw == "newh2d") {
  if (tokens.size() < 7) { 
    cout << "Usage: newh2d name xmin xmax nbinx ymin ymax nbiny" << endl; 
    return(0); 
    }
  int_4 nbx = 50, nby = 50;
  r_8 xmin = 0., xmax = 1.;
  r_8 ymin = 0., ymax = 1.;
  nbx = atoi(tokens[3].c_str());
  nby = atoi(tokens[6].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());
  Histo2D* h = new Histo2D(xmin, xmax, nbx, ymin, ymax, nby);
  mObjMgr->AddObj(h, tokens[0]);
  }
else if (kw == "newprof" || kw == "newprofe") {
  if (tokens.size() < 4)
    { cout << "Usage: newprof[e] name xmin xmax nbin [ymin ymax]" << endl; return(0); }
  int_4 nbx = 100;
  r_8 xmin = 0., xmax = 1., ymin = 1., ymax = -1.;
  if(tokens.size() > 5)
    {ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());}
  nbx = atoi(tokens[3].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  HProf* h = new HProf(xmin, xmax, nbx, ymin, ymax);
  if(kw == "newprofe") h->SetErrOpt(false);
  mObjMgr->AddObj(h, tokens[0]);
  }

// Creation de NTuple
else if (kw == "newnt") {
  if(tokens.size() < 2)
    {cout<<"Usage: newnt name v1 v2 ... vn / newnt name nvar"<<endl; return(0);}
  vector<string> varname;
  int nvar = 0;
  const char *c = tokens[1].c_str();
  if(isdigit(c[0])) {
    nvar = atoi(tokens[1].c_str());
    if(nvar<=0 || nvar>=10000)
      {cout<<"newnt name nvar : nvar must be an positive integer<10000"<<endl;
       return(0);}
    for(int i=0;i<nvar;i++) {
      char str[16]; sprintf(str,"%d",i);
      string dum = "v"; dum += str;
      varname.push_back(dum.c_str());
    }
  } else if( islower(c[0]) || isupper(c[0]) ) {
    for(int i=1;i<(int)tokens.size();i++) {
      varname.push_back(tokens[i].c_str());
      nvar++;
    }
  } else {
    cout<<"newnt name v1 v2 ... vn : name vi must begin by a letter"<<endl
        <<"newnt name nvar : nvar must be an positive integer"<<endl;
    return(0);
  }
  char **noms = new char*[nvar];
  for(int i=0;i<nvar;i++) noms[i] = (char *)varname[i].c_str();
  NTuple* nt = new NTuple(nvar,noms);
  delete [] noms;
  mObjMgr->AddObj(nt,tokens[0]);
  }

// Creation de GeneralFitData
else if (kw == "newgfd") {
  if (tokens.size() < 3)
    { cout << "Usage: newgfd nvar nalloc [errx(0/1)]" << endl; return(0); }
  int nvar, nalloc, errx=0;
  if (tokens.size() > 3)
    { errx = atoi(tokens[3].c_str()); if(errx>0) errx=1; else errx = 0;}
  nvar = atoi(tokens[1].c_str()); nalloc = atoi(tokens[2].c_str());
  if(nvar>0 && nalloc>0) {
    GeneralFitData* gfd = new GeneralFitData(nvar,nalloc,errx);
    mObjMgr->AddObj(gfd, tokens[0]);
    }
  }

// Creation/remplissage de vecteur et de matrice
else if (kw == "newvec") {
  if (tokens.size() < 2) { 
    cout << "Usage: newvec name size [f(i) dopt] " << endl; return(0); 
    }
  int n = atoi(tokens[1].c_str());
  double xmin, xmax;
  xmin = 0.;  xmax = n;
  if (tokens.size() < 3)  { 
    Vector* v = new Vector(n);
    mObjMgr->AddObj(v, tokens[0]);
    }
  else {
    if (tokens.size() < 4)  tokens.push_back("");
    mObjMgr->GetServiceObj()->PlotFunc(tokens[2], tokens[0], xmin, xmax, n, tokens[3]); 
    }
  }
else if (kw == "newmtx") {
  if (tokens.size() < 3) { 
    cout << "Usage: newmtx name sizeX(Col) sizeY(Lines) [f(i,j) dopt] " << endl; return(0); 
    }
  int nx = atoi(tokens[1].c_str());
  int ny = atoi(tokens[2].c_str());
  double xmin, xmax, ymin, ymax;
  xmin = 0.;  xmax = nx;
  ymin = 0.;  ymax = ny;
  if (tokens.size() < 4)  {
    Matrix* mtx = new Matrix(ny,nx);
    mObjMgr->AddObj(mtx, tokens[0]);
    }
  else {
    if (tokens.size() < 5)  tokens.push_back("next");
    mObjMgr->GetServiceObj()->PlotFunc2D(tokens[3], tokens[0], xmin, xmax, ymin, ymax, 
                                         nx, ny, tokens[4]);
    }
  }

// Copie d'objets
else if (kw == "copy") {
  if(tokens.size()<2) { 
    cout<<"Usage: copy name_from  name_to"<<endl;return(0); 
  }
  mObjMgr->CopyObj(tokens[0],tokens[1]);
}


// >>>>>>>>>>>  Affichage des objets 
else if ( (kw == "disp") || (kw == "surf") || (kw == "imag") ) {
  if (tokens.size() < 1) { cout << "Usage: disp/surf/imag nameobj [opt]" << endl; return(0); }
  string opt = "next";
  if (tokens.size() > 1)  opt = tokens[1];
  if (kw == "disp") mObjMgr->DisplayObj(tokens[0], opt);
  else if (kw == "surf")  mObjMgr->DisplaySurf3D(tokens[0], opt);
  else if (kw == "imag")  mObjMgr->DisplayImage(tokens[0], opt);
  }

else if (kw == "nt2d") {
  if (tokens.size() < 3) { 
    cout << "Usage: nt2d nameobj varx vary [errx erry wt label opt]" << endl; 
    return(0); 
  }
  while (tokens.size() < 8) tokens.push_back("");
  string ph = "";
  mObjMgr->DisplayNT(tokens[0], tokens[1], tokens[2], ph, tokens[3], tokens[4], ph, 
                     tokens[5], tokens[6], tokens[7], false);
  }
else if (kw == "nt3d") {
  if (tokens.size() < 7) { 
    cout << "Usage: nt3d nameobj varx vary varz [errx erry errz wt label opt]" << endl; 
    return(0); 
  }
  while (tokens.size() < 10) tokens.push_back("");
  mObjMgr->DisplayNT(tokens[0], tokens[1], tokens[2], tokens[3], tokens[4], tokens[5],
                     tokens[6], tokens[7], tokens[8], tokens[9], true);
  }
else if (kw == "vecplot") {
  if (tokens.size() < 2) { 
    cout << "Usage: vecplot nameVecX nameVecY [opt]" << endl;
  }
  while (tokens.size() < 3) tokens.push_back("");
  mObjMgr->DisplayVector(tokens[0], tokens[1], tokens[2]);
}

// Obsolete : ne pas virer SVP, cmv 26/7/99
else if (kw == "gfd2d") {
  cout<<"----- gfd2d OBSOLETE: utilisez nt2d -----"<<endl;
  if(tokens.size()<2)
    {cout<<"Usage: gfd2d nomobj numvarx erreur=(x y xy) opt"<<endl;
     return(0);}
  string numvary = "";
  string err = "";
  string opt = "next";
  if(tokens.size()>2) err = tokens[2];
  if(tokens.size()>3) opt = tokens[3];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],numvary,err,opt);
  }
else if (kw == "gfd3d") {
  cout<<"----- gfd3d OBSOLETE: utilisez nt3d -----"<<endl;
  if(tokens.size()<3)
    {cout<<"Usage: gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) opt"<<endl;
     return(0);}
  string err = "";
  string opt = "next";
  if(tokens.size()>3) err = tokens[3];
  if(tokens.size()>4) opt = tokens[4];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],tokens[2],err,opt);
  }

// >>>>>>>>>>>  Trace de fonctions 
else if ( (kw == "func") ) {
  if(tokens.size()<3) {cout<<"Usage: func f(x) xmin xmax [npt opt]"<<endl; return(0);}
  int np = 100;
  double xmin=0., xmax=1.;
  string opt = "", nom = "";
  xmin = atof(tokens[1].c_str()); xmax = atof(tokens[2].c_str());
  if (tokens.size() > 3)  np = atoi(tokens[3].c_str());
  if (tokens.size() > 4)  opt = tokens[4];
  mObjMgr->GetServiceObj()->PlotFunc(tokens[0], nom, xmin, xmax, np, opt); 
  }
else if ( (kw == "funcff") ) {
  if (tokens.size()<4) {cout<<"Usage: funcff C-filename f(x)-name xmin xmax [npt opt]"<<endl; return(0);}
  int np = 100;
  double xmin=0., xmax=1.;
  string opt = "", nom = "";
  xmin = atof(tokens[2].c_str());  xmax = atof(tokens[3].c_str());
  if(tokens.size()>4)  np = atoi(tokens[4].c_str());
  if(tokens.size()>5)  opt = tokens[5];
  mObjMgr->GetServiceObj()->PlotFuncFrCFile(tokens[0], tokens[1], nom, xmin, xmax, np, opt); 
  }
else if ( (kw == "func2d") ) {
  if (tokens.size() < 7) {
    cout << "Usage: func2d f(x,y) xmin xmax nptx ymin ymax npty [opt]" << endl;
    return(0);
    }
  int npx, npy;
  double xmin, xmax;
  double ymin, ymax;
  npx = npy = 50;
  xmin = 0.;  xmax = 1.;
  ymin = 0.;  ymax = 1.;
  npx = atoi(tokens[3].c_str());
  npy = atoi(tokens[6].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());
  string opt = "";
  if (tokens.size() > 7)  opt = tokens[7];
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFunc2D(tokens[0], nom, xmin, xmax, ymin, ymax, npx, npy, opt);
  }
else if ( (kw == "func2dff") ) {
  if (tokens.size() < 8) {
    cout << "Usage: func2d C-filename F(x,y)-name xmax nptx ymin ymax npty [opt]" << endl;
    return(0);
    }
  int npx, npy;
  double xmin, xmax;
  double ymin, ymax;
  npx = npy = 50;
  xmin = 0.;  xmax = 1.;
  ymin = 0.;  ymax = 1.;
  npx = atoi(tokens[4].c_str());
  npy = atoi(tokens[7].c_str());
  xmin = atof(tokens[2].c_str());   xmax = atof(tokens[3].c_str());
  ymin = atof(tokens[5].c_str());   ymax = atof(tokens[6].c_str());
  string opt = "";
  if (tokens.size() > 8)  opt = tokens[8];
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFunc2DFrCFile(tokens[0], tokens[1], nom, xmin, xmax, ymin, ymax, npx, npy, opt);
  }

// >>>>>>>>>>>  Trace d'expressions de N_Tuple, StarList, etc ...
else if (kw == "plot2d" ) {
  if (tokens.size() < 3) {
    cout << "Usage: plot2d nameobj expx expy [expcut opt loop_par]" << endl;
    return(0); 
    }
  string errx = ""; string erry = ""; 
  if (tokens.size() < 4) tokens.push_back("1");
  while (tokens.size() < 6) tokens.push_back("");
  srvo->DisplayPoints2D(tokens[0],tokens[1],tokens[2],errx,erry,tokens[3],tokens[4],tokens[5]);
  }

else if (kw == "plot2de" ) {  // Plot2D avec les erreurs 
  if (tokens.size() < 5) {
    cout << "Usage: plot2de nameobj expx expy experrx experry [expcut opt loop_par]" << endl;
    return(0); 
    }
  if (tokens.size() < 6) tokens.push_back("1");
  while (tokens.size() < 8) tokens.push_back("");
  srvo->DisplayPoints2D(tokens[0],tokens[1],tokens[2],tokens[3],tokens[4],
                        tokens[5],tokens[6],tokens[7]);
  }

else if (kw == "plot2dw" ) {   // Plot2d avec poids
  if (tokens.size() < 4) { 
    cout << "Usage: plot2dw nomobj expx expy expwt [expcut opt loop_par]" << endl;
    return(0); 
    }
  if (tokens.size() < 5) tokens.push_back("1");
  while (tokens.size() < 7) tokens.push_back("");
  srvo->DisplayPoints2DW(tokens[0],tokens[1],tokens[2],tokens[3], tokens[4], tokens[5], tokens[6]);
  }
else if (kw == "plot3d" ) {  
  if (tokens.size() < 4) { 
    cout << "Usage: plot3d nomobj expx expy expz [expcut opt loop_par]" << endl;
    return(0); 
    }
  if (tokens.size() < 5) tokens.push_back("1");
  while (tokens.size() < 7) tokens.push_back("");
  srvo->DisplayPoints3D(tokens[0],tokens[1],tokens[2],tokens[3], tokens[4], tokens[5], tokens[6]);
  }

else if (kw == "projh1d" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: projh1d nomh1 nomobj expx [expwt expcut opt loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 4) tokens.push_back("1.");
  if (tokens.size() < 5) tokens.push_back("1");
  while (tokens.size() < 7) tokens.push_back("");
  srvo->ProjectH1(tokens[1], tokens[2], tokens[3], tokens[4], tokens[0], tokens[5], tokens[6] );
  }


// Projection dans histogrammes
else if (kw == "projh2d" ) {
  if (tokens.size() < 4) { 
    cout << "Usage: projh2d nomh2 nomobj expx expy [expwt expcut opt loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 5) tokens.push_back("1.");
  if (tokens.size() < 6) tokens.push_back("1");
  while (tokens.size() < 8) tokens.push_back("");
  srvo->ProjectH2(tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[0],
                  tokens[6], tokens[7] );
  }

else if (kw == "projprof" ) {
  if (tokens.size() < 4) { 
    cout << "Usage: projprof nomprof nomobj expx expy [expwt expcut opt loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 5) tokens.push_back("1.");
  if (tokens.size() < 6) tokens.push_back("1");
  while (tokens.size() < 8) tokens.push_back("");
  srvo->ProjectHProf(tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[0],
                     tokens[6], tokens[7] );
  }

// Projection dans vector/matrix
else if (kw == "fillvec" ) {
  if (tokens.size() < 4) { 
    cout << "Usage: fillvec nomvec nomobj expx expv [expcut opt loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 5) tokens.push_back("1");
  while (tokens.size() < 7) tokens.push_back("");
  srvo->FillVect(tokens[1], tokens[2], tokens[3], tokens[4], tokens[0], tokens[5], tokens[6] );
  }

else if (kw == "fillmtx" ) {
  if (tokens.size() < 5) { 
    cout << "Usage: fillmtx nommtx nomobj expx expy expv [expcut opt loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 6) tokens.push_back("1");
  while (tokens.size() < 8) tokens.push_back("");
  srvo->FillMatx(tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[0],
                    tokens[6], tokens[7] );
  }

// Remplissage NTuple,Vecteurs, ... , boucle de NTuple
else if (kw == "ntfrascii" ) {
  if(tokens.size() < 2) { 
    cout<<"Usage: ntfrascii nt_name file_name [def_init_val]"<<endl;
    return(0);
    }
  double def_val = 0.;
  if(tokens.size()>=3) def_val = atof(tokens[2].c_str());
  srvo->NtFromASCIIFile(tokens[0],tokens[1],def_val);
  }

else if (kw == "fillnt" ) {
  if (tokens.size() < 5) { 
    cout << "Usage: fillnt nameobj expx expy expz expt [expcut ntname loop_par]" << endl;
    return(0);
    }
  while (tokens.size() < 8) tokens.push_back("");
  srvo->FillNT(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], tokens[7] );
  }

else if (kw == "ntloop" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: ntloop nameobj fname funcname [ntname loop_par ]" << endl;
    return(0);
    }
  while (tokens.size() < 5) tokens.push_back("");
  srvo->FillNTFrCFile(tokens[0],tokens[1], tokens[2], tokens[3], tokens[4]);
  }

else if (kw == "ntexpcfile" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: ntexpcfile nameobj fname funcname" << endl;
    return(0);
    }
  srvo->PrepareNTExpressionCFile(tokens[0],tokens[1], tokens[2]);
  }

else if (kw == "exptovec" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: exptovec nomvec nameobj expx [expcut opt loop_par]" << endl;
    return(0);
    }
  while (tokens.size() < 6) tokens.push_back("");
  srvo->ExpressionToVector(tokens[1],tokens[2],tokens[3],tokens[0],tokens[4],tokens[5]);
  }

else if (kw == "fillgd1" ) {
  if (tokens.size() < 5) {
    cout << "Usage: fillgd1 nomgfd nomobj expx expy experry [expcut loop_par] " << endl;
    return(0);
    }
  if (tokens.size() < 6) tokens.push_back("1");
  if (tokens.size() < 7) tokens.push_back("");
  string expy = "";
  srvo->FillGFD(tokens[1],tokens[2], expy, tokens[3], tokens[4], tokens[5], tokens[0]);
  }

else if (kw == "fillgd2" ) {
  if (tokens.size() < 6) {
    cout << "Usage: fillgd2 nomgfd nomobj expx expy expz experrz [expcut loop_par]" << endl;
    return(0);
    }
  if (tokens.size() < 7) tokens.push_back("1");
  if (tokens.size() < 8) tokens.push_back("");
  srvo->FillGFD(tokens[1],tokens[2],tokens[3], tokens[4], tokens[5], tokens[6], tokens[0], tokens[7]);
  }

else if (kw == "gdfrvec" ) {
  if(tokens.size()<3) {
    cout<<"Usage: gdfrvec namegfd X Y\n"
        <<"       gdfrvec namegfd X Y"
        <<"       gdfrvec namegfd X Y ! EY\n"
        <<"       gdfrvec namegfd X Y Z\n"
        <<"       gdfrvec namegfd X Y Z EZ"<<endl;
    return(0);
  }
  while(tokens.size()<5) tokens.push_back("!");
  srvo->FillGFDfrVec(tokens[0],tokens[1],tokens[2],tokens[3],tokens[4]);
  }


else  { 
  cerr << "PIABaseExecutor::Do() Erreur - Commande " << kw << " inconuue ! " << endl;    
  return(-1);
  }

return(0);
}

// Fonction pour enregistrer le Help des Widgets et Windows de piapp 
static void RegisterPIGraphicsHelp(PIACmd* piac);

/* --Methode-- */
void PIABaseExecutor::RegisterCommands()
{
string kw, usage;
kw = "loadmodule";
usage = "To load and initialize modules \n  Usage: loadmodule fnameso modulename";
usage += "\n  Related commands: link";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");
kw = "link";
usage = "Dynamic linking of compiled user functions \n  Usage: link fnameso f1 [f2 f3]";
usage += "\n  fnameso: Shared-object file name, f1,f2,f3 : User function names ";
usage += "\n  Related commands: call loadmodule linkff2";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");
kw = "linkff2";
usage = "Dynamic linking of compiled user functions (Set 2)\n  Usage: linkff2 fnameso f1 [f2 f3]";
usage += "\n  fnameso: Shared-object file name, f1,f2,f3 : User function names ";
usage += "\n  Related commands: call link loadmodule";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");
kw = "call";
usage = "Dynamically linked user function call \n Usage: call userf [arg1 arg2 ...]";
usage += "\n  User function : f(vector<string>& args)";
usage += "\n  Related commands: link";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");

kw = "zone";
usage = "To Divide the Graphic window \n  Usage: zone [nx=1 ny=1]";
usage += "\n  Related commands: newwin";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");
kw = "newwin";
usage = "To Create a New Graphic window, with zones \n  Usage: newwin nx ny";
usage += "\n  Related commands: zone";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");
kw = "stacknext";
usage = "Displays the next widget on stack window \n  Usage: stacknext";
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "graphicatt";
usage = "To change default graphic options \n  Usage: graphicatt att_list \n";
usage += "att_list=def back to default values, Example: gratt 'red circlemarker5'";
usage += "\n ------------------ Graphic attribute list ------------------ \n";
usage += ">> Colors: defcol black white grey red blue green yellow \n";
usage += "           magenta cyan turquoise navyblue orange siennared purple \n";
usage += "           limegreen gold violet violetred blueviolet darkviolet \n";
usage += ">> Lines:  defline normalline thinline thickline dashedline thindashedline \n";
usage += "           thickdashedline dottedline thindottedline thickdottedline \n";
usage += ">> Font Att: deffontatt normalfont boldfont italicfont bolditalicfont  \n";
usage += "             smallfont smallboldfont smallitalicfont smallbolditalicfont \n";
usage += "             bigfont bigboldfont bigitalicfont bigbolditalicfont \n";
usage += "             hugefont  hugeboldfont hugeitalicfont hugebolditalicfont \n";
usage += ">> Font Names: deffont courierfont helveticafont timesfont symbolfont  \n";
usage += ">> Marker: dotmarker<T>  plusmarker<T>  crossmarker<T> circlemarker <T> \n";
usage += "           fcirclemarker<T> boxmarker<T> fboxmarker<T> trianglemarker<T> \n";
usage += "           ftrianglemarker<T>  starmarker<T>  fstarmarker<T> \n";
usage += "   with <T> = 1 3 5 7 9 , Example fboxmarker5 , plusmarker9 ... \n";
usage += ">> ColorTables: defcmap  grey32  invgrey32  colrj32  colbr32 \n";
usage += "                grey128  invgrey128  colrj128  colbr128 \n";
usage += "                midas_pastel midas_heat midas_rainbow3 midas_bluered\n";
usage += "                midas_bluewhite midas_redwhite \n";
usage += "                rainbow16 \n";
usage += "   revcmap : This flag reverses ColorMap indexing \n";
usage += ">> ZoomFactors: defzoom zoomx1 zoomx2 zoomx3 zoomx4 zoomx5 \n";
usage += "                               zoom/2 zoom/3 zoom/4 zoom/5 \n";
usage += ">> imagecenter=ix,iy -> Position the image in widget \n";
usage += ">> Axes:  stdaxes=defaxes=boxaxes  simpleaxes boxaxesgrid \n";
usage += "          fineaxes  fineaxesgrid \n"; 
usage += ">> LogScale : linx liny logx logy -> Lin/Log Scales for 2D plots \n";
usage += ">> XYLimits : xylimits  -> Forces X-Y limits in 2-D plots \n";
usage += ">> stat/nostat or stats/nostats -> Toggle statistic display flag \n";
usage += ">> title/notitle or tit/notit -> Toggle Auto AddTitle flag \n";
usage += ">> DisplayWindow: next same win stack inset \n";
usage += "   Related commands: setaxesatt setinsetlimits ";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "setaxesatt";
usage = "To set default axes attributes \n  Usage: setaxesatt att_list \n";
usage += ">> Axes:  stdaxes=defaxes=boxaxes  simpleaxes boxaxesgrid \n";
usage += "          fineaxes  fineaxesgrid \n"; 
usage += ">> LogScale : linx liny logx logy -> Lin/Log Scales for 2D plots \n";
usage += ">> xylimits=xmin,xmax,ymin,ymax  -> Forces X-Y limits in 2-D plots \n";
mpiac->RegisterCommand(kw, usage, this, "Graphics");


kw = "setinsetlimits";
usage = "Define the display rectangle for drawers added as insets \n";
usage += " over existing graphic objects - limits expressed as fraction \n";  
usage += " graphic object size (0. .. 1.) Xmax at right, YMax top. ";
usage += " Usage: setinsetlimits xmin xmax ymin ymax";
usage += "\n  Related commands: graphicatt /inset";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "setimgcenter";
usage = "Define image center postion \n Usage: setimgcenter xc yc";
usage += "\n  Related commands: graphicatt /centerimg";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addtext";
usage = "Adds a text string to the current graphic object";
usage += "\n at the specified position (+ color and font attributes) ";
usage += "\n The Base/AxesDrawer is used to handle added text strings" ;
usage += "\n Alt<Z> to remove added elements";
usage += "\n Font attribute is common with axes";
usage += "\n  Usage: addtext x y TextString [ColFontAtt]";
usage += "\n  (use quotes '' for multi word text strings) ";
usage += "\n  Related commands: addline addrect addfrect addcirc addfcirc settitle graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addline";
usage = "Adds a line to the current graphic object";
usage += "\n at the specified position (+ color attribute)";
usage += "\n The Base/AxesDrawer is used to handle added lines"; 
usage += "\n Alt<Z> to remove added elements";
usage += "\n  Usage: addline x1 y1 x2 y2 [ColAtt]";
usage += "\n  Related commands: addtext addrect addfrect addcirc addfcirc graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addrect";
usage = "Adds a rectangle to the current graphic object";
usage += "\n between the specified positions (+ color attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<Z> to remove added elements";
usage += "\n  Usage: addrect x1 y1 x2 y2 [ColAtt]";
usage += "\n  Related commands: addtext addline addfrect addcirc addfcirc graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addfrect";
usage = "Adds a filled rectangle to the current graphic object";
usage += "\n between the specified positions (+ color attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<Z> to remove added elements";
usage += "\n  Usage: addfrect x1 y1 x2 y2 [ColAtt]";
usage += "\n  Related commands: addtext addline addrect addcirc addfcirc graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addcirc";
usage = "Adds a circle to the current graphic object";
usage += "\n with the specified center and radius (+ color attribute)";
usage += "\n The Base/AxesDrawer is used to handle added circles"; 
usage += "\n Alt<Z> to remove added elements";
usage += "\n  Usage: addcirc xcenter ycenter radius [ColAtt]";
usage += "\n  Related commands: addtext addline addfrect addfrect addfcirc graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "addfcirc";
usage = "Adds a filled circle to the current graphic object";
usage += "\n with the specified center and radius (+ color attribute)";
usage += "\n The Base/AxesDrawer is used to handle added circles"; 
usage += "\n Alt<Z> to remove added elements";
usage += "\n  Usage: addcirc xcenter ycenter radius [ColAtt]";
usage += "\n  Related commands: addtext addline addfrect addfrect addcirc graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "settitle";
usage = "Set the title string (top title / bottom title) for the current graphic object";
usage += "\n  Usage: settitle TopTitle [BottomTitle] [fontAtt]";
usage += "\n  Related commands: addtext graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

RegisterPIGraphicsHelp(mpiac);

kw = "openfits";
usage = "Loads a FITS file into an Image<T> \n Usage: openfits filename";
usage += "\n  Related commands: savefits openppf";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "savefits";
usage = "Save an object into a FITS file \n Usage: savefits nameobj filename";
usage += "\n  Related commands: openfits saveall";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "openppf";
usage = "Reads all objects from a PPF file \n Usage: openppf filename";
usage += "\n  Related commands: saveall openfits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "saveobjs";
usage = "Saves objects with names matching a pattern (x?y*) into a PPF file \n";
usage += "Usage: saveobjs nameobjpattern filename";
usage += "\n  Related commands: saveall openppf savefits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "saveall";
usage = "Saves all objects into a PPF file \n Usage: saveall filename";
usage += "\n  Related commands: saveobj openppf savefits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "ntfrascii";
usage = "Fills an existing NTuple from ASCII table file";
usage += "\n Usage: ntfrascii nt_name file_name [def_init_val]";
usage += "\n  Related commands: ntloop fillnt ";
mpiac->RegisterCommand(kw, usage, this, "FileIO");


kw = "print";
usage = "Prints an object \n Usage: print nameobj";
mpiac->RegisterCommand(kw, usage, this, "FileIO");

kw = "mkdir";
usage = "Create a directory";
usage += "\n Usage: mkdir dirname [true]";
usage += "\n if second argument==true, the directory's KeepOld attribute is set to true";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "rmdir";
usage = "Removes an empty directory";
usage += "\n Usage: remove dirname";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "cd";
usage = "Change current directory";
usage += "\n Usage: cd [dirname]";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "pwd";
usage = "Prints current directory";
usage += "\n Usage: pwd";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "listdirs";
usage = "Prints the list of directories";
usage += "\n Usage: listdirs [patt=*] \n patt : * , ? ";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "listobjs";
usage = "Prints the list of objects (Alias: ls)";
 usage += "\n Usage: listobjs [patt=*] \n patt : /*/x?y* ... ";
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "rename";
usage = "Rename an object (Alias: mv) \n Usage: rename nameobj namenew";
usage += "\n  Related commands: del delobjs";  
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "copy";
usage = "Copy objects \n";
usage +="  Usage: copy name_from name_to";
usage += "\n  Related commands: new...";  
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "del";
usage = "Deletes an object (Alias: rm) \n Usage: del nameobj [nameobj2 ...]";
usage += "\n  Related commands: delobjs  rename";  
mpiac->RegisterCommand(kw, usage, this, "Object Management");
kw = "delobjs";
usage = "Delete a set of objects with names matching a pattern (x?y*)";
usage += "\n Usage: delobjs nameobjpattern \n";
usage += "\n  Related commands: del rename";  
mpiac->RegisterCommand(kw, usage, this, "Object Management");

kw = "newh1d";
usage = "Creates a 1D histogramm \n Usage: newh1d name xmin xmax nbin";
usage += "\n  Related commands: newh2d  newprof[e] newnt  newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newh2d";
usage = "Creates a 2D histogramm \n Usage: newh2d name xmin xmax nbinx ymin ymax nbiny";
usage += "\n  Related commands: newh1d  newprof[e] newnt  newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newprof";
usage = "Creates a profile histogramm \n Usage: newprof name xmin xmax nbin [ymin ymax]";
usage += "\n  Errors represent the data spread in the X bin ";  
usage += "\n  Related commands: newh1d  newh2d newprofe newnt newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newprofe";
usage = "Creates a profile histogramm \n Usage: newprofe name xmin xmax nbin [ymin ymax]";
usage += "\n  Errors represent the error on the data mean in the X bin ";  
usage += "\n  Related commands: newh1d  newh2d newprof newnt newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newnt";
usage = "Creates a ntuple \n Usage: newnt name v1 v2 v3 .. vn";
usage += "\n        newnt name nvar";  
usage += "\n  Related commands: newh1d  newh2d newprof[e] newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newgfd";
usage = "Creates GeneralFit Data object \n Usage: newgfd nvar nalloc [errx(0/1)]";
usage += "\n  Related commands: newh1d  newh2d  newprof[e] newnt ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newvec";
usage = "Creates (and optionaly fills) a vector \n Usage: newvec name size [f(i) [dopt] ] ";
usage += "\n  Related commands: newmtx";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newmtx";
usage = "Creates (and optionaly fills) a matrix \n";
usage +="  Usage: newmtx name sizeX(Col) sizeY(Lines) [f(i,j) [dopt] ] ";
usage += "\n  Related commands: newvec";  
mpiac->RegisterCommand(kw, usage, this, "Objects");

kw = "disp";
usage = "Displays an object \n Usage: disp nameobj [graphic_attributes]";
usage += "\n  Related commands: surf nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "imag";
usage = "Displays an object as an image \n Usage: imag nameobj [graphic_attributes]";
usage += "\n  Related commands: disp surf nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "surf";
usage = "Displays an object as a 3D surface \n Usage: surf nameobj [graphic_attributes]";
usage += "\n  Related commands: disp nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "nt2d";
usage = "Displays Points (X-Y) [with error-bar / Weight / Label ] from an NTuple ";
usage += "\n Usage : nt2d nameobj varx vary [errx erry wt label graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt3d  gfd2d vecplot";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "nt3d";
usage = "Displays 3D-Points (X-Y-Z) [with error-bars / Weight / Label ] from an NTuple ";
usage += "\n Usage : nt3d nameobj varx vary varz [errx erry errz wt label graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d gfd3d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "vecplot";
usage = "Displays Points (X-Y) with coordinates defined by two vectors ";
usage += "\n Usage : vecplot nameVecX nameVecY [graphic_attributes]";
usage += "\n  Related commands: disp nt2d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");

// Ceci est maintenant obsolete, on garde pour info.
kw = "gfd2d";
usage = "Displays Points (X-Y) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd2d nameobj numvarx erreur=(x y xy) [graphic_attributes]";
usage += "\n  Related commands: gfd3d nt2d nt3d ";
usage += "\n  ----- OBSOLETE: utilisez nt2d -----";
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "gfd3d";
usage = "Displays 3D-Points (X-Y-Z) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) [graphic_attributes]";
usage += "\n  Related commands: gfd2d nt2d nt3d ";  
usage += "\n  ----- OBSOLETE: utilisez nt3d -----";
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");

kw = "func";
usage = "Displays a function y=f(x) (Fills a vector with function values)";
usage += "\n Usage: func f(x) xmin xmax [npt graphic_attributes]";
usage += "\n  Related commands: funcff func2d func2dff ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "funcff";
usage = "Displays a function y=f(x) from a C-file (Fills a vector with function values)";
usage += "\n Usage: funcff C-FileName FunctionName xmin xmax [npt graphic_attributes]";
usage += "\n  Related commands: func func2d func2dff ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "func2d";
usage = "Displays a function z=f(x,y) (Fills a matrix with function values)";
usage += "\n Usage: func2d f(x,y) xmin xmax nptx ymin ymax npty [graphic_attributes]";
usage += "\n  Related commands: func";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "func2dff";
usage = "Displays a function z=f(x,y) from a C-file (Fills a matrix with function values)";
usage += "\n Usage: func2dff C-FileName FunctionName xmin xmax nptx ymin ymax npty [graphic_attributes]";
usage += "\n  Related commands: func funcff func2d ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");

kw = "ObjectExpressions";
usage = "Any mathematical expression (math.h) with object variables can be used";
usage += "\n  ------ Object Variable names (double) -------- ";
usage += "\n- NTuple: ntuple variable names";
usage += "\n- Histo1D/HProf: i,x,val,err";
usage += "\n- Histo2D: i,j,x,y,val,err";
usage += "\n- Vector/Matrix: n,r,c,val,real,imag,mod,phas";
usage += "\n- TArray: n,x,y,z,t,u,val,real,imag,mod,phas";
usage += "\n- Image: i,j,x,y,val(=pix)";
usage += "\n- GeneralFitData: x0,ex0 x1,ex1 ...  xn,exn   y,ey   ok";
usage += "\n- LocalMap/SphereThetaPhi/SphereHEALPix: ";
usage += "\n-         i,k,val,real,imag,mod,phas,teta,phi";
usage += "\n- FITS Binary/ASCII table: fits column names";
usage += "\n  ------ Other parameters -------- ";
usage += "\nLoop parameters can be specified as I1[:I2[:DI]] for(int i=I1; i<I2; i+=DI)"; 
usage += "\nThe default Cut() expression in true (=1) for all"; 
usage += "\n\n  Related commands: plot2d plot2de plot2dw plot3d "; 
usage += "\n        projh1d projh2d  projprof fillvec fillmtx "; 
usage += "\n        fillnt fillgd1 fillgd2 ntloop exptovec ... ";
mpiac->RegisterCommand(kw, usage, NULL, "Expr. Plotting");
kw = "plot2d";
usage = "Plots (2D) Y=g(Object) vs. X=f(Object) --- Object Variable names (double) :";
usage += "\n Usage: plot2d nameobj f_X() g_Y() [f_Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: plot2de plot2dw plot3d ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "plot2de";
usage = "Plots (2D) Y=g(Object) vs. X=f(Object) with error bars eX/Y=f_ErrX/Y(Object) ";
usage += "\n Usage: plot2de nameobj f_X() g_Y() f_ErrX() f_ErrY() [f_Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: plot2d plot2dw plot3d ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "plot2dw";
usage = "Plots (2D) Y=g(Object) vs. X=f(Object) with Weight W=h(Object) ";
usage += "\n Usage: plot2dw nameobj f_X() g_Y() h_Wt() [Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: plot2d plot2dw plot3d ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "plot3d";
usage = "Plots (3D) Z=h(Object) vs. Y=g(Object) vs. X=f(Object) vs ";
usage += "\n Usage: plot3d nameobj f_X() g_Y() h_Z() [Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: plot2d plot2dw plot2de plot3d ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "projh1d";
usage = "Projects X=f(Object) with weight WT=h(Object) into a 1D histogram ";
usage += "\n Usage: projh1d nameh1d nameobj f_X() [h_WT()=1. Cut() graphic_attributes loop_param]";
usage += "\n   Histo1D nameh1d is created if necessary ";
usage += "\n  Related commands: projh2d projprof ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "projh2d";
usage = "Projects (X=f(Object),Y=g(Object)) with weight WT=h(Object) into a 2D histogram ";
usage += "\n Usage: projh2d nameh2d nameobj f_X() g_Y() [h_WT()=1. Cut() graphic_attributes loop_param]";
usage += "\n   Histo2D nameh2d is created if necessary ";
usage += "\n  Related commands: projh1d projprof ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "projprof";
usage = "Projects (X=f(Object),Y=g(Object)) with weight WT=h(Object) into a profile histogram ";
usage += "\n Usage: projprof nameprof nameobj f_X() g_Y() [h_WT()=1. Cut() graphic_attributes loop_param]";
usage += "\n   HProf nameprof is created if necessary ";
usage += "\n  Related commands: projh1d projh2d ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillvec";
usage = "Fills a Vector V((int)(f_X(Object)+0.5)) =  h_V(Object) ";
usage += "\n Usage: fillvec namevec nameobj f_X() h_V() [Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: fillmtx fillnt ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillmtx";
usage = "Fills a Matrix M(Line=g_Y(Object)+0.5, Col=f_X(Object)+0.5)) =  h_V(Object) ";
usage += "\n Usage: fillvec namevec nameobj f_X() g_Y() h_V() [Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: fillvec fillnt ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "fillnt";
usage = "Creates and Fills an NTuple(x,y,z,t) with (X=f(Object),Y=g(...),Z=h(...),T=k(...))";
usage += "\n Usage: fillnt nameobj f_X() g_Y() h_Z() k_T() [Cut() nameNt loop_param]";
usage += "\n  Related commands: ntloop plot2d projh1d projh2d projprof ";
usage += "\n  Related commands: fillvec fillmtx ntloop exptovec fillgd1 fillgd2 ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "ntloop";
usage = "Loops over an Object NTupleInterface calling a function from a C-file \n";
usage += "and optionaly fills an NTuple(x,y,z,t) with (X=f(Object),Y=g(...),Z=h(...),T=k(...))";
usage += "\n Usage: ntloop nameobj CFileName FuncName [NtupleName loop_param]";
usage += "\n  Related commands: fillvec fillmtx fillnt fillgd1 fillgd2 exptovec ObjectExpressions ..."; 
usage += "\n  Related commands: ntexpcfile fillnt";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "ntexpcfile";
usage = "Creates a C-File with declarations suitable to be used for ntloop";
usage += "\n Usage: ntexpcfile nameobj CFileName FuncName ";
usage += "\n  Related commands: ntloop";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "exptovec";
usage = "Creates and Fills a Vector with X=f(Object)";
usage += "\n Usage: exptovec namevec nameobj f_X() [Cut() graphic_attributes loop_param]";
usage += "\n  Related commands: ntloop fillnt ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillgd1";
usage = "Creates and Fills a GeneralFitData with (X=f(Object), Y=g(...), ErrY=h(...))";
usage += "\n Usage: fillgd1 namegfd nameobj f_X() g_Y() h_ErrY() [Cut() loop_param]";
usage += "\n  Related commands: ntloop fillnt ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillgd2";
usage = "Creates and Fills a GeneralFitData with (X=f(Object), Y=g(...), Z=h(...)) ErrZ=k(...)";
usage += "\n Usage: fillgd1 namegfd nameobj f_X() g_Y() h_Z() k_ErrZ() [Cut() loop_param]";
usage += "\n  Related commands: ntloop fillnt ObjectExpressions ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "gdfrvec";
usage = "Fills a GeneralFitData with vectors X,Y,Z,EZ";
usage += "\n Usage: gdfrvec namegfd X Y";
usage += "\n Usage: gdfrvec namegfd X Y ! EY";
usage += "\n Usage: gdfrvec namegfd X Y Z";
usage += "\n Usage: gdfrvec namegfd X Y Z EZ";
usage += "\n  Related commands: fillgd1 fillgd2 ..."; 
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

}

/* --Methode-- */
int PIABaseExecutor::LinkUserFuncs(string& fnameso, string& func1, string& func2, string& func3)
//                          string& func4, string& func5)
{
string cmd;

if (dynlink) delete dynlink;    dynlink = NULL;
usfmap.clear();

dynlink = new PDynLinkMgr(fnameso, true);
if (dynlink == NULL) { 
  string sn = fnameso; 
  cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur ouverture SO " << sn << endl; 
  return(2); 
  }

int nok=0;
// on utilise donc des DlFunction  (Reza 20/08/98)  voir commentaire ds .h (pb g++)
// DlUserProcFunction f = NULL;
DlFunction f = NULL;
if ((func1.length() < 1) || (func1 == "-") || (func1 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func1.c_str());
f = dynlink->GetFunction(func1);
if (f) { nok++;  usfmap[func1] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func1 << endl;

if ((func2.length() < 1) || (func2 == "-") || (func2 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func2.c_str());
f = dynlink->GetFunction(func2);
if (f) { nok++;  usfmap[func2] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func2 << endl;

if ((func3.length() < 1) || (func3 == "-") || (func3 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func3.c_str());
f = dynlink->GetFunction(func3);
if (f) { nok++;  usfmap[func3] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func3 << endl;

/*  Pb compile g++ 2.7.2 
if ((func4.length() < 1) || (func4 == "-") || (func4 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func4.c_str());
f = dynlink->GetFunction(func4);
if (f) { nok++;  usfmap[func4] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func4 << endl;

if ((func5.length() < 1) || (func5 == "-") || (func5 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func5.c_str());
f = dynlink->GetFunction(func5);
if (f) { nok++;  usfmap[func5] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func5 << endl;
*/
fin:
if (nok < 1) { if (dynlink) delete dynlink;    dynlink = NULL;  return(3); }
else return(0);
}

/* --Methode-- */
int PIABaseExecutor::LinkUserFuncs2(string& fnameso, string& func1, string& func2, string& func3)
{
string cmd;

if (dynlink2) delete dynlink2;    dynlink2 = NULL;
usfmap2.clear();

dynlink2 = new PDynLinkMgr(fnameso, true);
if (dynlink2 == NULL) { 
  string sn = fnameso; 
  cerr << "PIABaseExecutor/LinkUserFuncs2_Erreur: Erreur ouverture SO " << sn << endl; 
  return(2); 
  }

int nok=0;
// on utilise donc des DlFunction  (Reza 20/08/98)  voir commentaire ds .h (pb g++)
// DlUserProcFunction f = NULL;
DlFunction f = NULL;
if ((func1.length() < 1) || (func1 == "-") || (func1 == ".") )  goto fin;
f = dynlink2->GetFunction(func1);
if (f) { nok++;  usfmap2[func1] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs2_Erreur: Erreur linking " << func1 << endl;

if ((func2.length() < 1) || (func2 == "-") || (func2 == ".") )  goto fin;
f = dynlink2->GetFunction(func2);
if (f) { nok++;  usfmap2[func2] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs2_Erreur: Erreur linking " << func2 << endl;

if ((func3.length() < 1) || (func3 == "-") || (func3 == ".") )  goto fin;
f = dynlink2->GetFunction(func3);
if (f) { nok++;  usfmap2[func3] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs2_Erreur: Erreur linking " << func3 << endl;

fin:
if (nok < 1) { if (dynlink2) delete dynlink2;    dynlink2 = NULL;  return(3); }
else return(0);
}

/* Nouvelle-Fonction */
void RegisterPIGraphicsHelp(PIACmd* piac)
{
string kw,grp,usage;

grp = "Graphics";

kw = "PIImage";
usage = "Manages the display of a 2-D array (P2DArrayAdapter) as an image \n";
usage += "and controls a zoom widget, as well as a global image view widget \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Display current coordinates and pixel value\n";
usage += "  Position the cursor an refresh the zoom widget\n";
usage += "o Button-2: Defines an image zone and positions the cursor \n";
usage += "o Button-3: Moves the viewed portion of the array inside the window \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Refresh display \n";
usage += "o <Alt>O : Shows the PIImageTools (image display parameter controls) \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of overlayed graphics (Drawers)) \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current cursor position \n";
usage += "o <Alt>C : Copy/Paste / Copies the selected regions content as text in the copy/paste buffer \n";
usage += "o <Alt>X : Show/Hide the Cut Window \n";
usage += "o <Alt>Z : Removes signs overlayed on image (Drawer 0) \n";
usage += "o Cursor keys : Moves the image cursor \n";
piac->RegisterHelp(kw, usage, grp);

kw = "PIScDrawWdg";
usage = "Manages display of 2-D drawers with interactive zoom \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Display current coordinates \n";
usage += "o Button-2: Defines a rectangle for zoom \n";
usage += "o Button-3: Defines a rectangle for Text-Info (<Alt>I) \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Refresh display \n";
usage += "o <Alt>O : Displays a specific control window (default: PIDrawerTools) \n";
usage += "           Specific controls for 2-D histograms \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of displayed Drawers) \n";
usage += "           Drawer 0 manages the axes, as well as the added text \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current position \n";
usage += "o <Alt>Z : Removes added signs (text) to Drawer 0 \n";
usage += "o <Alt>I : Shows (or updates) a text info window on the selected rectangle \n";
usage += "o <Alt>M : Activate/Deactivate a measurement cursor on Button-1\n";
usage += "o <Alt>L : Deactivate DX,DY print (see below)\n";
usage += ">>>> Mouse + Keyboard controls : \n";
usage += "o Button-1 + <Alt>K : Set (reset) the reference point for DX,DY print \n";
piac->RegisterHelp(kw, usage, grp);

kw = "PIDraw3DWdg";
usage = "Manages display of 3-D objects (drawers)  \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-2: Rotates the observer (camera) around object \n";
usage += "o Shift-Button-2: Rotates object with camera fixed \n";
usage += "  The object rotation mode can be assigned to Button-2 with <Alt>S \n";
usage += "o Button-3: Zoom control (Camera distance And/Or view angle) \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Resets the 3-D view and refreshes the display \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of displayed Drawers) \n";
usage += "o <Alt>O : = <Alt>G \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current position (Drawer 0)\n";
usage += "o <Alt>Z : Removes added signs (text) to Drawer 0 \n";
usage += "o <Alt>A : Activate/Deactivate axes drawing \n";
usage += "o <Alt>S : Activate/Deactivate object rotation mode on Button-2 \n";
piac->RegisterHelp(kw, usage, grp);

kw = "Windows";
usage = "Objects can be displayed in different windows, or overlayed on the \n";
usage += "previous display. The graphics attributes next,win,stack,same control \n";
usage += "the display window. \n";
usage += "o GraphicWindow : This is the default mode (gr_att=next)\n";
usage += "  Graphic windows can be divided int zones. Object is displayed \n";
usage += "  in the next available position, removing a previously displayed \n";
usage += "  widget if necessary \n";
usage += "o Window : An object is displayed in its own window (gr_att= win) \n";
usage += "o StackWindow : multpile widgets can be stacked in a StackWindow (gr_att= stack) \n";
usage += "  A single widget is displayed a any time. Different widgets in a StackWindow \n";
usage += "  can be displayed using the stacknext command, as well as the StackTools item \n";
usage += "  in the Tools menu (from Menubar). An automatic cyclic display mode can also \n";
usage += "  be activated using the StackTools menu (Blink) \n";
usage += "o Most objects can be also be displayed overlayed \n";
usage += "  on the last displayed widget (gr_att= same) \n";
usage += "o The overlay can be on a selected rectangle of the \n";  
usage += "  last displayed widget (gr_att= inset) - See setinsetlimits\n";
usage += "\n  Related commands: newwin zone stacknext graphicatt setinsetlimits";  
piac->RegisterHelp(kw, usage, grp);

kw = "PIConsole";
usage = "Text output area and command editing window (console) \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Rectangle selection for copy/paste \n";
usage += "o Button-2: Paste text in the command editing line \n";
usage += "o Button-3: activate display option menu \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>O : activate display option menu   \n";
usage += "o <Alt>V : Paste text in the command editing line \n";
usage += "o <Alt>A : Selection of the whole window for copy \n";
usage += "o <Alt>L : Command history (List of command history buffer) \n";
usage += "o <Ctl>A : Command editing -> Goto the beginning of line \n";
usage += "o <Ctl>E : Command editing -> Goto the end of line \n";
usage += "o <Ctl>K : Command editing -> Clear to the end of line \n";
usage += "o <Ctl>C : Command editing -> Clear the line \n";
usage += "o Cursor left,right : Command editing -> Move cursor \n";
usage += "o Cursor Up,Down : recall command from history buffer \n";
usage += "o Backspace,Del : Command editing \n";
usage += "o <Return>,<Enter> : Execute command \n";
piac->RegisterHelp(kw, usage, grp);
}
