#include "contmodex.h"

#include "pigncont.h"
#include <typeinfo>

#include <vector>
#include <string>
#include "nobjmgr.h"

#include "pidrawer.h"
#include "nomgadapter.h"
#include "servnobjm.h"


/* --Methode-- */
ContModExecutor::ContModExecutor(PIACmd* mpiac, PIStdImgApp* app)
{

  //PIACmd * mpiac;
  //NamedObjMgr omg;
  //mpiac = omg.GetImgApp()->CmdInterpreter();

  //cout << " ContModExecutor::ContModExecutor() mpiac = " << (unsigned long)mpiac << endl;
  cout << " registration of contour commands "<<endl;
  string hgrp,kw,usage;
  
  hgrp = "Obj. Display";
  
  kw = "contour";
  usage = "Creates and displays a ContourDrawer ";
  usage += "\n Usage: contour objectName [graphic_att] ";
  mpiac->RegisterCommand(kw, usage, this, hgrp);
  
  hgrp = "Obj. Display";
  kw = "ntcont";
  usage = "Creates and displays a ContourDrawer (from a NTuple)";
  usage += "\n Usage: ntcont NTupleName varx vary varz [graphic_att] ";
  mpiac->RegisterCommand(kw, usage, this, hgrp);

  //cout << " Out of ContModExecutor::ContModExecutor() " << endl;

}
 


/* --Methode-- */
ContModExecutor::~ContModExecutor()
{
}

/* --Methode-- */
int ContModExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{
  
int nz=-1;
double z0,dz;
  
if ( kw == "contour") {
   NamedObjMgr omg;
   PIContourDrawer * contdrw = NULL;
   string dopt="";
 
   if (tokens.size() < 1) {
     cout << "Usage: contour ObjName [graphic_att]" << endl;
     return(0);
   }

   //   dopt = "same,thinline";  Si tu veux des valeurs par defaut
   //if (tokens.size() > 1)  dopt = tokens[1];
   //omg.PrintObj(tokens[0]);
   NObjMgrAdapter* obja = omg.GetObjAdapter(tokens[0]);
   if (obja == NULL) {
     cout << "contour Error , No object with name " << tokens[0] << endl; 
     return(0);
   }
   string ctyp = typeid(*obja).name();
   cout << " objet de type "<<ctyp <<endl;
   AnyDataObj* ob = obja->GetDataObj();
   if (ob == NULL) {
     cerr << "Error - NULL object ! in " <<  tokens[0] << endl;
     return(0);
   }
   ctyp = typeid(*ob).name();
   cout << " objet de type "<<ctyp <<endl;
   cout << " ContModExecutor::Execute recuperation du p2darrayadapter "<<endl;
   if (tokens.size() > 1) dopt = tokens[1];
   P2DArrayAdapter* arr = obja->Get2DArray(dopt);
   if (arr != NULL) {
       contdrw = new PIContourDrawer(arr,true           );
   }else{
     cout <<"contour ERREUR : OBJET "<<tokens[0]<<" N'A PAS DE P2DARRADAPTOR "<<endl;
     return(0);
   }

   
   cout << " contour: Creating PIContourDrawer() for object" << tokens[0] << endl;
   
   cout << " contour: Determination of contour lines ..."<< contdrw <<endl;
   contdrw->CalcContour();
   //NTuple *out = contdrw->MyIso();
   //NTuple *truc = new NTuple(*out);
   //string nom = "isoc";
   //if(out!=NULL) omg.AddObj(truc,nom   );
   cout << " ===>>> success ! "<< contdrw <<endl;

   // On affiche le Drawer
   int wrsid = 0;
   
   string name = "contour";
   cout << " ContModExecutor::Execute() : name "<<name<<" " <<"| dopt |"<<dopt<<"| contdrw |"<<contdrw<<endl;
   wrsid = omg.GetImgApp()->DispScDrawer(contdrw, name, dopt); 
   cout << " fin de ContModExecutor::Execute() "<< endl;
   

   // Ne pas oublier d'associer le wrsid a l'objet si on utilise le P2DArrayAdapter* arr
   omg.AddWRsId(tokens[0], wrsid);
   

   }
if ( kw == "ntcont"){  
     NamedObjMgr omg;
     PIContourDrawer * contdrw = NULL;
     string dopt="";
     bool adel;
     //cout << " essai avec ntuple "<<tokens.size()<<endl;
     if (tokens.size() < 4) {
       cout << "Usage: contour NtName varx vary varz [graphic_att]"
	    << endl;
       return(0);
     }
     dopt="";
     NObjMgrAdapter* obja = omg.GetObjAdapter(tokens[0]);
     if (obja == NULL) {
       cout << "ntcont Error , No NTuple with name " << tokens[0] << endl; 
       return(0);
     }
    
     NTupleInterface *ntin = obja->GetNTupleInterface(adel);
     //cout << " tokens.size() "<< tokens.size()<<endl;
     //for (int k=0; k<tokens.size() ; k++)cout<<"| k "<<k<<" tok |"<<tokens[k];
     //cout <<endl;
     if (tokens.size() > 4) dopt = tokens[4];
     if (tokens.size() > 6){
         dz = atof(tokens[6].c_str());
         z0 = atof(tokens[7].c_str());
         cout << " ContModExecutor::Execute [NT] nz,z,dz : "<<nz<<" , "<<z0 << " , " << dz<<endl;
         contdrw = new PIContourDrawer(ntin,adel,&nz,&z0,&dz);
     }
     if (tokens.size() > 5){
         nz = atoi(tokens[5].c_str()); 
         cout << " ContModExecutor::Execute [NT] nz : "<<nz<< endl;
         contdrw = new PIContourDrawer(ntin,adel,&nz           );
     }else {
       contdrw = new PIContourDrawer(ntin,adel           );
     }
     cout << " ntcont: Creating PIContourDrawer() for object " << tokens[0] << endl;
   
     cout << " ntcont : Determination of contour lines ..." <<endl;
     contdrw->CalcContour();
    
     NTuple *out = contdrw->MyIso();
     if(out!=NULL){
	NTuple *truc = new NTuple(*out);
	string nom = "isoc";
	//truc->Write("isocur.ppf");
	//out->Write("outcur.ppf");
	omg.AddObj(truc,nom   );
     }
     /****************/
     cout << " ===>>> success ! "<<endl;

   // On affiche le Drawer
     int wrsid = 0;
     bool fgsr = true;
     
     string name = "contour";
     
     wrsid = omg.GetImgApp()->DispScDrawer(contdrw, name, dopt); 
     
     // Ne pas oublier d'associer le wrsid a l'objet si on utilise le P2DArrayAdapter* arr
     omg.AddWRsId(tokens[0], wrsid);

   }
   


return(0);

}



