// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toiseqbuff.h,v 1.10 2002-05-07 16:38:03 ansari Exp $

#ifndef TOISEQBUFF_H
#define TOISEQBUFF_H

#include "toi.h"

// -------------------  TOISeqBuffered ---------------------------
// Classe de TOI avec buffer, et echantillonnage regulier.
// Pour le moment au moins,
// il faut que les providers fassent arriver les donnees par samplenum croissant.
// ---------------------------------------------------------------

class TOISeqBuffered : public TOIRegular {
public:
  TOISeqBuffered(int wsz=8192);
  TOISeqBuffered(string nm, int wsz=8192);
  virtual ~TOISeqBuffered();

  
  inline  void SetBufferSize(int wsz)  // ATTENTION - Ne doit pas etre appele
               { AllocBuffer(wsz); }   // apres le demarrage des threads

  virtual void PrintStatus(::ostream & os) const; 

  inline void setDebugLevel(int lev=0) { dbglev=lev; }
  inline int  getDebugLevel() const { return dbglev; }

  virtual double        getData(int i);
  virtual void          getData(int i, double& data,  uint_8& flag);
  virtual void          getData(int i, int n, double* data, uint_8* flg=0);
  virtual void          putData(int i, double  value, uint_8  flag=0);
  virtual void          putData(int i, int n, double const* val, uint_8 const* flg=0);
  virtual void          wontNeedBefore(int i);

  inline int getFirstIn() const { return first_in; }
  inline int getFirstOut() const { return first_out; }
  inline int getLastIn() const { return (next_in-1); }
  inline int getLastOut() const { return (next_out-1); }


  virtual DataStatus isDataAvailNL(int iStart, int iEnd);
  virtual DataStatus isDataAvailNL(int i); // override required

protected:
  double* data;
  uint_8*  flags;
  int wsize;
  int buffsize;
  int next_in;
  int next_out;
  int first_in;
  int first_out;
  bool started;
  double defaultValue;
  int dbglev;

  void    AllocBuffer(int wsz);

#ifdef WITH_SOPHYA
  /* ---- l'interface va etre modifiee, NE PAS UTILISER
  virtual Array         doGetData(int iStart, int iEnd);
  virtual TArray<int_4> doGetFlag(int iStart, int iEnd);
  l'interface va etre modifiee, NE PAS UTILISER ---- */
#endif
  virtual void          doGetData(int i, double & val, uint_8 & flg);
   
  virtual void          doPutData(int i, double value, uint_8 flag=0);
  //  virtual void          doWontNeedBefore(int i);  plus besoin ? - Reza Mai 2002

  virtual int           nextDataAvail(int iAfter);
  virtual bool          hasSomeData();

  inline double &       dataRef(int i) { return data[i%buffsize]; }
  inline uint_8 &        flagRef(int i) { return flags[i%buffsize]; }
  inline bool           isDataDeleted(int i) 
    { return((i < next_in-buffsize-1) ? true : false); }
};


#endif
