// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari

#ifndef CGT_H
#define CGT_H

#include "toi.h"
#include "toiprocessor.h"
#include <vector>

// -------------------------------------------------------------------------
// classe CGT : Compagnie Generale des Tuyaux 
// Gestionnaire de tuyaux (toi) et d'unites de traitements (TOIProcessor)
//                                         R. Ansari / Mai 2002
// -------------------------------------------------------------------------

class CGT {
public:
  CGT(bool fgsegmented = true, int bufsz=1024, int maxseg=20);
  virtual ~CGT();

  void    SelectTOISegmented(int bufsz=1024, int maxseg=20);
  void    SelectTOISeqBuffered(int wsz=8192);

  inline void  SetDebugLevel(int lev=0) {dbgLevel = lev; }
  
  virtual TOI& Connect(TOIProcessor& prout, string& out, 
		       TOIProcessor& prin, string& in, string nom="", int wbsz=0);
  virtual TOI& Connect(TOIProcessor& prout, const char* out, 
		       TOIProcessor& prin, const char* in, string nom="", int wbsz=0);

  virtual void ListProcs(::ostream& os, bool prstat=false); // const plus tard
  virtual void ListTOIs(::ostream& os, bool prstat=false);  // const plus tard 
  virtual void PrintStatus(::ostream & os, bool prstat=false); // const plus tard

  virtual void DeleteProcs();
  virtual void Start();

protected:
  int findProcId(TOIProcessor* pr);

  struct tuyau { int pr1id; int pr2id; TOI* toi; };
  vector< tuyau > lesTuyaux;
  vector< TOIProcessor* > lesProcs;
  bool fgSegmented;
  int segBuffsz, segMaxseg;
  bool fgSeqbuff;
  int seqWsz;

  int dbgLevel;
};

inline ostream& operator << (ostream& os, CGT& cgt) 
{ cgt.PrintStatus(os); return os; }

#endif
