// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toimanager.h,v 1.12 2002-05-13 15:50:50 ansari Exp $


#ifndef TOIMANAGER_H
#define TOIMANAGER_H

#include "config.h"
#include <string>
#include <vector>

using namespace std;

class TOIManager {
public:
  static TOIManager* getManager();
  void setRequestedSample(int begin, int end);
  int getRequestedBegin();
  int getRequestedEnd();
  void addThread(pthread_t*);
  void joinAll();
  
protected:
  TOIManager();
  static TOIManager* instance;
  long reqBegin;
  long reqEnd;

  vector<pthread_t*> threads;
};

// -----------------------------------------------------------------
//    Classe pour affichage de l'avancement des TOIProcessors 
//                         Reza 08/2001 
// -----------------------------------------------------------------

class RzProcSampleCounter {
public:
  RzProcSampleCounter();
  virtual       ~RzProcSampleCounter();
  virtual long  ProcessedSampleCount() = 0;
  virtual long  SampleBegin() = 0;
  virtual long  SampleEnd() = 0;
  virtual long  PrintStats();
  inline int &  PrintRate(int pr) { return _rate; } 
  inline string& InfoMessage() { return _msg; } 
protected:
  int _rate;
  string _msg;
};

template <class T>
class ProcSampleCounter : public RzProcSampleCounter {
public:
  ProcSampleCounter(const T & t) { _t = &t; } 
  virtual long  ProcessedSampleCount()
  { return _t->ProcessedSampleCount(); }
  virtual long  SampleBegin() { return _t->getMinIn(); }
  virtual long  SampleEnd() { return _t->getMaxIn(); }
protected:
  const T * _t;
};

#endif

