#include <stdio.h>

#include <LString.h>
#include "pibwdgmac.h"
#include "piupdattachment.h"

// Les methodes de la classe  PIBWdgGen
 
/* --Methode-- */
PIBaseWdgMac::PIBaseWdgMac(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) :
PIBaseWdgGen(par, nom, sx, sy, px, py)
{
    mPane->AddAttachment(new PIUpdAttachment(this));
    cursor = NULL;
}


/* --Methode-- */
PIBaseWdgMac::~PIBaseWdgMac()
{
}


/* --Methode-- */
void PIBaseWdgMac::ActivatePtrCross()
{
// toujours actif pour le moment
}


/* --Methode-- */
void PIBaseWdgMac::ActivateButton(int /*bid*/)
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivateMove(int /*bid*/)
{
}


/* --Methode-- */
void PIBaseWdgMac::ActivateKeyboard()
{
}

/* --Methode-- */
void PIBaseWdgMac::EraseWindow()
{
  if (mPane->FocusDraw()) {
     GrafPtr p = mPane->GetMacPort();
     if (p) EraseRgn(p->visRgn);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawString(int x, int y, char* s, int /*pos*/)
{
  if (mPane->FocusDraw()) {
    Point pt = {y,x};
    mPane->LocalToPortPoint(pt);
    ::MoveTo(pt.h, pt.v);
    LStr255 ps = s;
    ::DrawString(ps);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawLine(int x1, int y1, int x2, int y2)
{
  if (mPane->FocusDraw()) {
    Point pt = {y1,x1};
    mPane->LocalToPortPoint(pt);
    ::MoveTo(pt.h, pt.v);
	SetPt(&pt,x2,y2);
    mPane->LocalToPortPoint(pt);
    ::LineTo(pt.h, pt.v);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawBox(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
    Point pt = {y0,x0};
    mPane->LocalToPortPoint(pt);
    Rect r = {pt.v, pt.h, pt.v+dy, pt.h+dx};
    ::FrameRect(&r);
  }
}


/* --Methode-- */
void PIBaseWdgMac::DrawFBox(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
    Point pt = {y0,x0};
    mPane->LocalToPortPoint(pt);
    Rect r = {pt.v, pt.h, pt.v+dy, pt.h+dx};
    ::PaintRect(&r);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawCircle(int x0, int y0, int r) 
{
  if (mPane->FocusDraw()) {
    Point pt = {y0,x0};
    mPane->LocalToPortPoint(pt);
    Rect rr = {pt.v-r, pt.h-r, pt.v+r, pt.h+r};
    ::FrameOval(&rr);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawFCircle(int x0, int y0, int r) 
{
  if (mPane->FocusDraw()) {
    Point pt = {y0,x0};
    mPane->LocalToPortPoint(pt);
    Rect rr = {pt.v-r, pt.h-r, pt.v+r, pt.h+r};
    ::PaintOval(&rr);
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelForeground(PIColors col) 
{
  if (mPane->FocusDraw()) {
    long color;
    switch (col) {
      case PI_Black:
        color = blackColor;
        break;
      case PI_White:
        color = whiteColor;
        break;
      case PI_Red:
        color = redColor;
        break;
      case PI_Blue:
        color = blueColor;
        break;
      case PI_Green:
        color = greenColor;
        break;
      case PI_Yellow:
        color = yellowColor;
        break;
      default:
        color = blackColor;
    }
    ::ForeColor(color);
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelBackground(PIColors col) 
{
  if (mPane->FocusDraw()) {
    long color;
    switch (col) {
      case PI_Black:
        color = blackColor;
        break;
      case PI_White:
        color = whiteColor;
        break;
      case PI_Red:
        color = redColor;
        break;
      case PI_Blue:
        color = blueColor;
        break;
      case PI_Green:
        color = greenColor;
        break;
      case PI_Yellow:
        color = yellowColor;
        break;
      default:
        color = blackColor;
    }
    ::BackColor(color);
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelFont(PIFontSize sz,PIFontAtt att)
{
  if (mPane->FocusDraw()) {
    switch(sz) {
      case PI_SmallSizeFont:
        ::TextSize(9);
        break;
      case PI_NormalSizeFont:
        ::TextSize(12);
        break;
      case PI_BigSizeFont:
        ::TextSize(14);
        break;
    }
    switch(att) {
      case PI_RomanFont:
        ::TextFace(0);
        break;
      case PI_BoldFont:
        ::TextFace(bold);
        break;
      case PI_ItalicFont:
        ::TextFace(italic);
        break;
    }
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelLine(PILineAtt att)
{
  if (mPane->FocusDraw()) {
    switch(att) {
      case PI_NormalLine:
        ::PenSize(1,1);
        break;
      case PI_ThinLine:
        ::PenSize(1,1);  // Mettre en pointille, ou bien commentaire pour Laser ?
        break;
      case PI_ThickLine:
        ::PenSize(2,2);
        break;
    }
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelPointerShape(PIPointer ptr)
{
  CursHandle c;
  if (mPane->FocusDraw()) {
    switch(ptr) {
      case PI_ArrowPointer:
        cursor = &qd.arrow;
        break;
      case PI_CrossPointer:
        c = GetCursor(crossCursor);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
      case PI_HandPointer:
        c = GetCursor(128);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
    }
  }
}

/* --Methode-- */
bool PIBaseWdgMac::AdjustCursor()
{
  if (cursor) {
    ::SetCursor(cursor);
    return true;
  }
  return false;
}

/* --Methode-- */
void PIBaseWdgMac::Refresh()
{
if (mPane->IsVisible())
  Draw();
}

/* --Methode-- */
void PIBaseWdgMac::Resize()
{
#ifdef DEBUG_RZXB
printf ("Debug_PIBaseWdgMac::ReSize %ld %ld NewSize= %d %d\n", 
         (long)(this), (long)(this->sdw), 
         (int)this->sdw->core.width, (int)this->sdw->core.height);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgMac::Draw(int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
this->Draw();
return;
}

/* --Methode-- */
void PIBaseWdgMac::Draw()
{
#ifdef DEBUG_RZXB
this->PIEraseWindow();
this->PIDrawFBox(10,10, XSize()*2/3, YSize()*2/3);
#endif
return;
}


