#ifndef PIMENUMAC_H_SEEN
#define PIMENUMAC_H_SEEN

#include "pimenugen.h"
#include <LMenu.h>
#include <vector.h>
#include <list.h>

// Menu general
class PIMenuMac : public PIMenuGen {
public:
					PIMenuMac(PIMsgHandler* par, char* nom, PIMenuType pdpu);
				   ~PIMenuMac();
				   
	virtual void	AppendItem(char* nom, long msg);

    virtual void    DeleteItem(char *nom);
    virtual void    DeleteItemMsg(long msg);
    virtual void    DeleteItemNum(int n);

    virtual void    CheckItem(char *nom, bool st=false); 
    virtual void    CheckItemMsg(long msg, bool st=false); 
    virtual void    CheckItemNum(int n, bool st=false); 
	
    virtual void    Show();
    virtual void    Hide();
    
    int             MenuId() {return mMenuId;}
    void            ItemSelected(int item);
    
	static PIMenuMac* findMenu(int id);
	MenuHandle      GetMacMenuHandle();
	ResIDT          GetMacMenuID();
	string          GetMenuItemText(int item);
	
protected:
	LMenu*          macMenu;
	int             mMenuId;
	vector<long>    mMsgs;
	static int      lastId;
	static list<PIMenuMac*> sMenus;
	
	friend class    PIMenubarMac;
	
	int             FindItemByMsg(long msg);
	int             FindItemByName(string const& nom);
   
};

// Menu popup
class PIPUMenuMac : public PIMenuMac
{
public:
               PIPUMenuMac(PIMsgHandler* par, char* nom);
               ~PIPUMenuMac();
virtual void   Show();
};

// Menu pull-down
class PIPDMenuMac : public PIMenuMac
{
public:
               PIPDMenuMac(PIMsgHandler* par, char* nom);
               ~PIPDMenuMac();
};


typedef PIMenuMac      PIMenu;
typedef PIPUMenuMac    PIPUMenu;
typedef PIPDMenuMac    PIPDMenu;

#endif