#include<stdlib.h>
#include<string.h>

#include "pisysdep.h"
#include PISTDWDG_H

/************* PILabelX ************/
#include <Xm/Label.h>


/* --Methode-- */
PILabelX::PILabelX(PIContainerGen *par, char *nom,
                   int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
CreateXtWdg(nom, xmLabelWidgetClass, NULL, sx, sy, px, py);
SetBorderWidth(0);
Manage();
}

/* --Methode-- */
PILabelX::~PILabelX()
{}


/************* PIButtonX ************/
#include <Xm/PushB.h>

// Fonction prive (CallBack)
static void button_action(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  button_action(Widget w, XtPointer *usd, XtPointer *calld)
{
PIButtonX *pib;
pib = (PIButtonX *) usd ;
pib->Send(pib->Msg());
return;
}

/* --Methode-- */
PIButtonX::PIButtonX(PIContainerGen *par, char *nom, long msg,
                         int sx, int sy, int px, int py)
: PIButtonGen(par, nom, msg, sx, sy, px, py)
{
CreateXtWdg(nom, xmPushButtonWidgetClass, NULL, sx, sy, px, py);
XtAddCallback(XtWdg(), XmNactivateCallback, 
              button_action, (XtPointer)this);
Manage();
}

/* --Methode-- */
PIButtonX::~PIButtonX()
{}



/************* PITextX ************/
#include <Xm/Text.h>

/* --Methode-- */
PITextX::PITextX(PIContainerGen *par, char *nom,
                 int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
CreateXtWdg(nom, xmTextWidgetClass, NULL, sx, sy, px, py);
Manage();
}

/* --Methode-- */
PITextX::~PITextX()
{}

/* --Methode-- */
void PITextX::SetText(string const& s)
{
XmTextSetString(XtWdg(), (char *)s.c_str());
return;
}

/* --Methode-- */
string PITextX::GetText() const
{
char *txtb;
txtb = XmTextGetString(XtWdg());
string s(txtb);
XtFree(txtb);
return(s);
}


/************* PIScaleX ************/
#include <Xm/Scale.h>

// Fonction prive (CallBack)
static void scale_action(Widget w, XtPointer *usd, XtPointer *calld);

void  scale_action(Widget w, XtPointer *usd, XtPointer *calld)
{
PIScale *pis;

pis = (PIScale *) usd ;
pis->Send(pis->Msg(), (void *)pis->GetValue());

return;
}

/* --Methode-- */
PIScaleX::PIScaleX(PIContainerGen *par, char *nom, long msg,
                   int min, int max, int sx, int sy, int px, int py)
: PIScaleGen(par, nom, msg, min, max, sx, sy, px, py)
{
int n=0;
Arg warg[6];
CreateXtWdg(nom, xmScaleWidgetClass, NULL, sx, sy, px, py);
XtSetArg(warg[n], XmNshowValue, TRUE); n++;
XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
XtSetArg(warg[n], XmNscaleWidth, sx); n++;
XtSetArg(warg[n], XmNscaleHeight, sy); n++;
XtSetArg(warg[n], XmNstringDirection, XmSTRING_DIRECTION_R_TO_L); n++;
XtSetArg(warg[n], XmRProcessingDirection, XmMAX_ON_RIGHT); n++;
XtSetValues(XtWdg(), warg, n);
SetMinMax(min, max);
XtAddCallback(XtWdg(), XmNvalueChangedCallback, 
              scale_action, (XtPointer)this);
Manage();
}

/* --Methode-- */
PIScaleX::~PIScaleX()
{}

/* --Methode-- */
void PIScaleX::SetMinMax(int min, int max)
{
int n=0;
Arg warg[2];
XtSetArg(warg[n], XmNminimum, min); n++;
XtSetArg(warg[n], XmNmaximum, max); n++;
XtSetValues(XtWdg(), warg, n);
return;
}


/* --Methode-- */
void PIScaleX::SetValue(int val)
{
int n=0;
Arg warg[2];
XtSetArg(warg[n], XmNvalue, val); n++;
XtSetValues(this->sdw, warg, n);
return;
}

/* --Methode-- */
int  PIScaleX::GetValue()
{
int val;
int n=0;
Arg warg[2];
XtSetArg(warg[n], XmNvalue, &val); n++;
XtGetValues(this->sdw, warg, n);
return(val);
}


/************* PICheckBoxX ************/
#include <Xm/ToggleB.h>

// Fonction prive (CallBack)
static void toggb_action(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  toggb_action(Widget w, XtPointer *usd, XtPointer *calld)
{
PICheckBoxX *picb;
picb = (PICheckBoxX *) usd ;
picb->Send(picb->Msg(), (void *)picb->GetState());
return;
}

/* --Methode-- */
PICheckBoxX::PICheckBoxX(PIContainerGen *par, char *nom, long msg,
                         int sx, int sy, int px, int py)
: PICheckBoxGen(par, nom, msg, sx, sy, px, py)
{
CreateXtWdg(nom, xmToggleButtonWidgetClass, NULL, sx, sy, px, py);
XtAddCallback(XtWdg(), XmNvalueChangedCallback,
              toggb_action, (XtPointer)this);
Arg warg[2];
XtSetArg(warg[0],XmNhighlightThickness, 0);
XtSetValues(XtWdg(), warg, 1);
Manage();
}


/* --Methode-- */
PICheckBoxX::~PICheckBoxX()
{}


/* --Methode-- */
void PICheckBoxX::SetState(bool st)
{
Arg warg[2];
XtSetArg(warg[0],XmNset, st);
XtSetValues(XtWdg(), warg, 1);
return;
}

/* --Methode-- */
bool PICheckBoxX::GetState()
{
int val;
Arg warg[2];
XtSetArg(warg[0], XmNset, &val); 
XtGetValues(XtWdg(), warg, 1);
return ((bool)val);
}
