#ifndef PIBWDGGEN_H_SEEN
#define PIBWDGGEN_H_SEEN

#include "pisysdep.h"
#include PIWDG_H

#include "pibwdggen.h"

enum PIKeyModifier { PIKM_Blank = 0, PIKM_Shift = 1, PIKM_Alt = 2, PIKM_Cntl = 4 } ; 

enum PIColors { PI_Black = 0, PI_White = 1, 
                PI_Red = 2, PI_Blue = 3, PI_Green = 4,  
                PI_Yellow = 5 } ; 
enum PIFontSize {PI_SmallSizeFont = 1, PI_NormalSizeFont = 2, PI_BigSizeFont = 3 };
enum PIFontAtt {PI_RomanFont = 1, PI_BoldFont = 2, PI_ItalicFont = 4 };
enum PILineAtt { PI_NormalLine = 0, PI_ThinLine = 1, PI_ThickLine = 2 };

enum PIPointer { PI_ArrowPointer = 1, PI_CrossPointer = 2, PI_HandPointer = 3 };

class PIBaseWdgGen : public PIWdg
{
public:
  enum {ClassId = 5000};

// Les methodes ...

                     PIBaseWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIBaseWdgGen();

  virtual long    kind() {return ClassId; }

//  Activation des evenements   
  virtual void       ActivatePtrCross()        = 0;
  virtual void       ActivateButton(int bid)   = 0;
  virtual void       ActivateMove(int bid)     = 0;
  virtual void       ActivateKeyboard()        = 0;

//  Trace graphiques
  virtual void       EraseWindow()             = 0;
  virtual void       DrawString(int x, int y, char* s, int pos = 0)        = 0;
  virtual void       DrawLine(int x1, int y1, int x2, int y2)              = 0;  
  virtual void       DrawBox(int x0, int y0, int dx, int dy)               = 0;
  virtual void       DrawFBox(int x0, int y0, int dx, int dy)              = 0;
  virtual void       DrawCircle(int x0, int y0, int r)                     = 0;
  virtual void       DrawFCircle(int x0, int y0, int r)                    = 0;

  virtual void       SelForeground(PIColors col=PI_Black)                  = 0;
  virtual void       SelBackground(PIColors col=PI_White)                  = 0;
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont)                   = 0;
  virtual void       SelLine(PILineAtt att=PI_NormalLine)                  = 0;
  virtual void       SelPointerShape(PIPointer ptr)                        = 0;


  virtual void       Refresh()         = 0;
  
// Traitement des evenements   
  virtual void       Resize()          = 0;
  virtual void       Draw()            = 0;
  virtual void       Draw(int x0, int y0, int dx, int dy) = 0;

  virtual void       Enter();
  virtual void       Leave();  
  virtual void       But1Press(int x, int y);  
  virtual void       But1Release(int x, int y); 
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  virtual void       Ptr3Move(int x, int y);
  virtual void       Keyboard(int key, PIKeyModifier kmod);
};


#endif /* PIBWDGGEN_H_SEEN */
