#include<stdio.h>
#include<string.h>

#include "pisysdep.h"

#include "pifilechox.h"


/************* PIFileChooserX ************/
#include <X11/Shell.h>
#include <Xm/FileSB.h>

// Fonction prive (CallBack)
static void filesel_okact(Widget w, XtPointer *usd, XtPointer *calld);
static void filesel_cancelact(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  filesel_okact(Widget w, XtPointer *usd, XtPointer *calld)
{
PIFileChooserX *pif;
pif = (PIFileChooserX *) usd ;
pif->mSt = 1;
pif->Send(pif->Msg(), (void *) (pif->GetFileName().c_str()));
pif->MWin()->Unmanage();
return;
}

/* Nouvelle-Fonction */
void  filesel_cancelact(Widget w, XtPointer *usd, XtPointer *calld)
{
PIFileChooserX *pif;
pif = (PIFileChooserX *) usd ;
pif->mSt = 0;
pif->Send(pif->Msg(), NULL);
pif->MWin()->Unmanage();
return;
}

#define PIFC_SzX  350
#define PIFC_SzY  300

/* --Methode-- */
PIFileChooserX::PIFileChooserX(PIMsgHandler* par, char* nom, long msg)
: PIFileChooserGen(par, nom, msg)
{
SysDWdg wdg;

mWin = NULL;
mWin = new PIWdgX(NULL, nom, PIFC_SzX, PIFC_SzY, 150, 150);
mWin->CreateXtWdg(nom, topLevelShellWidgetClass, NULL, PIFC_SzX, PIFC_SzY, 200, 200);

mSt = 0;

CreateXtWdg(nom, xmFileSelectionBoxWidgetClass, mWin->XtWdg(), PIFC_SzX, PIFC_SzY, 0, 0);
XtAddCallback(XtWdg(), XmNokCallback, 
              filesel_okact, (XtPointer)this);
XtAddCallback(XtWdg(), XmNcancelCallback, 
              filesel_cancelact, (XtPointer)this);
// Pour avoir une version simplifiee 
/* wdg = XmFileSelectionBoxGetChild(XtWdg(),XmDIALOG_DIR_LIST);
XtUnmanageChild(wdg);
wdg = XmFileSelectionBoxGetChild(XtWdg(),XmDIALOG_DIR_LIST_LABEL);
XtUnmanageChild(wdg);
*/
wdg = XmFileSelectionBoxGetChild(XtWdg(),XmDIALOG_HELP_BUTTON);
XtUnmanageChild(wdg);

fnl = XmFileSelectionBoxGetChild(XtWdg(),XmDIALOG_SELECTION_LABEL);
fnw = XmFileSelectionBoxGetChild(XtWdg(),XmDIALOG_TEXT);

Arg warg[2];
XtSetArg(warg[0], XmNfileTypeMask, XmFILE_REGULAR);
XtSetValues(XtWdg(), warg, 1);

AcceptNewFile(false);
Manage();
}

/* --Methode-- */
PIFileChooserX::~PIFileChooserX()
{
}

/* --Methode-- */
void PIFileChooserX::AcceptNewFile(bool acc)
{
if (acc) 
  {
  mWin->SetSize( PIFC_SzX, PIFC_SzY+75);
  XtManageChild(fnl);  XtManageChild(fnw); 
  }
else 
  { 
  mWin->SetSize( PIFC_SzX, PIFC_SzY+50);
  XtUnmanageChild(fnl); XtUnmanageChild(fnw); 
  }
}

/* --Methode-- */
void PIFileChooserX::Show()
{
mWin->Manage();
}

/* --Methode-- */
void PIFileChooserX::SetPath(string const& path)
{
XmString xmstr;
xmstr = XmStringLtoRCreate((char *)path.c_str(), XmSTRING_DEFAULT_CHARSET);
Arg warg[2];
XtSetArg(warg[0], XmNdirectory, xmstr); 
XtSetValues(XtWdg(), warg, 1);
XmStringFree(xmstr);
return;
}

/* --Methode-- */
void PIFileChooserX::SetFileName(string const& fname)
{
XmString xmstr;
xmstr = XmStringLtoRCreate((char *)fname.c_str(), XmSTRING_DEFAULT_CHARSET);
Arg warg[2];
XtSetArg(warg[0], XmNtextString, xmstr); 
XtSetValues(XtWdg(), warg, 1);
XmStringFree(xmstr);
return;
}


/* --Methode-- */
string PIFileChooserX::GetFileName()
{

if (mSt)
  {
  char *buff;
  XmString xmstr;
  Arg warg[2];

  XtSetArg(warg[0], XmNtextString, &xmstr);
  XtGetValues(XtWdg(), warg, 1);
  XmStringGetLtoR(xmstr, XmSTRING_DEFAULT_CHARSET, &buff); 
  string s(buff);
  XmStringFree(xmstr);
  return(s);
  }
else
  {
  string s("");
  return(s);
  }
}

/* --Methode-- */
string PIFileChooserX::GetPath()
{
printf("PIFileChooserX::GetPath() not implemented ! \n");
string s("");
return(s);
}

