#ifndef PISTDWDGGEN_H_SEEN
#define PISTDWDGGEN_H_SEEN

#include <string>
#include "pisysdep.h"
#include PIWDG_H

class PILabelGen : public PIWdg {
public:
  enum {ClassId = 1001};

                     PILabelGen(PIContainerGen* par, char* nom,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PILabelGen();

  virtual long       kind() {return ClassId; }
};

class PIButtonGen : public PIWdg
{
public:
  enum {ClassId = 1002};

                     PIButtonGen(PIContainerGen* par, char* nom, long msg = PIMsg_Click,
                                  int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIButtonGen();

  virtual long       kind() {return ClassId; }
  
protected:

};

class PITextGen : public PIWdg
{
public:

  enum {ClassId = 1003};

  		     PITextGen(PIContainerGen* par, char* nom,
         		       int sx=10, int sy=10, int px=0, int py=0);
  virtual	     ~PITextGen();
  virtual void       SetText(string const&) = 0;
  virtual string     GetText() const = 0;

  virtual long       kind() {return ClassId; }
};


class PIScaleGen : public PIWdg
{
public:
  enum {ClassId = 1004};

                     PIScaleGen(PIContainerGen* par, char* nom, long msg = PIMsg_Click,
                     int min=0, int max=10, int sx=100, int sy=10, int px=0, int py=0);
  ~PIScaleGen();

  virtual void       SetMinMax(int min, int max) = 0;
  virtual void       SetValue(int val) = 0;
  virtual int        GetValue() = 0; 

  virtual long       kind() {return ClassId; }

protected:


};

class PICheckBoxGen : public PIWdg
{
public:

  enum {ClassId = 1005};

                     PICheckBoxGen(PIContainerGen* par, char* nom, 
                                   long msg = PIMsg_Click,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PICheckBoxGen()=0;
  virtual void      SetState(bool st=false)=0;
  virtual bool      GetState()=0;
  
  virtual long       kind() {return ClassId; }

protected:

};



#endif
