#include "pistdwdgmac.h"
#include <LString.h>
#include <PP_Messages.h>

/************* PILabelMac ************/
#include <LCaption.h>

PILabelMac::PILabelMac(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LCaption(mPaneInfo, titre, 0);
}

PILabelMac::~PILabelMac()
{}


/************* PIButtonMac ************/
#include <LStdControl.h>

PIButtonMac::PIButtonMac(PIContainerGen *par, char *nom, long msg,
                         int sx, int sy, int px, int py)
: PIButtonGen(par, nom, msg, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdButton(mPaneInfo, msg_Click, 0, titre);
  ((LStdButton*)mPane)->AddListener(this);
}

PIButtonMac::~PIButtonMac()
{}

void
PIButtonMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_Click)
    Send(myMsg);
}


/************* PITextMac ************/
#include <LEditField.h>

PITextMac::PITextMac(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LEditField(mPaneInfo, titre, 0, 255, true, true, NULL, LCommander::GetTopCommander());
}

PITextMac::~PITextMac()
{}

void
PITextMac::SetText(string const& s)
{
  SetLabel(s);
}

string
PITextMac::GetText() const
{
  Str255 desc;
  mPane->GetDescriptor(desc);
  p2cstr(desc);
  return (char*) desc;
}

/************* PIScaleMac ************/
static ControlActionUPP	sSBarAction = nil;


PIScaleMac::PIScaleMac(PIContainerGen* par, char* nom, long msg,
                       int min, int max, int sx, int sy, int px, int py)
: PIScaleGen(par, nom, msg, min, max, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdControl(mPaneInfo, msg_Click, min, min, max,
						  scrollBarProc, 0, titre, (Int32) this);
  ((LStdControl*)mPane)->AddListener(this);
  
  if (sSBarAction == nil) {	// Allocate UPP if necessary
	sSBarAction = NewControlActionProc((ProcPtr) SBarAction);
  }
  ((LStdControl*)mPane)->SetActionProc(sSBarAction);
}

PIScaleMac::~PIScaleMac()
{}

void
PIScaleMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_ThumbDragged)
    Send(myMsg);
}

void
PIScaleMac::SetMinMax(int min, int max)
{
  ((LStdControl*)mPane)->SetMinValue(min);
  ((LStdControl*)mPane)->SetMaxValue(max);
}

void
PIScaleMac::SetValue(int val)
{
  ((LStdControl*)mPane)->SetValue(val);
}

int
PIScaleMac::GetValue()
{
  return ((LStdControl*)mPane)->GetValue();
}

pascal void
PIScaleMac::SBarAction(
	ControlHandle	inMacControl,
	Int16			inPart)
{
	PIScaleMac		*theScroller =
							(PIScaleMac *) GetControlReference(inMacControl);
	theScroller->HandleScroll(inPart);
}

void
PIScaleMac::HandleScroll(
	const Int16		inPart)
{
    int delta;
	switch (inPart) {				// Determine how much to scroll
	
		case kControlUpButtonPart:	// Scroll left one unit
			delta = -1;
			break;
			
		case kControlDownButtonPart:	// Scroll right one unit
			delta = 1;
			break;
			
		case kControlPageUpPart:		// Scroll left by Frame width
										//   less one unit of overlap
			delta = -10;
			break;
			
		case kControlPageDownPart:		// Scroll right by Frame width
										//   less one unit of overlap
			delta = 10;
			break;
	}
	
	if (delta != 0) {
	    SetValue(GetValue()+delta);
	}
}

/************* PICheckBoxMac ************/
#include <LStdControl.h>

PICheckBoxMac::PICheckBoxMac(PIContainerGen *par, char *nom, long msg,
                         int sx, int sy, int px, int py)
: PICheckBoxGen(par, nom, msg, sx, sy, px, py)
{
  delete mPane;
  LStr255 titre(nom);
  mPane = new LStdCheckBox(mPaneInfo, msg_Click, 0, 0, titre);
  ((LStdCheckBox*)mPane)->AddListener(this);
}

PICheckBoxMac::~PICheckBoxMac()
{}

void
PICheckBoxMac::ListenToMessage(MessageT inMessage, void *)
{
  if (inMessage == msg_Click)
    Send(myMsg);
}

void
PICheckBoxMac::SetState(bool st)
{
  ((LStdCheckBox*)mPane)->SetValue(st ? 1 : 0);
}
 
bool
PICheckBoxMac::GetState()
{
  return ((LStdCheckBox*)mPane)->GetValue();
}
