#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "piwdgx.h"
#include "picmapx.h"

/* --Methode-- */
PIColorMapX::PIColorMapX(CMapId id)
: PIColorMapGen(id) 
{
int n = nCols[id-1];
mColors = new PIXColor[n];
for(int i=0; i<n; i++)  mColors[i] = BlackPixel(PIXDisplay(), PIXScreen());

// printf("PIColorMapX::PIColorMapX(CMapId) %d %d \n", mNCol, Type());
return;
}

/* --Methode-- */
PIColorMapX::PIColorMapX(CMapId id, int i)       // Fait une veritable allocation
: PIColorMapGen(id,i)
{

int n = nCols[id-1];
mColors = new PIXColor[n];
for(int i=0; i<n; i++)  mColors[i] = BlackPixel(PIXDisplay(), PIXScreen());
// printf("PIColorMapX::PIColorMapX(CMapId, int) %d %d \n", mNCol, Type());

return;
}


/* --Methode-- */
PIColorMapX::PIColorMapX(string const& nom, int nCol)
: PIColorMapGen(nom, nCol)
{

int n = nCol;
mColors = new PIXColor[n];
for(int i=0; i<n; i++)  mColors[i] = BlackPixel(PIXDisplay(), PIXScreen());
// printf("PIColorMapX::PIColorMapX(nom, nCol) %d %d \n", mNCol, Type());

return;

}

/* --Methode-- */
PIColorMapX::~PIColorMapX()
{
delete[] mColors;
}

static  Colormap  defxcmap;
static  xinicmap = 0;

/* --Methode-- */
void PIColorMapX::AllocColor(PIColor const& col, int index)
{
XColor myxcol;

if (!xinicmap)  
  {
  defxcmap = XDefaultColormap (PIXDisplay(), PIXScreen());
  xinicmap = 1;
  }

if ( (index < 0) || (index > mNCol) )  return;
myxcol.red = col.red; 
myxcol.blue = col.blue;
myxcol.green = col.green;

if ( XAllocColor(PIXDisplay(), defxcmap, &myxcol) )
  {
  mColors[index] = myxcol.pixel;
//  printf("PIColorMapX::AllocColor()  RGB= %d %d %d \n",
//         (int) col.red, (int) col.blue, (int) col.green);
  }
else  
  printf("PIColorMapX::AllocColor() Error: Pb Allocation RGB= %d %d %d \n",
         (int) col.red, (int) col.blue, (int) col.green);
return;
}

/* --Methode-- 
void PIColorMapX::MakeColMap()
{
}
*/

/* --Methode-- */
void PIColorMapX::FreeColors()
{
if (!xinicmap)  
  {
  defxcmap = XDefaultColormap (PIXDisplay(), PIXScreen());
  xinicmap = 1;
  }

XFreeColors(PIXDisplay(), defxcmap, mColors,  mNCol, 0);

for (int i=0; i<mNCol; i++)  
  mColors[i] = BlackPixel(PIXDisplay(), PIXScreen());

printf("PIColorMapX::FreeColors()  Type= %d mNCol= %d \n",
       Type(), NCol());

}

/* --Methode-- */
void PIColorMapX::CopyFrom(PIColorMapGen* x)
{
  CopyFromGen(x);
  for (int i=0; i<mNCol; i++)  mColors[i] = ((PIColorMapX *)x)->mColors[i];
}
