// Affichage d'image            R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
//                        Refonte   Reza   10/95


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "piimage.h"

#include "imageop.h"


/* --Methode-- */
PIImage::PIImage(PIContainerGen *par, char *nom, RzImage *pim,
   int sx, int sy, int px, int py) :
  PIPixmap(par, nom, sx, sy, px, py)
{

img = NULL;
zow = NULL; 
txw = NULL;
zpixm = pixm = NULL;
xszpxm = xspxm = 0;
yszpxm = yspxm = 0;
lut = NULL; 
offx = offy = 0;
xpav = ypav = 0;
zoom = 1;

SetColMap(CMAP_COLRJ32);
SetImage(pim);

ActivateButton(1);
ActivateButton(2);
//ActivateMove(1);

}

/* --Methode-- */
PIImage::~PIImage()
{
if (pixm) delete pixm;
if (zpixm) delete zpixm;
if (lut) delete lut;
}

/* --Methode-- */
void PIImage::SetImage(RzImage *pim)
{
int xwsz, ywsz;

img = pim;
if (img)
  {
  SetSize(img->XSize(), img->YSize());
  xwsz = XSize();  ywsz = YSize();
  if (xwsz > img->XSize()) xwsz = img->XSize();
  if (ywsz > img->YSize()) ywsz = img->YSize();
  xpav = xwsz/2; 
  ypav = ywsz/2;
  if (img->minPix>img->maxPix) img->CheckDyn();
  SetLut(img->minPix, img->maxPix, kLutType_Lin, 2);
  }
//printf("Debug_SetImage: %ld %ld \n", (long)img, (long)lut);
return;
}


/* --Methode-- */
void PIImage::SetZoomWin(PIPixmap * zw) 
{
zow = zw;
if (zow)  zow->SetColMap(GetColMapId());
}



/* --Methode-- */
void PIImage::SetLut(float min, float max, int typlut, int lauto)
{
if (lut) delete(lut);
if (lauto)
  {
  float fracnul, fracsat;
  float fnd, sigfnd;

  int npix = img->XSize()*img->YSize();
  int vitesse=npix/20000;
  vitesse = (vitesse < 1) ? 1 : ((vitesse > 10) ? 10 : vitesse );
  int nbsig = lauto;  
  float fracmax = 0.95;
  float minpix = min;  
  float maxpix = max;  

  RzFondSig2Ciel(img, vitesse, fracmax, nbsig, 500, &minpix, &maxpix, 
                 &fnd, &sigfnd, &min, &max, &fracnul, &fracsat);
  }

lut = new LUT(min, max, NbCol(), typlut);

return;
}


/* --Methode-- */
void PIImage::SetLut(LUT *clut)
{
LUT * olut = lut;
lut = new LUT(clut->Min(), clut->Max(), NbCol(), clut->Type());
if (olut) delete olut;
return;
}


/* --Methode-- */
void PIImage::SetZoom(int zm)
{
if ((zm == 0) || (zm == -1) )  zoom = 1;
else if (zm > 10)  zoom = 10;
else if (zm < -10) zoom = -10;
else zoom = zm;
return;
}
/* --Methode-- */
void PIImage::SelectColor(CMapId cmap)
{
SetColMap(cmap);
if (zow)  zow->SetColMap(cmap);
return;
}


/* --Methode-- */
void PIImage::Apply()
{
ComputePixmap();
Refresh();
if (zow == NULL)  return;
ComputeZoomPixmap();
zow->Refresh();
return;
}

/* --Methode-- */
void PIImage::Resize()
{
printf("PIImage::Resize\n");
ComputePixmap();
return;
}

/* --Methode-- */
void PIImage::But1Press(int x, int y)
{
int xp, yp;

if (img == NULL)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
xpav = xp;  ypav = yp; 
if (zow)
  {
  ComputeZoomPixmap();
  zow->Refresh();
  }
if (txw)
  {
  char buff[256];
  sprintf(buff,"Image %s : X= %d , Y= %d  PixVal= %g ", 
          img->name, xpav, ypav, img->FValue(xpav, ypav));
  txw->SetLabel(buff);
  }
return;
}


/* --Methode-- */
void PIImage::But2Press(int x, int y)
{
int xp, yp;
int xwsz, ywsz;

if (img == NULL)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
xpav = xp;  ypav = yp; 

xwsz = XSize();
ywsz = YSize();
if (zoom > 0)
  {
  offx = xpav-(xwsz/2/zoom);
  offy = ypav-(ywsz/2/zoom);
  }
else 
  {
  offx = xpav+(xwsz*zoom/2);
  offy = ypav+(ywsz*zoom/2);
  }
if (offx < 0)  offx = 0;
if (offy < 0)  offy = 0;
if (offx >= img->XSize())  offx = img->XSize();
if (offy >= img->YSize())  offy = img->YSize();

ComputePixmap();
Refresh();
if (zow)
  {
  ComputeZoomPixmap();
  zow->Refresh();
  }
return;
}

/* --Methode-- */
unsigned char *  PIImage::ComputePixmap(int ofx, int ofy, int zm, 
                           int xwsz, int ywsz, unsigned char * opix, 
                           int * oxsp, int * oysp)
{
unsigned char *pix, *pp, ucp;
int zmm;
int npx, npy, nppx, nppy, nszp, oszp;
int i,j,k,l;
float vpx;


if ( (img == NULL) || (lut == NULL) ) 
  { printf("PIImage::ComputePixmap:Pb img ou lut %ld %ld \n", 
            (long)img, (long)lut);
  *oxsp = *oysp = 0; return(NULL); }

npx = img->XSize()-ofx;
npy = img->YSize()-ofy;

if ((zm == 0) || (zm == -1))  zm = 1;

if (zm >= 1)
  {
  if ((npx*zm) > xwsz)  npx = xwsz/zm; 
  if ((npy*zm) > ywsz)  npy = ywsz/zm;
  nppx = npx*zm;   nppy = npy*zm;
  }
if (zm < -1)
  {
  zmm = -zm;
  if ((npx/zmm) > xwsz)  npx = xwsz*zmm; 
  if ((npy/zmm) > ywsz)  npy = ywsz*zmm; 
  nppx = npx/zmm;   nppy = npy/zmm;
  }

oszp = (*oxsp)*(*oysp);
nszp = nppx*nppy;
if ( oszp != nszp )
  {
  if (opix)  delete opix;
  pix = new unsigned char[nppx*nppy];
  if (pix == NULL)  { *oxsp = *oysp = 0; ; return(NULL); }
  }
else  pix = opix;
*oxsp = nppx; *oysp = nppy;

printf("Debug_ComputePixmap %d %d %d (%d-%d %d-%d)\n", 
      ofx, ofy, zm, npx,nppx, npy,nppy);

pp = pix;
if (zm == 1)    // Pas de zoom  
  {
  for(j=ofy; j<ofy+npy; j++)
    for(i=ofx; i<ofx+npx; i++) 
      { *pp = (unsigned char) lut->Apply(img->FValue(i,j));  pp++; }
  }
else if (zm < -1)        // Compression 
  {
  float fv = (float)(zmm*zmm); 
  for(j=ofy; j<ofy+npy; j+=zmm)
    for(i=ofx; i<ofx+npx; i+=zmm)
      {
      vpx = 0;
      for(l=0; l<zmm; l++)
        for(k=0; k<zmm; k++)
          vpx += img->FValue(i+k, j+l);
      *pp = (unsigned char) lut->Apply(vpx/fv); 
      pp++;
      }
  }
else      // Agrandissement
  {
  for(j=ofy; j<ofy+npy; j++)
    for(i=ofx; i<ofx+npx; i++)
      {
      ucp = (unsigned char) lut->Apply(img->FValue(i,j));
      for(l=0; l<zm; l++)
        {
        pp = pix+((j-ofy)*zm+l)*nppx+((i-ofx)*zm);
        for(k=0; k<zm; k++)  { *pp = ucp; pp++; }  
	}
      }
  }

return(pix);
}

/* --Methode-- */
void PIImage::ComputePixmap()
{
unsigned int xwsz, ywsz;

if (img == NULL)  return;
xwsz = this->XSize();
ywsz = this->YSize();

pixm = ComputePixmap(offx, offy, zoom, xwsz, ywsz, pixm, &xspxm, &yspxm);
SetPixmap(pixm, xspxm, yspxm); 
return; 
}


/* --Methode-- */
void PIImage::ComputeZoomPixmap()
{
unsigned int xwsz, ywsz;
int ofx, ofy;
int zm;

if (zow == NULL)  return;
if (img == NULL)  return;

xwsz = zow->XSize();
ywsz = zow->YSize();

zm = zoom+4;
if ( (zm==-1) || (zm == 0) ) zm = 1;
if (zm > 0)
  {
  ofx = xpav-(xwsz/2/zm);
  ofy = ypav-(ywsz/2/zm);
  }
else 
  {
  ofx = xpav+(xwsz*zm/2);
  ofy = ypav+(ywsz*zm/2);
  }

zpixm = ComputePixmap(ofx, ofy, zm, xwsz, ywsz, zpixm, &xszpxm, &yszpxm);
zow->SetPixmap(zpixm, xszpxm, yszpxm); 
zow->SetUserData((void *)this, 0);
return; 

}


/* --Methode-- */
int PIImage::PosW2Img(int xiw, int yiw, int * xp, int * yp)
{

if (zoom > 0)
  {
  *xp = xiw/zoom+offx;
  *yp = yiw/zoom+offy;
  }
else
  {
  *xp = offx-xiw*zoom;
  *yp = offy-yiw*zoom;
  }

if ( (*xp >= 0) && (*xp < img->XSize() ) &&
     (*yp >= 0) && (*yp < img->YSize() )  )   return(0);
else return(1);
}



