#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "pipixmapx.h"

static  GC    mygc;

/* --Methode-- */
PIPixmapX::PIPixmapX(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PIPixmapGen(par,nom,sx,sy,px,py) 
{
Init();
}


/* --Methode-- */
PIPixmapX::~PIPixmapX()
{}



/* --Methode-- */
void PIPixmapX::Draw()
{
// EraseWindow();
Draw(0,0,XSize(),YSize());
}

/* --Methode-- */
void PIPixmapX::Draw(int x0, int y0, int dx, int dy)
{
int depth;
XImage * ximg;
Window xw;
Display * mdsp;
int scr;

int i,j;
unsigned char *pp;


if ((pixmap == NULL) || (cmap == NULL)) return;

xw = XtWindow(XtWdg());
mdsp = PIXDisplay();
scr = PIXScreen();

if (x0 < 0)  x0 = 0;
if (y0 < 0)  y0 = 0;

if (dx > (nx-x0)) dx = nx-x0;
if (dy > (ny-y0)) dy = ny-y0;
if ((dx <= 0) || (dy <= 0))  return;

depth = DefaultDepth(mdsp,scr);
ximg = XCreateImage (mdsp,DefaultVisual(mdsp,scr),
       depth,ZPixmap,0,NULL,dx,dy,8,0);
if (ximg == NULL)  return;
ximg->data = new char [dy*ximg->bytes_per_line];
if (ximg->data == NULL)  { XFree(ximg); return; }

for(j=0; j<dy; j++)
  {
  pp = pixmap+(j+y0)*nx+x0;
  for(i=0; i<dx; i++)
    { XPutPixel(ximg, i, j, cmap->Color(*pp) );  pp++; }
  }
XPutImage(mdsp, xw, mygc, ximg, 0,0, x0, y0, nx, ny);
XSync(mdsp, 0);

delete ximg->data;
XFree(ximg);
return;
 
}

static bool fgxpxm = false;


/* --Methode-- */
void PIPixmapX::Init()
{
XGCValues       values;
XtGCMask        mask;
Display *mdsp;
int scr;

if (fgxpxm)  return; 
fgxpxm = true;

mdsp = XtDisplay(XtWdg());
scr = XDefaultScreen(mdsp);

mask = GCFunction | GCPlaneMask;
// mask = GCForeground | GCBackground;
values.function = GXcopy;
values.plane_mask = ~0;
// values.foreground = WhitePixel(mdsp, scr);
// values.background = BlackPixel(mdsp, scr);
mygc = XtGetGC(XtWdg(), mask, &values);

return;
}
