// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIScDrawWdg 
// Gestionnaire Drawer-2D  E.Aubourg, R. Ansari  96-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PISCDRAWWDG_H
#define PISCDRAWWDG_H

#include "pisysdep.h"
#include PIBWDG_H
#include PISTDWDG_H
#include PIWIN_H
#include "pidrawer.h"
#include "pieldrw.h"


// PIScDrawWdg, Gestionnaire de traceur 2D 

class PIScDrawWdg : public PIBaseWdg {
public:
  enum {ClassId = 5300};

                     PIScDrawWdg(PIContainerGen *par, const char *nom,
                                   int sx=100, int sy=100, int px=0, int py=0);
  virtual            ~PIScDrawWdg();

  virtual long       kind() {return ClassId; }
  
  virtual void       SetLimits(double xmin, double xmax, double ymin, double ymax, 
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame, bool tmp=false);
  inline  void	     SetLogScale(bool logx, bool logy)	
                           { SetDefaultDrawerLogScale(logx, logy); }
  inline  bool       isLogScaleX() { return(mDXlog); }
  inline  bool       isLogScaleY() { return(mDYlog); }

  virtual void	     UpdateLimits();  // Calcule et change les limites a partir de Drawer-No-1 

  virtual void       SetAxesFlags(unsigned int flags=kBoxAxes | kExtTicks | kLabels);

  inline void	     SetTitles(const char* tt=NULL, const char* tb=NULL)
                            { mBDrw->SetTitles(tt, tb); }
  inline void	     SetTitles(string const & tt, string const & tb)
                            { mBDrw->SetTitles(tt, tb); }

//   Methode permettant de decoder des options a partir de chaines
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

// Ajoute un Drawer en auto 
  int                AddScDrawer(PIDrawer*, bool ad=false);   

  inline PIElDrawer* BaseDrawer() { return mBDrw; };

// Configuration et limites des axes 
  inline unsigned int GetAxesFlags() { return(mBDrw->GetAxesFlags()); }
  inline void         GetAxesConfig(int& xa, int& ya) { mBDrw->GetAxesConfig(xa, ya); }

  inline double XMin() const {return mBDrw->XMin();}
  inline double XMax() const {return mBDrw->XMax();}
  inline double YMin() const {return mBDrw->YMin();}
  inline double YMax() const {return mBDrw->YMax();}

  inline double XPPos() const { return mPPos[0]; }
  inline double YPPos() const { return mPPos[1]; }

  int    LimitsFixed() const {return mBDrw->LimitsFixed();}
  void   FreeLimits() { mBDrw->FreeLimits(); }
    

  virtual void       GetClickText(string& info, double x, double y); // Donne le texte a afficher pour position x,y
  virtual void	     ActivateSpecializedControls();   // Pour activer des controles specifiques

  virtual void       UpdateInfoWindow();    // Affiche et met a jour la fenetre info texte
                                            // concernant le petit pave autour de la pos. courante 

  void               SetTextWin(PILabel * tw, bool trw=true, int tx=600, int ty=30);

  virtual void       But1Press(int x, int y);
  virtual void       But1Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);

  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       Ptr3Move(int x, int y);

  virtual void       Keyboard(int key, PIKeyModifier kmod);
  virtual void       PasteSelection(unsigned int typ, void *pdata, unsigned int l);

  static  string     SetFormatOpt(double xmin,double xmax);
  
protected:
  double xMinS, xMaxS, yMinS, yMaxS; // Sauvegarde pour zoom
  double mPPos[2];        // Position courante (user coordinates)
  double mPSz[2];         // Taille courant du pave info 
  int mCPosX, mCPosY;     // Position click souris X,Y (pour trace de reticule)
  bool mFgDeltaPos;       // affichage de l'ecart par rapport a la position memorisee
  double mPosForDelta[2];     // Position memorisee - Pour affichage d'ecart
  int mPosFDX, mPosFDY;       // Position (coord fenetre memorise)
  bool mFgReticule;       // Controle l'affiche d'une rticule (Bouton-1)
  string mFormatOpt[2];   // Format optimal d'impression des textes

  PIElDrawer* mBDrw;
  
  int xBegDrag, yBegDrag;
  int xEndDrag, yEndDrag;
  PIColors cForCol;
  PIGOMode cGOmod;  
  PIPointer cPointer;
  PILineAtt cLatt;
  PILabel * mTxw;  
  PILabel * mTrlb;
  PIWindow * mTrW;

// Fenetre pour l'affichage des informations 
  PIWindow * mInfoW;
  PIText * mInfoTxt;

private:
  void  UpdateText(int xp, int yp);
  void  UpdatePosForDeltaMarker(bool fg, bool fgupd=false);
  void  DrawReticule(int x, int y, int op);
  void  DrawDeltaPosMarker();
};



#endif
