// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: simofftst.cc,v 1.3 2002-05-28 17:30:45 ansari Exp $

/*   Test de processeurs ds simtoipr.cc   - Reza Avril 2001

----------------   Exemple d'appel  ---------------------
csh> simofftst -start 104385384 -end 104399964 -range -500,500 \
            -intoi boloMuV_26 -wtoi 8192 -wdegli 1024 \
	    inputbolo.fits filt.fits xx.ppf
# Avec Filtre 
csh> simofftst -start 104385384 -end 104399964 -range -500,500 \
            -intoi boloMuV_26 -wtoi 8192 -wdegli 1024 \
	    inputbolo.fits filtfft.fits spectre.ppf
csh> $exedir/simofftst -start $sn0 -end $sn1  -intoi $cleanname \
            -wtoi 8192 -wdegli 1024 -degli 3.,2.,3,2,0 \
            -soff 128,9,3 -gfilt 16,2.5 -prstat \
            -soffnt $outppf -bgalcut -20.,20. -bgal $glat \
            -bgalfile $point $cleanfile $outfile

*/



#include "machdefs.h"
#include <math.h>
#include <unistd.h>

#include "toimanager.h"
#include "cgt.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "simtoipr.h"
#include "simoffset.h"
#include "nooppr.h"
#include "timing.h"
#include "histinit.h"
#include "psighand.h"
#include <stdexcept>

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " simofftst : Argument Error ! simofftst -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : simofftst [-intoi toiname] [-start snb] [-end sne] \n" 
	 << "         [-dbg] [-wtoi sz] [-wdegli sz] [-range min,max] \n"
	 << "         [-degli ns,ns2,mxpt,mnpt,wrec] [-soff wsz,nptfit,degpol] \n"
	 << "         [-soffnt PPFName] [-gfilt wsz,sigma] \n"
	 << "         [-bgalcut bmin,bmax] [-bgal toiname] [-bgalfile pointFitsName] \n"
	 << "         [-nooutflg] [-nowrtms] [-nowrticd] [-prstat] [-useseqbuff] \n"
	 << "         inFitsName outFitsName \n" 
	 << "   -dbg : sets TOISeqBuffered debug level to 1 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -range min,max : sets the acceptable range for intoi \n"
	 << "              default= -16000,16000\n"
	 << "   -intoi toiName : select input TOI name (def bolo)\n"
	 << "   -wtoi sz : sets TOISeqBuff buffer size (def= 8192)\n"
	 << "   -wdegli sz : sets deglitcher window size (def= 512) \n"
	 << "   -degli ns,ns2,maxnpt,minnpt,wrec : sets deglitcher parameters\n"
	 << "   -soff wsz,nptfit,degpol : set SimpleOffsetEstimator parameters\n"
	 << "   -soffnt PPFName : Writes out SimpleOffsetEstimator NTuple \n"
	 << "   -gfilt wsz,sigma : Activate gaussian filter (par= window size, sigma) \n"
      //	 << "   -wfft sz : Activate Fourier filter and sets its width \n"
      //	 << "   -keepfft n : Keeps n spectra (if Fourier filter activated) \n" 
      //	 << "   -killfreq bf,nharm,sigf : kills nharm frequency, basefreq=bf \n"
      //         << "              with a gaussian with width=sigf \n"
	 << "   -nooutflg : Don't write flags to output FITS \n"
	 << "   -wrtms : Write mean/sigma TOI's from Deglitcher \n"
	 << "   -wrticd : Write incopie,degli  TOI's from deglitcher \n"
	 << "   -prstat : PrintStat with ProcSampleCounter \n"
	 << "   -useseqbuff : Use TOISeqBuffered TOI's (default: TOISegmented) \n"
	 << endl;
  }
  if (fgerr) exit(1);
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "simofftst starting - Decoding arguments " << " narg=" << narg << endl;

  bool fgdbg = false;
  bool fgsetstart = false;

  bool fgprstat = false;
  bool fgsegmented = true;

  int dbglev = 0;

  int wtoi = 8192;
  int wdegli = 512;
  
  int wfft = 4096;
  int keepfft = 0;
  int nmax = 10;
  int istart = 0;
  int iend = 0;

  double range_min = -16000;
  double range_max = 16000.;

  // Deglitcher parameters
  double degli_ns1 = 3.;
  double degli_ns2 = 1.5;
  int degli_minnpt = 2;
  int degli_maxnpt = 4;
  int degli_wrec = 10;

  // SimpleOffsetEstimator parameters
  int soff_mwsz = 256;
  int soff_nptfit = 5;
  int soff_degpol = 2;
  bool soff_nt = false;
  string soff_nt_ppfname = "";

  // Gaussian filter parameters
  bool gfilt_fg = false;
  int gfilt_wsz = 16;
  double gfilt_sigma = 2.;

  // Coordinate file for galactic cut
  string pointfile = "pointgal.fits";
  double bmin = -20;
  double bmax = 20.;
  string bgaltoi = "bgal";
  bool bgalcut = false;

  // File names 
  string infile;
  string outfile;
  string outppfname;
  string intoi = "bolo";

  bool fg_wrtflag = true;
  bool fg_wrtms = false;
  bool fg_wrticd = false;


  bool fg_f_filt = false;
  bool fg_killfreq = false;
  int bf_killfreq = 1;
  int nharm_killfreq = 1;
  double sigf_killfreq = 1.;

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wdegli") == 0) {
      if (ia == narg-1) Usage(true);  
      wdegli = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-degli") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%lf,%lf,%d,%d,%d",  &degli_ns1, &degli_ns2,
             &degli_maxnpt, &degli_minnpt, &degli_wrec);
      ia++;
    }    
    else if (strcmp(arg[ia],"-soff") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%d,%d,%d",  &soff_mwsz, &soff_nptfit, &soff_degpol);
      ia++;
    }
    else if (strcmp(arg[ia],"-soffnt") == 0) { 
      soff_nt = true;
      soff_nt_ppfname = arg[ia+1];  ia++;
    }
    else if (strcmp(arg[ia],"-gfilt") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%d,%lf", &gfilt_wsz, &gfilt_sigma);
      gfilt_fg = true;
      ia++;
    }    
    else if (strcmp(arg[ia],"-bgalcut") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%lf,%lf", &bmin, &bmax);
      bgalcut = true;
      ia++;
    }
    else if (strcmp(arg[ia],"-bgalfile") == 0) {
      if (ia == narg-1) Usage(true);
      pointfile = arg[ia+1];
      ia++;
    }
    else if (strcmp(arg[ia],"-bgal") == 0) {
      if (ia == narg-1) Usage(true);
      bgaltoi = arg[ia+1];
      ia++;
    }
    else if (strcmp(arg[ia],"-wfft") == 0) {
      if (ia == narg-1) Usage(true);  
      wfft = atoi(arg[ia+1]); ia++;
      fg_f_filt = true;
    }    
    else if (strcmp(arg[ia],"-keepfft") == 0) {
      if (ia == narg-1) Usage(true);  
      keepfft = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-killfreq") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%d,%d,%lf",&bf_killfreq, &nharm_killfreq, &sigf_killfreq);
      fg_killfreq = true;
      ia++;
    }    
    else if (strcmp(arg[ia],"-range") == 0) {
      if (ia == narg-1) Usage(true);
      sscanf(arg[ia+1],"%lf,%lf",&range_min, &range_max);
      ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0)  fgdbg = true;
    else if (strcmp(arg[ia],"-nooutflg") == 0)  fg_wrtflag = false;
    else if (strcmp(arg[ia],"-wrtms") == 0)  fg_wrtms = true;
    else if (strcmp(arg[ia],"-wrticd") == 0)  fg_wrticd = true;

    else if (strcmp(arg[ia],"-prstat") == 0)  fgprstat = true;
    else if (strcmp(arg[ia],"-useseqbuff") == 0)  fgsegmented = false;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*(nmax+5);
  if ((narg-ko) < 2)  Usage(true); 
  infile = arg[ko];
  outfile = arg[ko+1];
  //  outppfname = arg[ko+2];

  cout << " Initializing SOPHYA ... " << endl;
  SophyaInit();
  SophyaConfigureSignalhandling(true);

  InitTim();

  cout << ">>>> simofftst: Infile= " << infile << " outFile=" 
       << outfile << endl; 
  cout << ">>>> Window Size WTOI= " << wtoi << " WDEGLI= " << wdegli
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;

  try {
    TOIManager* mgr = TOIManager::getManager();
  
    //  mgr->setRequestedSample(11680920,11710584);
    //  mgr->setRequestedSample(104121000, 104946120);
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);

    cout << "> Creating FITSTOIReader object - InFile=" << infile << endl;
    FITSTOIReader r(infile); 

    cout << "> Creating SimpleDeglitcher() " << endl;
    SimpleDeglitcher degl(wdegli);
    degl.SetDetectionParam(degli_ns1, degli_ns2, degli_maxnpt,
                           degli_minnpt, degli_wrec);
    cout << " Setting Range for deglitcher: " << range_min 
	 << " - " << range_max << endl;
    degl.SetRange(range_min, range_max);

    cout << "> Creating SimpleDeglitcher(" << soff_mwsz << "," << soff_nptfit 
	 << "," << soff_degpol << ")" << endl;
    SimpleOffsetEstimator offes(soff_mwsz, soff_nptfit, soff_degpol);
    offes.SavePolyNTuple(soff_nt, soff_nt_ppfname);

    if (gfilt_fg) 
      cout << "> Creating a GaussianFilter SimpleFilter Object " << endl;
    double G_sigma = gfilt_sigma;
    double G_a = 1./(G_sigma*sqrt(M_PI*2.));
    SimpleFilter filt(gfilt_wsz, SimpleFilter::GaussFilter, G_a, G_sigma);

         
    FITSTOIReader* rbgal = NULL;
    if (bgalcut) {  // if Galactic cut 
      cout << "> Creating bgal FITSTOIReader object - InFile=" << pointfile 
	   << " bgaltoiname= " << bgaltoi << endl;
      cout << "  offes.SetBGalCut( " << bmin << "," << bmax << ")" << endl;
      rbgal = new FITSTOIReader(pointfile); 
      offes.SetBGalCut(bmin, bmax);      
    }

    cout << "> Creating FITSTOIWriter OutFitsName= " << outfile << endl;
    FITSTOIWriter w(outfile);

    CGT plombier(fgsegmented, wtoi);
    plombier.SetDebugLevel(dbglev);

    cout << "> Connecting Processors through plombier ... " << endl;
    string inname = "in";
    plombier.Connect(r, intoi, degl, inname);
    plombier.Connect(degl, "out", offes, "in");
    if (gfilt_fg) {
      plombier.Connect(offes, "out", filt, "in");
      plombier.Connect(filt, "out", w, "degoffil", "", 0, fg_wrtflag);
    }
    else 
      plombier.Connect(offes, "out", w, "degoff", "", 0, fg_wrtflag);
      
    if (bgalcut) {
      inname = "bgal";
      plombier.Connect(*rbgal, bgaltoi, offes, inname);      
    }

    if (fg_wrticd) {
      plombier.Connect(degl, "incopie", w, "incopie");
      plombier.Connect(offes, "incopie", w, "indegl");
    }
    if (fg_wrtms) {
      plombier.Connect(degl, "mean", w, "meandegl");
      plombier.Connect(degl, "sigma", w, "sigdegl");
    }

    cout << "> Plombier status before start" << endl;
    cout << plombier ; 

    cout << offes;

    PrtTim("starting processors");
    plombier.Start();


    // ------------------- Impression continu de stat ------------------------ 
    if (fgprstat) {
      ProcSampleCounter<SimpleOffsetEstimator> stats(offes);
      stats.InfoMessage() = "simofftst/Info";
      stats.PrintStats();
    }
    // -----------------------------------------------------------------------

    cout << degl;
    cout << offes;
    if (gfilt_fg)  cout << filt;
    cout << w;

    mgr->joinAll();
    PrtTim("End threads");
    if (bgalcut)  delete rbgal;

  }
  catch (PThrowable & exc) {
    cerr << "\n simofftst: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n simofftst: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n simofftst: some other exception was caught ! " << endl;
  }

  return(0);
}
