// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari

#ifndef SIMOFFSET_H
#define SIMOFFSET_H

#include "toiprocessor.h"
#include "tvector.h"
#include "poly.h"

// ---- Calcul de ligne de base 
//      Ajustement polynomial sur des echantillons moyennes
//
// Structure generale :
// 
//               -------------------------
//    toi in --> |                       | ---> out  (toi = in_offset)
//               | SimpleOffsetEstimator | ---> offset (toi) 
//  bgal(opt)--> |                       | ---> Autres toi optionnel
//               |                       |
//               -------------------------

class SimpleOffsetEstimator : public TOIProcessor {
public:
           SimpleOffsetEstimator(int mwsz=256, int nptfit=5, int degpol=2);
  virtual  ~SimpleOffsetEstimator();

  void     SetParams(int mwsz=256, int nptfit=5, int degpol=2);
  virtual void	init();  
  virtual void	run();

  virtual void  SetBGalCut(double bmin, double bmax);

  inline int_8	ProcessedSampleCount() const { return totnscount; }

  virtual void  PrintStatus(::ostream & os) ; // const plus tard

  inline  void  SavePolyNTuple(bool fg=false, string name="") { ntpoly = fg; ntpolyname=name; }
protected:
  int_8 totnscount;   // Nombre total d'echantillon processe
  int_8 totnbblock;   // Nombre total de blocs 
  int mWSz;
  int nPtFit;
  int degPol;
  Poly poly;
  bool ntpoly;
  string ntpolyname;
  double bmincut, bmaxcut;
  bool bgalcut;
  int_4 ns_flgcut;
  int_4 ns_bgalcut;
};

#endif
