// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: nooppr.h,v 1.7 2002-05-30 20:44:31 ansari Exp $


#ifndef NOOPPR_H
#define NOOPPR_H

#include "toiprocessor.h"

//  Un processeur qui ne fait rien !
//   Au mieux, copie son entree sur la sortie - peut avoir 2 entrees
//  Peut introduire un delai de wsize

class NoOpProcessor : public TOIProcessor {
public:
                NoOpProcessor(int wsz=0);  
  //		~NoOpProcessor();

  inline int	WSize() const { return wsize; }
  inline void	SetWSize(int wsz)  { if (wsz > 1)  wsize =  wsz; }
  inline int_8	ProcessedSampleCount() const { return totnscount; }

  inline void   AcceptNoInput(double val=0., long flg=0)
         { acceptnoinput = true; defval = val; defflag = flg; }

  virtual void  PrintStatus(::ostream & os) ; // const plus tard

  virtual void	init();  
  virtual void	run();

protected:
  int_8 totnscount;   // Nombre total d'echantillon processe
  int wsize;         // Taille de fenetre de travail

  bool acceptnoinput;
  double defval;
  long defflag;
};

#endif
