// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: mesovh2.cc,v 1.3 2002-05-30 20:44:31 ansari Exp $
/*   mesure de performance de l'architecture

----------------   Exemple d'appel  ---------------------
csh> mesovh2 -start 104385384 -end 104399964 
            -intoi boloMuV_27 -wtoi 8192 -wnoop 4096 inputbolo.fits 
*/



#include "machdefs.h"
#include <math.h>
#include <unistd.h>
#include "cgt.h"
#include "fitstoirdr.h"
#include "toimanager.h"
#include "nooppr.h"
#include "timing.h"
#include <stdexcept>

void Usage(bool fgerr)
{
  cout << endl;
  if (fgerr) {
    cout << " mesovh2 : Argument Error ! mesovh2 -h for usage " << endl; 
    exit(1);
  }
  else {
    cout << "\n Usage : mesovh2 [-dbg] [-start snb] [-end sne] \n" 
	 << "         [-intoi name] [-wtoi sz] [-wnoop sz] \n"
	 << "         [-bipro sz2] [-tripro sz2,sz3] [-quadpro sz2,sz3,sz4] \n"
	 << "         [-pentapro sz2,sz3,sz4,sz5] [-hexapro sz2,sz3,sz4,sz5,sz6] \n"
         << "         [-intoi2 name] [-prstat] [-useseqbuff] inFitsName \n"
	 << "   -dbg : sets CGT class debug level to 1 \n"
	 << "   -dbg2 : sets CGT class debug level to 2 \n"
	 << "   -start snb : sets the start sample num \n"
	 << "   -end sne : sets the end sample num \n"
	 << "   -intoi toiName : select input TOI name (def bolo)\n"
	 << "   -wtoi sz : sets TOISeqBuff/TOISegmented buffer size (def= 1024)\n"
	 << "   -wnoop sz : sets NoOpProcessor window size \n"
	 << "   -bipro sz2: chain 2 processors sz2= NoOpProcessor 2 window size\n"
	 << "   -tripro -quadpro -pentapro -hexapro ... chain 3-6 processors \n"
	 << "   -intoi2 toiName : chaine 2 procs with toi2->in2\n"
	 << "   -prstat : PrintStat with ProcSampleCounter \n"
	 << "   -useseqbuff : Use TOISeqBuffered TOI's (default: TOISegmented) \n"
	 << endl;
    exit(0);
  }
}

int main(int narg, char** arg) {

  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) Usage(false);

  cout << "mesovh2 starting - Decoding arguments " << " narg=" << narg << endl;

  // --------- Decoding command line parameters
  int  nb_procs = 1;
  int  proc_wsz[6] = {0,0,0,0,0,0};
  bool fgsetstart = false;
  bool fgprstat = false;
  bool fgsegmented = true;
  int dbglev = 0;
  int wtoi = 1024;
  int wnoop = 0;
  int keepfft = 0;
  int nmax = 10;
  int istart = 0;
  int iend = 0;
  string infile;
  string intoi = "bolo";
  bool fgtoi2 = false;
  string intoi2;

  if (narg < 4) Usage(true);
  int ko=1;
  // decoding arguments 
  for(int ia=1; ia<narg; ia++) {
    if (strcmp(arg[ia],"-start") == 0) {
      if (ia == narg-1) Usage(true);  // -start est suivi d'un argument 
      istart = atoi(arg[ia+1]); ia++;
      fgsetstart = true;
    }    
    else if (strcmp(arg[ia],"-end") == 0) {
      if (ia == narg-1) Usage(true);  
      iend = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wtoi") == 0) {
      if (ia == narg-1) Usage(true);  
      wtoi = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-wnoop") == 0) {
      if (ia == narg-1) Usage(true);  
      wnoop = atoi(arg[ia+1]); ia++;
    }    
    else if (strcmp(arg[ia],"-bipro") == 0) {
      if (ia == narg-1) Usage(true);  
      nb_procs = 2;
      sscanf(arg[ia+1],"%d",proc_wsz+1); ia++;
    }    
    else if (strcmp(arg[ia],"-tripro") == 0) {
      if (ia == narg-1) Usage(true);  
      nb_procs = 3;
      sscanf(arg[ia+1],"%d,%d",proc_wsz+1,proc_wsz+2 ); ia++;
    }    
    else if (strcmp(arg[ia],"-quadpro") == 0) {
      if (ia == narg-1) Usage(true);  
      nb_procs = 4;
      sscanf(arg[ia+1],"%d,%d,%d",proc_wsz+1,proc_wsz+2,proc_wsz+3 ); ia++;
    }    
    else if (strcmp(arg[ia],"-pentapro") == 0) {
      if (ia == narg-1) Usage(true);  
      nb_procs = 5;
      sscanf(arg[ia+1],"%d,%d,%d,%d",proc_wsz+1,proc_wsz+2,
	     proc_wsz+3,proc_wsz+4); ia++;
    }    
    else if (strcmp(arg[ia],"-pentapro") == 0) {
      if (ia == narg-1) Usage(true);  
      nb_procs = 6;
      sscanf(arg[ia+1],"%d,%d,%d,%d,%d",proc_wsz+1,proc_wsz+2,
	     proc_wsz+3,proc_wsz+4,proc_wsz+5 ); ia++;
    }    
    else if (strcmp(arg[ia],"-intoi") == 0) {
      if (ia == narg-1) Usage(true);  
      intoi = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-intoi2") == 0) {
      if (ia == narg-1) Usage(true);
      fgtoi2 = true;
      intoi2 = arg[ia+1]; ia++;
    }    
    else if (strcmp(arg[ia],"-dbg") == 0)  dbglev = 1;
    else if (strcmp(arg[ia],"-dbg2") == 0)  dbglev = 2;
    else if (strcmp(arg[ia],"-prstat") == 0)  fgprstat = true;
    else if (strcmp(arg[ia],"-useseqbuff") == 0)  fgsegmented = false;

    else { ko = ia; break; }  // Debut des noms
  }

  if (iend < istart) iend = istart+wtoi*(nmax+5);
  if ((narg-ko) < 1)  Usage(true); 
  infile = arg[ko];

  InitTim();

  cout << ">>>> mesovh2: Infile= " << infile << " outFile=" << endl;
  cout << ">>>> Window Size WTOI= " << wtoi << " WNOOP= " << wnoop
       << "  iStart= " << istart << " iEnd= " << iend << endl;
  cout << ">>>> InTOIName= " << intoi << endl;

  try {
    // --------- Setting up the pipe
    TOIManager* mgr = TOIManager::getManager();
    if (fgsetstart) 
      mgr->setRequestedSample(istart, iend);
  
    CGT plombier(fgsegmented, wtoi);
    plombier.SetDebugLevel(dbglev);

    FITSTOIReader r(infile); 
    cout << "> FITSTOIReader reader created File=" << infile << endl;
    proc_wsz[0] = wnoop;
    NoOpProcessor noop[6];
    int k;
    for(k=0; k<nb_procs; k++) {
      noop[k].SetWSize(proc_wsz[k]);
      cout << "> NoOpProcessor noop[" << k << "]  created WSz=" << proc_wsz[k] << endl;
    }
    
    cout << "> Connecting to Processors through plombier ... " << endl;
    string inname = "in";
    plombier.Connect(r, intoi, noop[0], inname);
    
    if (fgtoi2) {
      int w2 = (wnoop > 0) ? wtoi+wnoop : wtoi;
      inname = "in2";
      plombier.Connect(r, intoi2, noop[0], inname, "", w2);
    }
    for(k=1; k<nb_procs; k++) {
      plombier.Connect(noop[k-1], "out", noop[k], "in"); 
      if (fgtoi2) plombier.Connect(noop[k-1], "out2", noop[k], "in2");
    }

    cout << "> Plombier status before start" << endl;
    cout << plombier ; 

    PrtTim("starting processors");
    plombier.Start();
    
    if (fgprstat) {
      // --------------- Impression continu de stat -------------------
      ProcSampleCounter<NoOpProcessor> stats(noop[0]);
      stats.InfoMessage() = "mesovh2/Info";
      stats.PrintStats();
      // --------------------------------------------------------------
    }
    

    mgr->joinAll();
    PrtTim("End threads");

    cout << noop[0] ; 
    if (nb_procs > 1) cout << noop[nb_procs-1] ; 
  }
  catch (PThrowable & exc) {
    cerr << "\n mesovh2: Catched Exception \n" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
  }
  catch (const std::exception & sex) {
    cerr << "\n mesovh2: Catched std::exception \n" 
	 << (string)typeid(sex).name() << endl; 
  }
  catch (...) {
    cerr << "\n mesovh2: some other exception was caught ! " << endl;
  }

  return(0);
}
