//#define TOISEQBUFFERED

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "fitslocalmap.h"
#include "sambainit.h"
#include "toi2map.h"
#include "localmap.h"
#include "timing.h"

#include <stdexcept>

void usage(void);
void usage(void) {
  cout<<"tsttoi2map [-h] [-p lp] [-s samplemin,samplemax] [-c xcenter,ycenter]"<<endl
      <<"          [-l map size (degrees)] [-w data_window_size]"<<endl
     <<"           [-a label_coord1] [-d label_coord2] [-b label_bolomuv]"<<endl
     <<"           [-n nlat] [-i c,h] [-o c,h]"<<endl
     <<"           [-m vmin] [-M vmax] [-f flag]"<<endl
     <<"           fitsin_point fitsin_bolo fitlmapout [fitlmapwout]"<<endl
     <<" -p lp : print level (def=0)"<<endl
     <<" -s samplemin,samplemax : sample range to be treated (def=all)"<<endl
     <<" -c xcenter,ycenter : position of the center (deg)"<<endl
     <<" -l size : size of the map (deg)"<<endl
     <<" -w data_window_size : window size for pipe (def=8192)"<<endl
     <<" -a label_coord1 : label fits for alpha/gLong (def=coord1)"<<endl
     <<" -d label_coord2 : label fits for delta/gLat (def=coord2)"<<endl
     <<"          coord1 = alpha or gLong ; coord2 = delta or gLat"<<endl
     <<" -b label_bolomuv : label fits for bolo value (def=boloMuV)"<<endl
     <<" -n nbin : nbin for the map (def=90)"<<endl
     <<" -i cin : coordIn caracteristics (def=\"gdcdl\")"<<endl
     <<" -o cmap : idem -i for coordMap (def=\"g\")"<<endl
     <<" -e equi : equinoxe en annee (def=2000.)"<<endl
     <<" -m vmin : samples are good if sample value >= vmin"<<endl
     <<" -M vmax : samples are good if sample value <= vmax"<<endl
     <<" -f flag : samples are bad if match flag"<<endl
     <<" -I : sampleNum are implicit in fits files (def=no)"<<endl
     <<" fitsin_point : fits file for pointing"<<endl
     <<" fitsin_bolo : fits file for bolo values"<<endl
     <<" fitlmapout : fits file for output Healpix lmapere"<<endl
     <<" fitlmapwout : fits file for output Healpix nFilled lmapere (def=no)"<<endl;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
int lp = 0, width = 8192;
int nbin = 90;   // npixel = 12 * nbin^2
bool tflg=false, tmin=false, tmax=false;
r_8 vmin=-1.e30, vmax=1.e30; uint_8 badflg=0;
r_8 xcenter=0., ycenter=0., size=7.5;
char *label_coord1 = "coord1", *label_coord2 = "coord2"
   , *label_bolomuv = "boloMuV";
double equi=2000.;
char *tcoorin="gdcdl", *tcoormap="g";
string fitlmapwout = "";
long sdeb,sfin;
bool snimplicit = false;
int c;
while((c = getopt(narg,arg,"hIp:s:c:l:w:a:d:b:n:i:o:m:M:f:e:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    //else {cout<<"Bad sample interval "<<endl; exit(2);}
    break;
  case 'c' :
    sscanf(optarg,"%lf,%lf",&xcenter,&ycenter);
    cout<<"Requested center  "<<xcenter<<" , "<<ycenter<<endl;
    break;
  case 'l' :
    sscanf(optarg,"%lf",&size);
    cout<<"Requested size  "<<size<<endl;
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'a' :
    label_coord1 = optarg;
    break;
  case 'd' :
    label_coord2 = optarg;
    break;
  case 'b' :
    label_bolomuv = optarg;
    break;
  case 'n' :
    sscanf(optarg,"%d",&nbin);
    if(nbin<0) nbin=90;
    break;
  case 'i' :
    tcoorin=optarg;
    break;
  case 'o' :
    tcoormap=optarg;
    break;
  case 'e' :
    sscanf(optarg,"%lf",&equi);
    break;
  case 'm' :
    sscanf(optarg,"%lf",&vmin);
    tmin = true;
    break;
  case 'M' :
    sscanf(optarg,"%lf",&vmax);
    tmax = true;
    break;
  case 'f' :
    sscanf(optarg,"%ul",&badflg);
    tflg = true;
    break;
  case 'I' :
    snimplicit = true;
    break;
  case 'h' :
  default:
    usage(); exit(1);
    break;
  }
}
if(optind+2>=narg) {usage(); exit(3);}
 
char * fitsin_point = arg[optind];
char * fitsin_bolo = arg[optind+1];
string const fitlmapout = arg[optind+2];
if(optind+3<narg) fitlmapwout = arg[optind+3];

cout<<">>>> tsttoi2map:"<<endl
    <<"Pipe Window Size "<<width<<endl
    <<"Fits Infile Bolo "<<fitsin_bolo<<endl
    <<"  ...label_bolomuv "<<label_bolomuv<<endl;
cout<<"Fits Infile Pointing "<<fitsin_point<<endl
    <<"  ...label_coord1 "<<label_coord1<<endl
    <<"  ...label_coord2 "<<label_coord2<<endl
    <<"  ...... ctype="<<tcoorin<<endl;
cout<<"Fits Healpix Lmapere "<<fitlmapout<<endl
    <<"  ...nbin "<<nbin<<endl;
cout<<"Fits Healpix Weight Lmapere "<<fitlmapwout<<endl
    <<"  ...... ctype="<<tcoormap<<endl;
cout<<"Equinoxe "<<equi<<" years"<<endl;

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------


 // FITS reader
 FITSTOIReader rfitsb(fitsin_bolo);
 if(snimplicit) rfitsb.setImplicitSN();
 int ncolb = rfitsb.getNOut();
 cout<<"Number of columns in fits Infile_bolo : "<<ncolb<<endl;
 if(ncolb<1) exit(-4);

 FITSTOIReader rfitsp(fitsin_point);
 if(snimplicit) rfitsp.setImplicitSN();
 int ncolp = rfitsp.getNOut();
 cout<<"Number of columns in fits Infile_point : "<<ncolp<<endl;
 if(ncolp<2) exit(-5);

 // Creation de la lmapere Healpix
 
 // Creation de la lmapere de poids Healpix
 PixelMap<r_8>* map;
 PixelMap<r_8>* wmap;

 LocalMap<r_8>* lmap = new LocalMap<r_8>(nbin,nbin);

 lmap->SetSize(size,size);
 lmap->SetOrigin(xcenter,ycenter);
 cout<<"LocalMap: Type de map : "<<lmap->TypeOfMap()<<endl
     <<"               Nombre de pixels : "<<lmap->NbPixels()<<endl
     <<"               Nbin : "<<lmap->SizeIndex()<<endl;

 map = lmap;
 wmap = new LocalMap<r_8>(*lmap);
 

 // TOI Processor
 TOI2Map toi2m(map,wmap);
 cout<<"TOI2Map created"<<endl;
 toi2m.SetEquinox(equi);
 toi2m.SetCoorIn(tcoorin);
 toi2m.SetCoorMap(tcoormap);
 toi2m.SetTestFlag(tflg,badflg);
 toi2m.SetTestMin(tmin,vmin);
 toi2m.SetTestMax(tmax,vmax);
 toi2m.Print(cout);

 // Definition des tuyaux
#ifdef TOISEQBUFFERED
 cout<<">>>> Using TOISeqBuffered"<<endl;
 TOISeqBuffered * toicoord1in = new TOISeqBuffered("toi_coord1_in",width);
#else
 cout<<">>>> Using TOISegmented"<<endl;
 TOISegmented * toicoord1in = new TOISegmented("toi_coord1_in",width);
#endif
 // toicoord1in->setDebugLevel(1);
 rfitsp.addOutput(label_coord1,toicoord1in);
 toi2m.addInput("Coord1In",toicoord1in);

#ifdef TOISEQBUFFERED
 TOISeqBuffered * toicoord2in = new TOISeqBuffered("toi_coord2_in",width);
#else
 TOISegmented * toicoord2in = new TOISegmented("toi_coord2_in",width);
#endif
 // toicoord2in->setDebugLevel(1);
 rfitsp.addOutput(label_coord2,toicoord2in);
 toi2m.addInput("Coord2In",toicoord2in);
 
#ifdef TOISEQBUFFERED
 TOISeqBuffered * toibolin = new TOISeqBuffered("toi_bolo_in",width);
#else
 TOISegmented * toibolin = new TOISegmented("toi_bolo_in",width);
#endif
 // toibolin->setDebugLevel(1);
 rfitsb.addOutput(label_bolomuv,toibolin);
 toi2m.addInput("BoloIn",toibolin);

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;
 rfitsp.PrintStatus(cout);
 rfitsb.PrintStatus(cout);

 PrtTim("starting threads");
 rfitsp.start();
 rfitsb.start();
 toi2m.start();

 // if(lp>1)
 //   for(int jjjj=0;jjjj<5;jjjj++) {
 //     cout<<*toicoord1in; 
 //     cout<<*toibolin; 
 //     sleep(2);
 //   }

 // Affichage de l'avancement des TOIProcessors 
 ProcSampleCounter<TOI2Map>  stats(toi2m);
 stats.InfoMessage() = "tsttoi2map/Info"; 
 stats.PrintStats(); 

 // Fin des traitements des TOIProcessors  
 mgr->joinAll();
 PrtTim("End threads");


 // Ecriture de la lmapere Healpix sur fits
 {
 FitsOutFile sfits(fitlmapout,FitsFile::clear);
 cout<<"tsttoi2map: Creating lmapere fits file "<<fitlmapout<<endl;
 sfits << *(LocalMap<r_8>*)map;
 }

 // Ecriture de la lmapere Healpix sur fits
 if(wmap) {
   FitsOutFile swfits(fitlmapwout,FitsFile::clear);
   cout<<"tsttoi2map: Creating lmapere weight fits file "<<fitlmapwout<<endl;
   swfits << *(LocalMap<r_8>*)wmap;
 }

 // Nettoyage
 cout << "tsttoi2map: cleanup " << endl;
 delete lmap;
 if(wmap) delete wmap;
 cout << "tsttoi2map: ----------- End of job -------------- " << endl;

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2map: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2map: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2map: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
