// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari

#ifndef SIMCLEANER_H
#define SIMCLEANER_H

#include "toiprocessor.h"
#include "tvector.h"
#include "ntuple.h"

// ---- Calcul de ligne de base 
//      Ajustement polynomial sur des echantillons moyennes
//
// Structure generale :
// 
//               -------------------------
//  toi in -->   |                       | ---> out = i+flag updated
//               |     SimpleCleaner     | ---> mean (opt)
//               |                       | ---> sigma (opt)
//               |                       |
//               -------------------------

class SimpleCleaner : public TOIProcessor {
public:
           SimpleCleaner(int wsz=256, int nbw=5);
  virtual  ~SimpleCleaner();

  void          SetMeanSigWindow(int wsz=256, int nbw=5);

  inline void    FillMeanSigNTuple(bool fg = false) 
    { fg_meansignt = fg; }
  inline NTuple& GetMeanSigNTuple() { return *meansignt; }

  inline void   SetRange(double min=-9.e19, double max=+9.e19)
    { range_min = min; range_max = max; }
  inline void   GetRange(double& min, double& max) const 
    { min = range_min; max = range_max; }
  inline void   SetCleanForMeanThrNSig(double ns=3.)
    { nsigclean = ns; }
  inline double GetCleanForMeanThrNSig()
    { return(nsigclean); }
  inline void   SetFlaggingThrNSig(double ns1=4., double ns2=2., int npt2=3)
    { nsig1 = ns1;  nsig2 = ns2;  min_npt2 = npt2; } 
  inline void   GetFlaggingThrNSig(double& ns1, double& ns2, int& npt2)
    { ns1 = nsig1;  ns2 = nsig2; npt2 = npt2; } 

  inline double GetGlMean() { return( (ns_glms > 0) ? gl_sum/ns_glms : 0.) ; }
  inline double GetGlSigma2() 
    { 
      double m = GetGlMean();
      return( (ns_glms > 0) ? gl_sum2/ns_glms-m*m : 0.) ; 
    }

  inline int_4  GetGLMSNbSample() { return ns_glms; }

  virtual void	init();  
  virtual void	run();

  inline int_8	ProcessedSampleCount() const { return totnscount; }

  virtual void  PrintStatus(::ostream & os) ; // const plus tard

protected:
  int_8 totnscount;   // Nombre total d'echantillon processe
  int_8 totnbblock;   // Nombre total de blocs 
  int mWSz;           // Fentre Calcul mean-sigma : mNbW*mWSz
  int mNbW;           //    "    "    "    "      " 
  double nsigclean;   // Point a +- nsig4mean pas pris en compte pour calcul mean
  double nsig1;       // Point a +- nsig1 flagge
  double nsig2;       // >=min_npt2 Points a +- nsig2 flagges
  int min_npt2;       // Min NPoints a += nsig2 
  double range_min, range_max;  // Range acceptable pour in
  int_4 ns_outofrange;  // Nb de points out of range
  int_4 ns_flag1p;       // Nb de points flagges avec nsig1 (> mean) 
  int_4 ns_flag2p;       // Nb de points flagges avec nsig2 (> mean)
  int_4 ns_flag1m;       // Nb de points flagges avec nsig1 (< mean) 
  int_4 ns_flag2m;       // Nb de points flagges avec nsig2 (< mean) 
  double gl_sum, gl_sum2;  // Global Sum(x) - Sum(x^2)
  int_4 ns_glms;             // Nb d'echantillon pour  Global Sum(x) - Sum(x^2)

  bool fg_meansignt;
  NTuple* meansignt;
};

#endif
