#ifndef PIMGADAPTER_SEEN
#define PIMGADAPTER_SEEN

#include "cimage.h"
#include "parradapter.h"

class RzImageAdapter : public P2DArrayAdapter {
public:
                  RzImageAdapter(RzImage* rzi, bool ad=false) :
                    P2DArrayAdapter(rzi->XSize(), rzi->YSize())
                    { aDel = ad; mImg = rzi; }

  virtual 	  ~RzImageAdapter() { if (aDel) delete mImg; }
  virtual double  Value(int ix, int iy) { return mImg->FValue(ix, iy); }

protected :
  bool aDel;
  RzImage* mImg;
};

template <class T> 
class ImageAdapter : public P2DArrayAdapter {
public:
                  ImageAdapter(Image<T>* img, bool ad=false) :
                    P2DArrayAdapter(img->XSize(), img->YSize())
                    { aDel = ad; mImg = img; }

  virtual 	  ~ImageAdapter() { if (aDel) delete mImg; }
  virtual double  Value(int ix, int iy) { return((*mImg)(ix, iy)); }

protected :
  bool aDel;
  Image<T>* mImg;
};

#endif
