// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toimanager.cc,v 1.15 2002-06-18 21:15:19 ansari Exp $

#include "toimanager.h"
#include <limits.h>
#include <pthread.h>
#include <iostream.h>
#include <unistd.h>

#ifndef MAXINT
#define MAXINT 2147483647
#endif

TOIManager::TOIManager() {
  reqBegin = 0;
  reqEnd = MAXINT;
}

TOIManager* TOIManager::instance = NULL;

TOIManager* TOIManager::getManager() {
  if (instance == NULL) instance =  new TOIManager();
  return instance;
}

void TOIManager::setRequestedSample(int begin, int end) {
  reqBegin = begin;
  reqEnd   = end;
}

int TOIManager::getRequestedBegin() {
  return reqBegin;
}

int TOIManager::getRequestedEnd() {
  return reqEnd;
}

void TOIManager::addThread(pthread_t* t) {
  //  cout << "adding thread  "  <<  t << endl;
  threads.push_back(t); 
}

void TOIManager::joinAll() {
  for (vector<pthread_t*>::iterator i = threads.begin();
       i != threads.end(); i++) {
    pthread_t* pth = *i;
    cout << "joining thread  " << pth <<  endl;
    pthread_join(*pth, NULL);
    cout << "thread joined " << pth << endl;
  }
}


// -----------------------------------------------------------------
//    Classe pour affichage de l'avancement des TOIProcessors 
//                         Reza 08/2001 
// -----------------------------------------------------------------

RzProcSampleCounter::RzProcSampleCounter()
{
  _msg = "SampleCounter/Info";
  _rate = 50;
}

RzProcSampleCounter::~RzProcSampleCounter()
{
}

long RzProcSampleCounter::PrintStats()
{
  int istart = 0;
  int iend = 0;
  long dns_print = 1000;
  int dns_print_fac = _rate;
  int nbmax_dns_print = 2;

  TOIManager* mgr = TOIManager::getManager();
  
  //  istart = mgr->getRequestedBegin();
  //  iend = mgr->getRequestedEnd();
  istart = SampleBegin();
  iend = SampleEnd();
  
  dns_print = (iend-istart)/dns_print_fac;
  if (dns_print < 1000) dns_print = ((iend-istart) < 1000) ? (iend-istart) : 1000;
  if (dns_print < 1) dns_print = 1;
  nbmax_dns_print = (iend-istart)/dns_print;

  cout << "RzProcSampleCounter::PrintStats() InfoMessage=" << _msg 
       << "\n ... " << _msg << " istart=" 
       << istart << " iend= " << iend << " dns_print= " << dns_print
       << " nbmax_dns_print= " << nbmax_dns_print << endl;
  // ------------------- Impression continu de stat ------------------------ 
  long nb_dns_print = 0;
  int nb_sleep = 0;
  long last_sample_count = 0;
  long processed_samples = 0;
  long total_sample_count = dns_print*nbmax_dns_print;
  bool alldone = false;
  double fracperc = 0.;
  int fperc = 0;
  while (!alldone) {
    processed_samples = ProcessedSampleCount();
    if ( (processed_samples-last_sample_count > dns_print) || 
         (processed_samples > total_sample_count-10) ) {
      last_sample_count = processed_samples;
      if (nb_dns_print == 0) cout << "\n";
      nb_dns_print++;
      fracperc = (double)processed_samples*100./(double)total_sample_count;
      fperc = fracperc*100;
      cout << ">>> " << _msg << ": ProcessedSampleCount()= " << last_sample_count 
           << " Frac done = " << (double)fperc/100. << " %" << endl;
      if (last_sample_count > total_sample_count-10)  alldone = true;
      nb_sleep = 0;
    }
    else if ((nb_sleep+1)%5 == 0) {
      fracperc = (double)processed_samples*100./(double)total_sample_count;
      fperc = fracperc*100;
      cout << "> " << _msg << ": ProcSamples()= " <<  processed_samples 
           << " Done = " << " %" << (double)fperc/100.
           << " NbSleep(1) = " << nb_sleep << endl;
    }
    sleep(1);  nb_sleep++;
  }
  
  // -----------------------------------------------------------------------
  
  return last_sample_count;

}
