// This may look like C code, but it is really -*- C++ -*-
// Methodes de trace d'axes - 
//                             R. Ansari  2002
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIAXES_H
#define PIAXES_H

#include "pigraphuc.h"
#include "pigratt.h"

enum {
  kStdAxes     = 0x0001,
  kBoxAxes     = 0x0002,
  kTicks       = 0x0004,
  kIntTicks    = 0x0010,
  kExtTicks    = 0x0020,
  kMajTicks    = 0x0040,
  kMinTicks    = 0x0080,
  kLabels      = 0x1000,
  kGridOn      = 0x2000,
  kAxesDflt    = kStdAxes | kTicks | kLabels,       // Axes trace par defaut
  kAxesNone    = 0                                  // Pas de trace d axe  
};


class PIAxes {
public:

                    PIAxes();
  virtual           ~PIAxes();

  virtual void      DrawXYAxes(PIGraphicUC* g, PIGraphicAtt& gratt, 
			       unsigned int flags, bool afsz);

  virtual void      DrawXYAxes(PIGraphicUC* g, PIGraphicAtt& gratt, 
			       unsigned int flags, bool afsz, 
			       double xmin, double xmax, 
			       double ymin, double ymax);

  //  virtual void      DrawHorizontalAxe(double xmin, double xmax, double y, 

//  --- Methodes static ----
//  Calcul des Distances optimales des subdivisions 
  static void BestTicks(double xmin,double xmax,int nticks
                       ,double& steptick,double& xfirsttick);
//  Calcul du format optimal pour les axes
  static int BonFormatAxes(double xmin,double xmax,double xstep
                          ,string& format,int typf=0,int add_digit=0);
protected:
  void Setup(PIGraphicUC* g, double xmin, double xmax, 
	     double ymin, double ymax);

  void DrawHTicks(PIGraphicUC* g, double y, double tickUp, double tickDown, double xBeg, double xStep);
  void DrawVTicks(PIGraphicUC* g, double x, double tickLeft, double tickRight, double yBeg, double yStep);
  void DrawHLabels(PIGraphicUC* g, double y, double xBeg, double xStep, unsigned long just=0);
  void DrawVLabels(PIGraphicUC* g, double x, double yBeg, double yStep, unsigned long just=0);
  void DrawGrid(PIGraphicUC* g);

  double xMin, xMax, yMin, yMax; 
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 
  bool   aXlog, aYlog;           // Echelle log pour les axes horiz, vertical 
  bool   axesAFSz;
  
  double xFirstMajTick, xFirstMinTick;
  double yFirstMajTick, yFirstMinTick;
  double xMajTickStep, xMinTickStep;
  double yMajTickStep, yMinTickStep;
  double xMajTickLen,  xMinTickLen;
  double yMajTickLen,  yMinTickLen;

};

#endif
