// Classe traceur de StarList               97-99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#include <stdio.h>
#include "pistlist.h"

#define PERC_GARDE 0.02

//++
// Class	PIStarList
// Lib		PIext
// include	pistlist.h
//
//	Classe traceur d'objets de la classe *StarList* 
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Titre	Constructeur
//--

//++
//  PIStarList(StarList* stl, bool ad)
//	Constructeur. Si "ad == true", l'objet "stl" est dtruit par 
//	le destructeur de l'objet "PIStarList"
//	Note : "stl" doit tre cr par new 
//--

/* --Methode-- */
PIStarList::PIStarList(StarList* stl, bool ad)
: PIDrawer(), mStL(stl)
{
  mAdDO = ad;   
  if (stl == NULL) return;
  SetFluxLimits(1., -1.);
}

PIStarList::~PIStarList()
{
  if (mAdDO && mStL)  delete mStL;
}

//++
// Titre	Mthodes
//--
//++
//  void  SetFluxLimits(float min=1., float max=-1., int nl=5, bool dispflx=false, bool refr=false)
//	Modifie les paramtres de visualisation (limites en flux). Si "dispflx==true"
//	les valeurs de flux sont affiches pour chaque toile.
//  StarList*  StList()
//	Retourne l'objet "StarList" associ.
//  float FluxMin()
//	Retourne le paramtre de visualisation flux minimum
//  float FluxMax()
//	Retourne le paramtre de visualisation flux maximum
//--

/* --Methode-- */
void  PIStarList::SetFluxLimits(float fmin, float fmax, int nl, bool dispflx, bool refr)
{
  if (!mStL)  return;  
  if (fmin < fmax)  { mFmin = fmin;  mFmax = fmax; }
  else mStL->CalcFluxLimits(mFmin, mFmax);
  if (mFmin < 1.e-10)  mFmin = 1.e-10;
  if (mFmax <= mFmin)  mFmax = 1.5*mFmin;
  mDLgF = log10((double)mFmax/(double)mFmin);
  if (mDLgF < 1.e-10)  mDLgF = 1.e-10;
  mF0 = mFmin;
  if (nl < 1)  nl = 1;
  if (nl > 20)  nl = 20;
  mNLev = nl;  
  mDspFV = dispflx;
  if (refr)  Refresh();
  return;
}


/* --Methode-- */
void PIStarList::UpdateLimits()
{
  if (!mStL) return;

  // Commencer par trouver nos limites
  double dx, dy;
  double x1, x2, y1, y2;
  mStL->CalcXYLimits(x1, x2, y1, y2);
  
  dx = PERC_GARDE*(x2-x1);
  dy = PERC_GARDE*(y2-y1);
  
  SetLimits(x1-dx, x2+dx, y1-dy, y2+dy); 
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PIStarList::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
BStar *sti;
double xp,yp;
float flx;
int sz;
char buff[128];
int nok, nl2;

if (!mStL) return;

PIGrCoord uxmin, uxmax, uymin, uymax;
g->GetGrSpace(uxmin, uxmax, uymin, uymax);
double xmin2 = uxmin;
double ymin2 = uymin;
double xmax2 = uxmax;
double ymax2 = uymax;

// int msz = mMSz; //OP
int  msz = GetGraphicAtt().GetMarkerSz(); 

if (msz < 1) msz = 1;
//PIMarker mrk = (mMrk != PI_NotDefMarker) ? mMrk : PI_FCircleMarker; //OP
PIMarker mmrk = GetGraphicAtt().GetMarker();
PIMarker mrk = (mmrk != PI_NotDefMarker) ? mmrk : PI_FCircleMarker;

// g->SelFont();
nok = 0;  nl2 = mNLev*2-1;
for (int i=0; i<mStL->NbStars(); i++) {
  sti = mStL->Star(i);
  if ( !(sti->Nice(BStar::flagOK)) )  continue;
  flx = sti->Flux();
  if ( (flx < mFmin) || (flx > mFmax) )  continue;
  xp = sti->PosX();   yp = sti->PosY();
  if ( (xp < xmin2) || (xp > xmax2) || (yp < ymin2) || (yp > ymax2) )  continue;
  nok++;
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  sz = (int)((log10((double)flx/mF0))/mDLgF*(double)nl2-0.01) + msz;
  if (sz < 2)  g->SelMarker(sz, PI_DotMarker);
  else g->SelMarker(sz, mrk);
  g->DrawMarker((double)xp,(double)yp ); 
  if (mDspFV) {  
    sprintf(buff," F=%g", flx);
    double dx,dy;
    g->DGrC2UC(sz, 4, dx, dy);
    g->DrawString(xp+dx, yp-dy, buff);
    } 
  }

/*
sprintf(buff, "StarList:  NbStars= %d  NDisp= %d", (int)mStL->NbStars(), nok);
g->BaseGraphic()->DrawString(15,15,buff);
sprintf(buff, "FMin= %g  FMax= %g Nl= %d Sz0= %d", mFmin, mFmax, mNLev, mMSz0);
g->BaseGraphic()->DrawString(15,30,buff);
*/

}

/* --Methode-- */
void PIStarList::AppendTextInfo(string& info, double xmin, double ymin, double xmax, double ymax)
{
BStar *sti;
double xp,yp;
double flx,fnd;
char buff[128];
int ncnt = 0;
sprintf(buff,"PIStarList: NStars %d \n", mStL->NbStars() );
info += buff;
info += "  Num:   XPos       YPos     Flux      Fond \n";
for (int i=0; i<mStL->NbStars(); i++) {
  sti = mStL->Star(i);
  if ( !(sti->Nice(BStar::flagOK)) )  continue;
  flx = sti->Flux();
  if ( (flx < mFmin) || (flx > mFmax) )  continue;
  xp = sti->PosX();   yp = sti->PosY();
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  ncnt++;
  if (ncnt > 101) continue;
  fnd = sti->Fond();
  sprintf(buff,"%6d: %8.3g %8.3g %8.3g %8.3g \n", i, xp, yp, flx, fnd); 
  info += buff;
  }
if (ncnt >= 101) info += " .... \n";
sprintf(buff," %d stars inside selected region \n", ncnt);
info += buff;
return;
}
