//#define TOISEQBUFFERED

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "toi.h"
#include "cgt.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "sambainit.h"
#include "toi2toi_addsp.h"
#include "timing.h"

#include <stdexcept>

void usage(void);
void usage(void) {
 cout<<"tsttoi2toi_addsp [-h] [-p lp] [-s samplemin,samplemax] [-w data_window_size]"<<endl
     <<"           [-a label_coord1] [-d label_coord2] [-b label_bolomuv]"<<endl
     <<"           [-n nlat] [-i c,h] [-o c,h]"<<endl
     <<"           [-m vmin] [-M vmax] [-f flag]"<<endl
     <<"           fitsin_point fitsin_bolo fitsphout [fitsphwout]"<<endl
     <<" -p lp : print level (def=0)"<<endl
     <<" -s samplemin,samplemax : sample range to be treated (def=all)"<<endl
     <<" -w data_window_size : window size for pipe (def=8192)"<<endl
     <<" -a label_coord1 : label fits for alpha/gLong (def=coord1)"<<endl
     <<" -d label_coord2 : label fits for delta/gLat (def=coord2)"<<endl
     <<"          coord1 = alpha or gLong ; coord2 = delta or gLat"<<endl
     <<" -b label_bolomuv : label fits for bolo value (def=boloMuV)"<<endl
     <<" -m vmin : samples are good if sample value >= vmin"<<endl
     <<" -M vmax : samples are good if sample value <= vmax"<<endl
     <<" -f flag : samples are bad if match flag"<<endl
     <<" -I : sampleNum are implicit in fits files (def=no)"<<endl
     <<" fitsin_point : fits file for pointing"<<endl
     <<" fitsin_bolo : fits file for bolo values"<<endl
     <<" fitsout_bolo : fits file for output bolo value"<<endl
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
int lp = 0, width = 8192;
bool tflg=false, tmin=false, tmax=false;
r_8 vmin=-1.e30, vmax=1.e30; uint_8 badflg=0;
char *label_coord1 = "coord1", *label_coord2 = "coord2"
   , *label_bolomuv = "boloMuV";
double equi=2000.;
char *tcoorin="gdcdl", *tcoormap="g";
long sdeb,sfin;
bool snimplicit = false;
int c;
while((c = getopt(narg,arg,"hIp:s:w:a:d:b:n:i:o:m:M:f:e:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    //else {cout<<"Bad sample interval "<<endl; exit(2);}
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'a' :
    label_coord1 = optarg;
    break;
  case 'd' :
    label_coord2 = optarg;
    break;
  case 'b' :
    label_bolo_in = optarg;
    break;
  case 'n' :
    label_bolo_out = optarg;
    break;
  case 'u' :
    label_utc = optarg;
    break;
  case 'l' :
    label_lon = optarg;
    break;
  case 'L' :
    label_lat = optarg;
    break;
  case 'i' :
    tcoorin=optarg;
    break;
  case 'o' :
    tcoormap=optarg;
    break;
  case 'e' :
    sscanf(optarg,"%lf",&equi);
    break;
  case 'm' :
    sscanf(optarg,"%lf",&vmin);
    tmin = true;
    break;
  case 'M' :
    sscanf(optarg,"%lf",&vmax);
    tmax = true;
    break;
  case 'f' :
    sscanf(optarg,"%ul",&badflg);
    tflg = true;
    break;
  case 'I' :
    snimplicit = true;
    break;
  case 'h' :
  default:
    usage(); exit(1);
    break;
  }
}
if(optind+5>=narg) {usage(); exit(3);}
 
char * fitsin_point = arg[optind];
char * fitsin_bolo = arg[optind+1];
char * fitsin_utc = arg[optind+2];
char * fitsin_lon = arg[optind+3];
char * fitsin_lat = arg[optind+4];
char * fitsout_bolo = arg[optind+5];

cout<<">>>> tsttoi2toi_addsp:"<<endl
    <<"Pipe Window Size "<<width<<endl
    <<"Fits Infile Bolo "<<fitsin_bolo<<endl
    <<"  ...label_bolo_in "<<label_bolo_in<<endl;
cout<<"Fits Infile Pointing "<<fitsin_point<<endl
    <<"  ...label_coord1 "<<label_coord1<<endl
    <<"  ...label_coord2 "<<label_coord2<<endl
    <<"  ...... ctype="<<tcoorin<<endl;
cout<<"Fits Outfile Bolo"<<fitsout_bolo<<endl
    <<"  ...label_bolo_out "<<label_bolo_out<<endl;

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------
  
  CGT plombier(fgsegmented,wsize);
  plombier.SetDebugLevel(0);

 // FITS reader
 FITSTOIReader rfitsb(fitsin_bolo);
 if(snimplicit) rfitsb.setImplicitSN();
 int ncolb = rfitsb.getNOut();
 cout<<"Number of columns in fits Infile_bolo : "<<ncolb<<endl;
 if(ncolb<1) exit(-4);

 FITSTOIReader rfitsp(fitsin_point);
 if(snimplicit) rfitsp.setImplicitSN();
 int ncolp = rfitsp.getNOut();
 cout<<"Number of columns in fits Infile_point : "<<ncolp<<endl;
 if(ncolp<2) exit(-5);


 FITSTOIReader rfitsu(fitsin_utc);
 FITSTOIReader rfitsl(fitsin_lon);
 FITSTOIReader rfitsL(fitsin_lat);


 // TOI Processor
 Toi2toi_Addsp toi2t_sp();
 cout<<"Toi2toi_Addsp created"<<endl;
 toi2t_sp.SetEquinox(equi);
 toi2t_sp.SetCoorIn(tcoorin);
 toi2t_sp.SetCoorMap(tcoormap);
 toi2t_sp.SetTestFlag(tflg,badflg);
 toi2t_sp.SetTestMin(tmin,vmin);
 toi2t_sp.SetTestMax(tmax,vmax);
 toi2t_sp.Print(cout);

 // Definition des tuyaux
 plombier.Connect(rfitsp,label_coord1,toi2t_sp,"Coord1In");
 plombier.Connect(rfitsp,label_coord2,toi2t_sp,"Coord2In");
 plombier.Connect(rfitsb,label_bolo_in,toi2t_sp,"BoloIn");

 plombier.Connect(rfitsu,label_utc,toi2t_sp,"utc");
 plombier.Connect(rfitsl,label_lon,toi2t_sp,"lon");
 plombier.Connect(rfitsL,label_lat,toi2t_sp,"lat");

 plombier.Connect(toi2t_sp,"BoloOut",wfits,label_bolo_out);

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;

 plombier.Start();
 plombier.ListTOIs(cout, 1);
 cout << "Joining ..." << endl;
 mgr->joinAll();
 PrtTim("End threads");



//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2toi_addsp: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2toi_addsp: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2toi_addsp: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
