// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2toi_addsp.cc,v 1.1 2002-07-16 08:48:06 cecile Exp $

#include "machdefs.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "toi2map.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
TOI2Map::TOI2Map()
  : totnscount(0)
{
 SetEquinox();
 SetCoorIn();
 SetCoorMap();
 SetTestFlag();
 SetTestMin();
 SetTestMax();

}

TOI2Map::~TOI2Map()
{
}

////////////////////////////////////////////////////////////////////////
void TOI2Map::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void TOI2Map::init() {
  cout << "TOI2Map::init" << endl;
  declareInput("Coord1In");
  declareInput("Coord2In");
  declareInput("BoloIn"); 
  declareInput("utc"); 
  declareInput("lon"); 
  declareInput("lat"); 
 
  declareOutput("BoloOut");  
}

////////////////////////////////////////////////////////////////////////
// define SANS_BUFFER
void TOI2Map::run()
{
long snb = getMinIn();
long sne = getMaxIn();

if(snb>sne) {
  cout<<"TOI2Map::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("TOI2Map::run() - Bad sample interval");
}
if(!checkInputTOIIndex(0) || !checkInputTOIIndex(1) || !checkInputTOIIndex(2)) {
  cout<<"TOI2Map::run() - Input TOI (Coord1In or Coord2In or BoloIn) not connected! "<<endl;
  throw ParmError("TOI2Map::run() Output TOI (Coord1In or Coord2In or BoloIn) not connected!");
}
if( !(mTypCoorIn&TypCoordEq || mTypCoorIn&TypCoordGal) ) {
  cout<<"TOI2Map::run() - Input Coordinates not Eq or Gal! "<<endl;
  throw ParmError("TOI2Map::run() - Input Coordinates not Eq or Gal!");
}
if( !(mTypCoorMap&TypCoordEq || mTypCoorMap&TypCoordGal) ) {
  cout<<"TOI2Map::run() - Output Coordinates not Eq or Gal! "<<endl;
  throw ParmError("TOI2Map::run() - Output Coordinates not Eq or Gal!");
}

//---------------------------------------------------------
#define NFILL 25
try {

int ii;
uint_4 mNSnFill=0, mNpixFill=0, NFill[NFILL], BadCoorRange=0;
for(ii=0;ii<NFILL;ii++) NFill[ii]=0;
double mjd = MJDfrYear(mActualYear);

cout<<"TOI2Map::run() from "<<snb<<" to "<<sne;
#ifndef SANS_BUFFER
int bufsz = 100;
uint_8* bfgbolo = new uint_8[bufsz];
double* bbolo   = new double[bufsz];
double* bc1     = new double[bufsz];
double* bc2     = new double[bufsz];
int i0 = -1;
cout<<" (getData() bufferized)"<<endl;
#else
cout<<" (getData() not bufferized)"<<endl;
#endif

for(int s=snb;s<=sne;s++) {
  uint_8 fgbolo = 0;
  double bolo,coord1,coord2;
  //              Equatoriales   /   Galactiques
  // coord1,2 =   alpha,delta    /   gLon,gLat

  getData(2,s,bolo,fgbolo);
  coord1 = getData(0,s);
  coord2 = getData(1,s);
  totnscount++;

  // Comme il n'y a pas de toi en sortie, il faut dire
  // aux processeur/toi que l'on a plus besoin des donnees.
  if (s%100 == 0) wontNeedBefore(s-1);
  if(mTFlag && fgbolo&mBadFlag) continue;
  if(mTMin && bolo<mValMin) continue;
  if(mTMax && bolo>mValMax) continue;

  // sphere phi   entre [0,2*Pi] en radians
  // sphere theta entre [0,Pi]   en radians
  double phi=-1.;
  CoordConvertToStd(mTypCoorIn,&coord1,&coord2);

  if(mTypCoorIn&TypCoordEq && mTypCoorMap&TypCoordGal) { // Eq -> Gal
    EqtoGal(mjd,coord1,coord2,&coord1,&coord2);
    phi   = coord1 * Pi/180.;
  } else if(mTypCoorIn&TypCoordGal && mTypCoorMap&TypCoordEq) { // Gal -> Eq
    GaltoEq(mjd,coord1,coord2,&coord1,&coord2);
    phi   = coord1 * Pi/12.;
  } else if(mTypCoorMap&TypCoordGal) { // Gal -> Gal
    phi   = coord1 * Pi/180.;
  } else if(mTypCoorMap&TypCoordEq) { // Eq -> Eq
    phi   = coord1 * Pi/12.;
  }
  ToCoLat(&coord2,TypUniteD);

  putData(0,s,bolo_sp,fgbolo);

}
 

 cout<<"TOI2Map::run(): Fin de boucle sur les sampleNum"<<endl;


//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"TOI2Map: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
