// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2toi_addsp.h,v 1.2 2002-07-16 15:26:19 cecile Exp $

#ifndef TOI2MAP_H
#define TOI2MAP_H

#include "toiprocessor.h"
#include "toiprocessor.h"
#include "spherehealpix.h"
#include "localmap.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un projecteur de TOI sur une carte quelconque
// Lecture de 3 TOI coord1,coord2,boloMuV
// Sortie pas de TOI, une (2) cartes
//
// Structure generale :
//                          |---->Carte
//                          |
//                     -----------
//   toi Coord1In ---> |         |
//   toi Coord2In ---> | TOI2Map |
//   toi BoloIn   ---> |         |
//                     -----------
// Gestion du type de coordonnees :
// Coord1In,Coord2In : soit Equatoriales (Alpha,Delta)
//                     soit Galactiques  (GLong,GLat)
// Sortie sur une sphere en coordonnees Equatoriales ou Galactiques
// Si les CoordIn et les CoordMap sont equatoriales -> meme equinoxe!

struct Info_src 
{
  double glon,glat;
  double azi,elv;
  double amp,tau1,tau2;
};

void Fill_Info_scr(Info_src* scr, int_4 ns);

class Toi2toi_Addsp : public TOIProcessor {
public:
                 Toi2toi_Addsp(Info_src* info, int_4 ns);
  virtual	~Toi2toi_Addsp();

  virtual void	init(void);
  virtual void	run(void);

  // Coordonnees donnees en entree et en sortie
  inline void SetEquinox(double actualyear=2000.)
              {mActualYear = actualyear;}

  inline void SetCoorIn(unsigned long mfg=TypCoordGalStd)
              {mTypCoorIn = mfg;}
  inline void SetCoorIn(const char *ctype)
              {mTypCoorIn = DecodeTypAstro(ctype);}

  inline void SetCoorMap(unsigned long mfg=TypCoordGal)
              {mTypCoorMap = mfg;}
  inline void SetCoorMap(const char *ctype)
              {mTypCoorMap = DecodeTypAstro(ctype);}

  // Test on flag value ? if yes, BAD sample have flag matching mBadFlag
  inline void SetTestFlag(bool tflg=false, uint_8 badflg=FlgToiAll)
              {mTFlag = tflg; mBadFlag = badflg;}
  // Test on min value ? if yes, GOOD sample have value >= mValMin
  // Test on max value ? if yes, GOOD sample have value <= mValMax
  // Good values are (mValMin <= sample value <= mValMax)
  //                      bounds are included
  inline void SetTestMin(bool tmin=false, r_8 vmin=-1.e30)
              {mTMin = tmin; mValMin = vmin;}
  inline void SetTestMax(bool tmax=false, r_8 vmax=+1.e30)
              {mTMax = tmax; mValMax = vmax;}
  // Print
  void Print(::ostream & os);

protected:

  unsigned long mTypCoorIn, mTypCoorMap;
  double mActualYear;
  Info_src* src;
  int_4 nb_src;

  bool mTFlag,mTMin,mTMax;
  uint_8 mBadFlag;
  r_8 mValMin,mValMax;

};

#endif
