//===========================================================================//
//================================= piqualmon.cc ============================//
//===========================================================================//

#include <stdio.h>
#include "piqualmon.h"
#include "qualite.h"

//========================= classe PIQualiteWin =============================//
PIQualiteWin::PIQualiteWin(PIMsgHandler *par)
:PIWindow(par, "Qualite Suivi", PIWK_normal, 660, 280, 160, 0)
{
  ccd = 100;
  var1 = "FOND";
  var2 = "SIGMA";
  monitoring1    = new PIQualiteMon(this, "Fond", 300, 200, 20, 40);
  monitoring2    = new PIQualiteMon(this, "Fond", 300, 200, 340,40);
  menuccd        = new PIPUMenu(this, "CCD");
  menuccd->AppendItem("tous", 80100);
  menuccd->AppendItem("0", 80000);
  menuccd->AppendItem("1", 80001);
  menuccd->AppendItem("2", 80002);
  menuccd->AppendItem("3", 80003);
  menuccd->AppendItem("4", 80004);
  menuccd->AppendItem("5", 80005);
  menuccd->AppendItem("6", 80006);
  menuccd->AppendItem("7", 80007);

  menudata[0]    = new PIPUMenu(this, "Data");
  menudata[0]->AppendItem("FOND" , 90001);
  menudata[0]->AppendItem("SIGFOND" , 90005);
  menudata[0]->AppendItem("SIGMA", 90002);
  menudata[0]->AppendItem("NSTAR", 90003);
  menudata[0]->AppendItem("FOND/MIN", 90004);

  menudata[1]    = new PIPUMenu(this, "Data");
  menudata[1]->AppendItem("FOND" , 90011);
  menudata[1]->AppendItem("SIGFOND" , 90015);
  menudata[1]->AppendItem("SIGMA", 90012);
  menudata[1]->AppendItem("NSTAR", 90013);
  menudata[1]->AppendItem("FOND/MIN", 90014);

  optMenuccd     = new PIOptMenu    (this, menuccd, 80, 20, 290, 15); 
  optMenudata[0] = new PIOptMenu    (this, menudata[0], 100, 20, 120, 250); 
  optMenudata[1] = new PIOptMenu    (this, menudata[1], 100, 20, 440, 250); 
  optMenudata[1]->SetValue(90012);

  butupdate      = new PIButton     (this, "UPDATE", 5001, 80,20,560,15);

  labccd         = new PILabel      (this, "CCD :", 50, 20, 240, 15);
  labR           = new PILabel      (this, "Log R : ", 50, 20, 20, 3);
  labB           = new PILabel      (this, "Log B : ", 50, 20, 20, 20);
  labfileR       = new PILabel      (this, "FileR", 70, 20, 75, 3);
  labfileB       = new PILabel      (this, "FileB", 70, 20, 75, 20);
}

PIQualiteWin::~PIQualiteWin()
{
  delete labfileB;
  delete labfileR;
  delete labB;
  delete labR;
  delete labccd;
  delete optMenudata[0];
  delete optMenudata[1];
  delete menudata[0];
  delete menudata[1];
  delete optMenuccd;
  delete menuccd;
  delete monitoring1;
  delete monitoring2;
  delete butupdate;
}

void 
PIQualiteWin::UpdateInfo(LImageInfo linfor, LImageInfo linfob,
			 string labflnmr, string labflnmb)
{  
  linfoR = linfor;
  labfileR->SetLabel(labflnmr);
  
  linfoB = linfob;
  labfileB->SetLabel(labflnmb);
  
  monitoring1->SetData(linfoR, linfoB, var1, ccd);
  monitoring2->SetData(linfoR, linfoB, var2, ccd);
}

void 
PIQualiteWin::Process(long msg, PIMsgHandler *sender, void *data)
{
  switch (msg) {
  case 80100:
  case 80000: case 80001: case 80002: case 80003: 
  case 80004: case 80005: case 80006: case 80007:
    ccd = msg - 80000;
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90001:
    var1 = "FOND";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90002:
    var1 = "SIGMA";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90003:
    var1 = "NSTAR";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90004:
    var1 = "FOND/MIN";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90005:
    var1 = "SIGFOND";
    monitoring1->SetData(linfoR, linfoB, var1, ccd);
    break;
  case 90011:
    var2 = "FOND";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90012:
    var2 = "SIGMA";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90013:
    var2 = "NSTAR";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90014:
    var2 = "FOND/MIN";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;
  case 90015:
    var2 = "SIGFOND";
    monitoring2->SetData(linfoR, linfoB, var2, ccd);
    break;

  default:
    //cout << "Message " << msg << " non interprete" << endl;    
    ReSend(msg, sender, data);
  }   
}

//========================== classe PIQualiteMon ============================//

PIQualiteMon::PIQualiteMon(PIContainerGen *par, char *nom, 
			   int sx, int sy, int px, int py)
: PIScDrawWdg(par, nom, sx, sy, px, py)
{
  SetAxesFlags(kBoxAxes | kTicks | kLabels);
  ndataR = ndataB = nsepR = nsepB = 0;
  xR = xB = xsepR = xsepB = NULL;
  y1R = y1B = NULL;
  y2R = y2B = NULL;
}

PIQualiteMon::~PIQualiteMon()
{
 if (xR != NULL) delete[] xR;
 if (xB != NULL) delete[] xB;
 if (y1R != NULL) delete[] y1R;
 if (y1B != NULL) delete[] y1B;
 if (y2R != NULL) delete[] y2R;
 if (y2B != NULL) delete[] y2B;
}

void 
PIQualiteMon::SetData(LImageInfo linfoR, LImageInfo linfoB, string var, 
			   int ccd)
{
  // mise a zero des donnees deja existantes

  RAZData(linfoR, var, ndataR, nsepR, xR, y1R, y2R, xsepR);
  RAZData(linfoB, var, ndataB, nsepB, xB, y1B, y2B, xsepB);
  ndataR = ndataB = nsepR = nsepB = 0;

  // remplissage avec nouvelles valeurs 

  float valmin=100000, valmax=0, heuremin=36, heuremax=-36;
  FillData(linfoR, var, ccd, ndataR, nsepR, xR, y1R, y2R, xsepR, 
	   heuremin, heuremax, valmin, valmax);
  FillData(linfoB, var, ccd, ndataB, nsepB, xB, y1B, y2B, xsepB, 
	   heuremin, heuremax, valmin, valmax);
  float scaleh = heuremax-heuremin;
  float scalev = valmax-valmin;
  if (scaleh == 0) scaleh = 10;
  if (scalev == 0) scalev = 10;
  SetLimits(heuremin-scaleh/10, heuremax+scaleh/10,
	    valmin-scalev/10, valmax+scalev/10);

  Refresh();
}

void 
PIQualiteMon::RAZData(LImageInfo linfo, string var, int& ndata, int& nsep,
			   double*& x, double*& y1, double*& y2, double*& xsep)
{
  ndata = (int)linfo.size();
  nsep = (int)linfo.size();
  
  if (x  != NULL) { delete[] x;  x  = NULL; }
  if (y1 != NULL) { delete[] y1; y1 = NULL; }
  if (y2 != NULL) { delete[] y2; y2 = NULL; }
  if (xsep != NULL) { delete[] xsep; xsep = NULL; }
  if (ndata > 0) {
    if((x = new double[ndata]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour x\n");
      return;
    }
    if((y1 = new double[ndata]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y1\n");
      return;
    }
    if (var == "SIGMA") if((y2 = new double[ndata]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour y2\n");
      return;
    }
    if((xsep = new double[ndata]) == NULL) {
      printf("PIQualiteMon::SetData_Error memoire insuffisante pour xsep\n");
      return;
    }
  }
}

void 
PIQualiteMon::FillData(LImageInfo linfo, string var, int ccd, 
			    int& ndata, int& nsep, double*& x, double*& y1, 
			    double*& y2, double*& xsep, float& heuremin, 
			    float& heuremax, float& valmin, float& valmax)
{
  char time[10];
  float heure,min,sec;
  int objet = 0;
  for (LImageInfo::iterator i=linfo.begin(); i!=linfo.end(); i++) {
    if (!(*i).goodCCD) continue;
    if ((*i).nomimg.ccd == ccd || ccd == 100) {
      (*i).nomimg.date.GetTimeStr(time);
      sscanf(time, "%f:%f:%f", &heure, &min, &sec);
      heure = heure + min/60. + sec/3600.;
      if (heure > 12) heure -= 24; 
      x[ndata] = heure;
      if (heure > heuremax) heuremax = heure;
      if (heure < heuremin) heuremin = heure;
      if ((*i).nomimg.objet != objet) {
	if (objet != 0) {
	  xsep[nsep] = heure;
	  nsep++;
	}
	objet = (*i).nomimg.objet;
      }
      if (var == "FOND") {
	if((y1[ndata] = (*i).fond) == -1) continue;
      }
      else if (var == "SIGFOND") {
	if((y1[ndata] = (*i).sigFond) == -1) continue;
      }
      else if (var == "SIGMA") {
 	if((y1[ndata] = (*i).sigmaX) == -1) continue;
	if((y2[ndata] = (*i).sigmaY) == -1) continue;
	if (y2[ndata] > valmax) valmax = y2[ndata];
	if (y2[ndata] < valmin) valmin = y2[ndata] ;
      }
      else if (var == "NSTAR") {
	if((y1[ndata] = (*i).nStars) == -1) continue;
      }
      else if (var == "FOND/MIN") {
	if(((*i).tpos == 0) || ((*i).fond == -1)) continue;
	y1[ndata] = (*i).fond / (*i).tpos * 60;
      }
      if (y1[ndata] > valmax) valmax = y1[ndata];
      if (y1[ndata] < valmin) valmin = y1[ndata];
      ndata++;
    }
  }
}

void 
PIQualiteMon::DrawSelf()
{
  SelForeground(PI_Grey);
  SelLine(PI_ThinLine);
  for (int i=0;i<nsepR;i++) ScDrawLine(xsepR[i],-10000,xsepR[i],80000);
  for (int i=0;i<nsepB;i++) ScDrawLine(xsepB[i],-10000,xsepB[i],80000);
  SelMarker(5,PI_FCircleMarker);
  SelForeground(PI_Red);
  if(ndataR) for (int i=0;i<ndataR;i++) {
    ScDrawMarker(xR[i],y1R[i]);
    if(y2R != NULL) {
      SelMarker(5,PI_CrossMarker);
      ScDrawMarker(xR[i],y2R[i]);
      SelMarker(5,PI_FCircleMarker);
    }
  }
  SelMarker(5,PI_FCircleMarker);
  SelForeground(PI_Blue);
  if(ndataB) for (int i=0;i<ndataB;i++) {
    ScDrawMarker(xB[i],y1B[i]);
    if(y2B != NULL) {
      SelMarker(5,PI_CrossMarker);
      ScDrawMarker(xB[i],y2B[i]);
      SelMarker(5,PI_FCircleMarker);
    }
  }

  SelForeground(PI_Black);
  DrawString(235,194,"HEURE");
}







