// This may look like C code, but it is really -*- C++ -*-
// permet d'obtenir des informations sur les ressources utilisees
//                                R. Ansari - Juillet 2002
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef RESUSAGE_H_SEEN
#define RESUSAGE_H_SEEN

#include "machdefs.h"
#include <iostream.h>

namespace SOPHYA {

//! Acces to nformation about resource usage (memory, CPU, ...)

class ResourceUsage
{
public:
  ResourceUsage();
  ~ResourceUsage();

  int Update();

  // Memory usage in kilo-bytes  
  // NOTE: getDataSize() getStackSize() retournent des valeurs bizarres
  inline uint_8 getMemorySize() { return cur_rss; }
  inline uint_8 getMaxMemorySize() 
    { return((max_rss<max_datasz) ? max_rss : max_datasz); }
  inline uint_8 getDeltaMemorySize() { return delta_rss; }

  inline uint_8 getMaxDataSize() { return max_datasz; }
  inline uint_8 getDataSize() { return cur_datasz; }  
  inline uint_8 getMaxResidentSize() { return max_rss; }
  inline uint_8 getResidentSize() { return cur_rss; }
  inline uint_8 getMaxStackSize() { return max_stack; }
  inline uint_8 getStackSize() { return cur_stack; }

  
  // Time in milli-second
  inline uint_8 getCPUTime() { return cur_tottm; }
  inline uint_8 getElapsedTime() { return elapsed_time; }
  inline float  getAverageCPULoad() 
    { return ((elapsed_time>1) ? (float)cur_tottm/(float)elapsed_time: 1.);}

  inline uint_8 getDeltaCPUTime() { return delta_tottm; }
  inline uint_8 getDeltaElapsedTime() { return elapsed_time; }


  inline uint_8 getTotalCPUTime() { return cur_tottm; }
  inline uint_8 getUserCPUTime() { return cur_usrtm; }
  inline uint_8 getSysCPUTime() { return cur_systm; }


  void  Print(ostream& os, int lp=0, bool upd=true);
  inline void print(ostream& os, int lp=0, bool upd=true){ Print(os,lp,upd); }

protected:
  uint_8 max_datasz;  // Max data segment size (KBytes)
  uint_8 max_rss;     // Max resident size
  uint_8 max_stack;   // Max stack size

  uint_8 cur_datasz;  // Current data segment size
  uint_8 cur_rss;     // Current resident size
  uint_8 cur_stack;   // Current stack size

  uint_8 cur_tottm;   // Current total CPU-Time - in milli-second
  uint_8 cur_usrtm;   // Current user CPU-Time - in milli-second 
  uint_8 cur_systm;   // Current system CPU-Time - in milli-second 
  uint_8 elapsed_time; // Elapsed time - in milli-second
  uint_8 t0_time;      // time T0 in seconds 

  // Delta_values : difference since last call to Update()
  uint_8 delta_rss;     // Max resident size
  uint_8 delta_tottm;   // Delta total CPU-Time - in milli-second
 
  uint_8 delta_elapsed_time; // Elapsed time - in milli-second
 
};

inline ostream& operator << (ostream& os, ResourceUsage& ru)
{ ru.Print(os,0,true); return(os); }

} // namespace SOPHYA

#endif

