//#define TOISEQBUFFERED

#include <iostream.h>
#include <string>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "toi.h"
#include "cgt.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "toisegment.h"
#include "toiseqbuff.h"
#include "sambainit.h"
#include "toi2toi_addsp.h"
#include "timing.h"

#include <stdexcept>

void usage(void) {
 cout<<"tsttoi2toi_addsp [-h] [-p lp] [-s samplemin,samplemax] [-w data_window_size]"<<endl
     <<"           [-a label_coord1] [-d label_coord2] [-b label_bolomuv]"<<endl
     <<"           [-n nlat] [-i c,h] [-o c,h]"<<endl
     <<"           [-m vmin] [-M vmax] [-f flag]"<<endl
     <<"           fitsin_point fitsin_bolo fitsphout [fitsphwout]"<<endl
     <<" -p lp : print level (def=0)"<<endl
     <<" -s samplemin,samplemax : sample range to be treated (def=all)"<<endl
     <<" -w data_window_size : window size for pipe (def=8192)"<<endl
     <<" -a label_coord1 : label fits for alpha/gLong (def=coord1)"<<endl
     <<" -d label_coord2 : label fits for delta/gLat (def=coord2)"<<endl
     <<"          coord1 = alpha or gLong ; coord2 = delta or gLat"<<endl
     <<" -b label_bolo_in : label fits for bolo value (def=boloMuV)"<<endl
     <<" -n label_bolo_out : label fits for bolo value (def=boloMuV_sp)"<<endl
     <<" -u label_out : label fits for utc (def=UTC)"<<endl
     <<" -l label_out : label fits for longitude (def=longitude)"<<endl
     <<" -L label_out : label fits for latitude (def=latitude)"<<endl
     <<" -m vmin : samples are good if sample value >= vmin"<<endl
     <<" -M vmax : samples are good if sample value <= vmax"<<endl
     <<" -f flag : samples are bad if match flag"<<endl
     <<" fitsin_point : fits file for pointing"<<endl
     <<" fitsin_bolo : fits file for bolo values"<<endl
     <<" fitsin_utc : fits file for UTC values"<<endl
     <<" fitsin_lon : fits file for longitude values"<<endl
     <<" fitsin_lat : fits file for latitude values"<<endl
     <<" fitsout_bolo : fits file for output bolo value"<<endl;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

int_4 ns = 10;

TOIManager* mgr = TOIManager::getManager();
int wsize = 512; /// Segment size for TOISegmented 
bool fgsegmented = true;

//-- Decodage arguments
int lp = 0, width = 8192;
bool tflg=false, tmin=false, tmax=false;
r_8 vmin=-1.e30, vmax=1.e30; uint_8 badflg=0;
char * label_coord1 = "coord1";
char * label_coord2 = "coord2";
char * label_bolo_in = "boloMuV";
char * label_bolo_out = "boloMuV_sp";
char * label_utc= "UTC";
char * label_lon = "longitude";
char * label_lat = "latitude";
double equi=2000.;
char *tcoorin="gdcdl", *tcoormap="g";
long sdeb,sfin;

int c;
while((c = getopt(narg,arg,"hIp:s:w:a:d:b:n:i:o:m:M:f:e:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
    //else {cout<<"Bad sample interval "<<endl; exit(2);}
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'a' :
    label_coord1 = optarg;
    break;
  case 'd' :
    label_coord2 = optarg;
    break;
  case 'b' :
    label_bolo_in = optarg;
    break;
  case 'n' :
    label_bolo_out = optarg;
    break;
  case 'u' :
    label_utc = optarg;
    break;
  case 'l' :
    label_lon = optarg;
    break;
  case 'L' :
    label_lat = optarg;
    break;
  case 'i' :
    tcoorin=optarg;
    break;
  case 'o' :
    tcoormap=optarg;
    break;
  case 'e' :
    sscanf(optarg,"%lf",&equi);
    break;
  case 'm' :
    sscanf(optarg,"%lf",&vmin);
    tmin = true;
    break;
  case 'M' :
    sscanf(optarg,"%lf",&vmax);
    tmax = true;
    break;
  case 'f' :
    sscanf(optarg,"%ul",&badflg);
    tflg = true;
    break;
  case 'h' :
  default:
    usage(); exit(1);
    break;
  }
}
if(optind+5>=narg) {usage(); exit(3);}
 
char * fitsin_point = arg[optind];
char * fitsin_bolo = arg[optind+1];
char * fitsin_utc = arg[optind+2];
char * fitsin_lon = arg[optind+3];
char * fitsin_lat = arg[optind+4];
char * fitsout = arg[optind+5];

cout<<">>>> tsttoi2toi_addsp:"<<endl
    <<"Pipe Window Size "<<width<<endl
    <<"Fits Infile Bolo "<<fitsin_bolo<<endl
    <<"  ...label_bolo_in "<<label_bolo_in<<endl
    <<"Fits Infile Utc "<<fitsin_utc<<endl
    <<"  ...label_utc "<<label_utc<<endl
    <<"Fits Infile Lon "<<fitsin_lon<<endl
    <<"  ...label_lon "<<label_lon<<endl
    <<"Fits Infile Lat "<<fitsin_lat<<endl
    <<"  ...label_lat "<<label_lat<<endl;
cout<<"Fits Infile Pointing "<<fitsin_point<<endl
    <<"  ...label_coord1 "<<label_coord1<<endl
    <<"  ...label_coord2 "<<label_coord2<<endl
    <<"  ...... ctype="<<tcoorin<<endl;
cout<<"Fits Outfile Bolo "<<fitsout<<endl
    <<"  ...label_bolo_out "<<label_bolo_out<<endl;

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------
  cout << wsize << " ok ! " << endl;
  
  CGT plombier(fgsegmented,wsize);
  plombier.SetDebugLevel(99);
  
 // FITS reader
  FITSTOIReader rfitsb(fitsin_bolo);
  FITSTOIReader rfitsp(fitsin_point);
  FITSTOIReader rfitsu(fitsin_utc);
  FITSTOIReader rfitsl(fitsin_lon);
  FITSTOIReader rfitsL(fitsin_lat);
  FITSTOIWriter wfits(fitsout);

  Info_src* scr;
  Toi2toi_Addsp::Fill_Info_scr(scr,ns);
 
 // TOI Processor
//   Toi2toi_Addsp toi2t_sp(scr,ns);
//   cout<<"Toi2toi_Addsp created"<<endl;

//   toi2t_sp.SetEquinox(equi);
//   toi2t_sp.SetCoorIn(tcoorin);
//   toi2t_sp.SetCoorMap(tcoormap);
//   toi2t_sp.SetTestFlag(tflg,badflg);
//   toi2t_sp.SetTestMin(tmin,vmin);
//   toi2t_sp.SetTestMax(tmax,vmax);
//   toi2t_sp.Print(cout);

 // Definition des tuyaux
 
 // pb dans  prout.addOutput(out, toi);
 cout << " tout va bien " <<label_coord2 << endl;

 plombier.Connect(rfitsp,label_coord1,wfits,label_bolo_out);

 //pb dans chkinit(); dans  afterinit()
//   plombier.Connect(rfitsp,label_coord2,toi2t_sp,"Coord2In");
//   plombier.Connect(rfitsp,label_coord1,toi2t_sp,"Coord1In");

//   plombier.Connect(rfitsb,label_bolo_in,toi2t_sp,"BoloIn");

//   plombier.Connect(rfitsu,label_utc,toi2t_sp,"utc");
//   plombier.Connect(rfitsl,label_lon,toi2t_sp,"lon");
//   plombier.Connect(rfitsL,label_lat,toi2t_sp,"lat");

//   plombier.Connect(toi2t_sp,"BoloOut",wfits,label_bolo_out);
 // plombier.Connect(rfitsp,label_coord1,wfits,label_bolo_out);
 cout << " tout va bien " <<label_coord2 << endl;

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;

 plombier.Start();
 plombier.ListTOIs(cout, 1);
 cout << "Joining ..." << endl;
 mgr->joinAll();
 PrtTim("End threads");



//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2toi_addsp: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2toi_addsp: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2toi_addsp: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}

