#ifndef FITSAUTOREADER_SEEN
#define FITSAUTOREADER_SEEN


// Guy Le Meur 11/2000

#include "machdefs.h"
#include "anydataobj.h"
#include "fitsfile.h"
#include "fitstarray.h"
#include "fitsspherehealpix.h"
#include "fitsntuple.h"
#include "fitsxntuple.h"
#include "fitslocalmap.h"
#include "fbtntintf.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////////////////
// ------------- Classe pour la gestion de persistance I/O format fits--
// des objets
//////////////////////////////////////////////////////////////////////


class FITS_AutoReader 
{
public:

FITS_AutoReader();
FITS_AutoReader(const char inputfile[]);
FITS_AutoReader(string const & inputfile);
virtual ~FITS_AutoReader();
 int NbBlocks();

 // parametre toutCharger : uniquement pour les BINTABLE et s'il ne
 // s'agit pas explicitement d'un objet SOPHYA, on charge toute la 
 // table en memoire sous forme d'un xntuple si toutCharger= true.
 // et si le nombre d'entrees est superieur a 1000.
 // sinon (c-a-d : il ne s'agit pas d'un objet connu de SOPHYA
 //                c'est une BINTABLE avec plus de 1000 entrees
 //                totuCharger = false)
 // on ouvre une FitsBTNtuIntf (lecture ulterieure, bufferisee, des valeurs)
AnyDataObj* ReadObject(int hdunum, bool toutCharger = false) const;


private :

AnyDataObj* newTArray() const;
AnyDataObj* newSphereHEALPix() const;
AnyDataObj* newLocalMap() const;
NTuple* newNTuple() const;
XNTuple* newXNTuple() const;
 FitsBTNtuIntf* newFitsBTNtuIntf(int hdunum) const;
inline void InitNull()
   {
     inFits_ = NULL;
     dobj_ = NULL;
     ownobj_ = false;
   }


 string filename_;
FitsInFile* inFits_;
AnyDataObj* dobj_;
bool ownobj_;

};
} // Fin du namespace

#endif
