// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toimanager.h,v 1.14 2002-07-26 08:52:43 vfebvre Exp $


#ifndef TOIMANAGER_H
#define TOIMANAGER_H

#include "config.h"
#include <string>
#include <vector>

#include "toiprocessor.h"

using namespace std;

class TOIManager {
public:
  static TOIManager* getManager();
  void setRequestedSample(int begin, int end);
  int getRequestedBegin();
  int getRequestedEnd();
  
  void startAll();
  void waitForAll();

  void joinAll();  // deprecated. Use waitForAll();
   
protected:
  TOIManager();
  static TOIManager* instance;
  long reqBegin;
  long reqEnd;

  vector<pthread_t*> threads;
  void addThread(pthread_t*);

  vector<TOIProcessor*> processors;
  void registerProcessor(TOIProcessor* proc);


  friend class TOIProcessor;
};

// -----------------------------------------------------------------
//    Classe pour affichage de l'avancement des TOIProcessors 
//                         Reza 08/2001 
// -----------------------------------------------------------------

class RzProcSampleCounter {
public:
  RzProcSampleCounter();
  virtual       ~RzProcSampleCounter();
  virtual long  ProcessedSampleCount() = 0;
  virtual long  SampleBegin() = 0;
  virtual long  SampleEnd() = 0;
  virtual long  PrintStats();
  inline int &  PrintRate(int pr) { return _rate; } 
  inline string& InfoMessage() { return _msg; } 
protected:
  int _rate;
  string _msg;
};

template <class T>
class ProcSampleCounter : public RzProcSampleCounter {
public:
  ProcSampleCounter(T & t) { _t = &t; } 
  virtual long  ProcessedSampleCount()
  { return _t->ProcessedSampleCount(); }
  virtual long  SampleBegin() { return _t->getMinIn(); }
  virtual long  SampleEnd() { return _t->getMaxIn(); }
protected:
  T * _t;
};

#endif























